/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.node.NullNode;
import com.predic8.membrane.core.openapi.OpenAPIParsingException;
import com.predic8.membrane.core.openapi.model.Body;
import com.predic8.membrane.core.openapi.util.SchemaUtil;
import com.predic8.membrane.core.openapi.validators.AllOfValidator;
import com.predic8.membrane.core.openapi.validators.AnyOfValidator;
import com.predic8.membrane.core.openapi.validators.ArrayValidator;
import com.predic8.membrane.core.openapi.validators.BooleanValidator;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.IntegerValidator;
import com.predic8.membrane.core.openapi.validators.NotValidator;
import com.predic8.membrane.core.openapi.validators.NumberRestrictionValidator;
import com.predic8.membrane.core.openapi.validators.NumberValidator;
import com.predic8.membrane.core.openapi.validators.ObjectValidator;
import com.predic8.membrane.core.openapi.validators.OneOfValidator;
import com.predic8.membrane.core.openapi.validators.StringRestrictionValidator;
import com.predic8.membrane.core.openapi.validators.StringValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator
implements IJSONSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger((String)SchemaValidator.class.getName());
    private Schema schema;
    private final OpenAPI api;

    public SchemaValidator(OpenAPI api, Schema schema) {
        if (schema == null) {
            throw new OpenAPIParsingException("Could not parse OpenAPI");
        }
        this.schema = schema;
        this.api = api;
    }

    @Override
    public String canValidate(Object obj) {
        return null;
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        Object value;
        ValidationErrors errors = new ValidationErrors();
        if (obj == null) {
            return errors.add(ctx, "Got null to validate!");
        }
        try {
            value = this.resolveValueAndParseJSON(obj);
        }
        catch (IOException e) {
            log.warn("Cannot parse body. " + String.valueOf(e));
            return errors.add(new ValidationError(ctx.statusCode(400).entityType(ValidationContext.ValidatedEntityType.BODY).entity("REQUEST"), "Request body cannot be parsed as JSON"));
        }
        if (this.schema.getAllOf() != null) {
            errors.add(new AllOfValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.getAnyOf() != null) {
            errors.add(new AnyOfValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.getOneOf() != null) {
            errors.add(new OneOfValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.getNot() != null) {
            errors.add(new NotValidator(this.api, this.schema).validate(ctx, obj));
        }
        if (this.schema.get$ref() != null && !SchemaUtil.getSchemaNameFromRef(this.schema).equals(ctx.getComplexType())) {
            ctx = ctx.complexType(SchemaUtil.getSchemaNameFromRef(this.schema));
            this.schema = SchemaUtil.getSchemaFromRef(this.api, this.schema);
            if (this.schema == null) {
                throw new RuntimeException("Should not happen!");
            }
        }
        if (this.schemaHasNoTypeAndTypes(this.schema.getType())) {
            if ((value == null || value instanceof NullNode) && this.isNullable()) {
                return ValidationErrors.create(ctx, "Value is null and no type is set.");
            }
        } else if ((value == null || value instanceof NullNode) && this.isNullable()) {
            return errors;
        }
        errors.add(new StringRestrictionValidator(this.schema).validate(ctx, value));
        errors.add(new NumberRestrictionValidator(this.schema).validate(ctx, value));
        errors.add(this.validateByType(ctx, value));
        return errors;
    }

    private boolean isNullable() {
        return this.schema.getNullable() != null && this.schema.getNullable() != false || this.schema.getTypes().contains("null");
    }

    private ValidationErrors validateByType(ValidationContext ctx, Object value) {
        String type = this.schema.getType();
        if (this.schemaHasNoTypeAndTypes(type)) {
            return null;
        }
        if (type != null) {
            return this.validateSingleType(ctx, value, type);
        }
        return this.validateMultipleTypes(new ArrayList<String>(this.schema.getTypes()), ctx, value);
    }

    @Nullable
    private ValidationErrors validateMultipleTypes(List<String> types, ValidationContext ctx, Object value) {
        String typeOfValue = SchemaValidator.getTypeOfValue(types, value);
        ValidationErrors errors = this.getTypeNotMatchError(types, ctx, value, typeOfValue);
        if (errors != null) {
            return errors;
        }
        return this.validateSingleType(ctx, value, typeOfValue);
    }

    @Nullable
    private ValidationErrors getTypeNotMatchError(List<String> types, ValidationContext ctx, Object value, String typeOfValue) {
        if (typeOfValue == null || !types.contains(typeOfValue)) {
            return ValidationErrors.create(ctx, "%s is of type %s which does not match any of %s".formatted(value, typeOfValue, types));
        }
        return null;
    }

    @Nullable
    private static String getTypeOfValue(List<String> types, Object value) {
        String typeOfValue = SchemaValidator.getType(value);
        if (Objects.equals(typeOfValue, "integer") && !types.contains(typeOfValue) && types.contains("number")) {
            return "number";
        }
        return typeOfValue;
    }

    private static String getType(Object obj) {
        return SchemaValidator.getValidatorClasses().stream().map(validator -> validator.canValidate(obj)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private ValidationErrors validateSingleType(ValidationContext ctx, Object value, String type) {
        try {
            return switch (type) {
                case "number" -> new NumberValidator().validate(ctx, value);
                case "integer" -> new IntegerValidator().validate(ctx, value);
                case "string" -> new StringValidator(this.schema).validate(ctx, value);
                case "boolean" -> new BooleanValidator().validate(ctx, value);
                case "array" -> new ArrayValidator(this.api, this.schema).validate(ctx, value);
                case "object" -> new ObjectValidator(this.api, this.schema).validate(ctx, value);
                default -> throw new RuntimeException("Should not happen! " + type);
            };
        }
        catch (Exception e) {
            return ValidationErrors.create(ctx, "%s is not of %s format.".formatted(value, type));
        }
    }

    private boolean schemaHasNoTypeAndTypes(String type) {
        return type == null && (this.schema.getTypes() == null || this.schema.getTypes().isEmpty());
    }

    private static List<IJSONSchemaValidator> getValidatorClasses() {
        return List.of(new IntegerValidator(), new NumberValidator(), new StringValidator(null), new BooleanValidator(), new ArrayValidator(null, null), new ObjectValidator(null, null));
    }

    private Object resolveValueAndParseJSON(Object obj) throws IOException {
        if (obj instanceof Body) {
            return ((Body)obj).getJson();
        }
        if (obj instanceof InputStream) {
            throw new RuntimeException("InputStream!");
        }
        return obj;
    }
}

