/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.IJSONSchemaValidator;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import com.predic8.membrane.core.openapi.validators.ValidationErrors;
import io.swagger.v3.oas.models.media.Schema;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringValidator
implements IJSONSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger((String)StringValidator.class.getName());
    private final Schema schema;

    public StringValidator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String canValidate(Object obj) {
        JsonNode node;
        if (obj instanceof JsonNode && JsonNodeType.STRING.equals((Object)(node = (JsonNode)obj).getNodeType())) {
            return "string";
        }
        if (obj instanceof String) {
            return "string";
        }
        return null;
    }

    @Override
    public ValidationErrors validate(ValidationContext ctx, Object obj) {
        String value;
        ctx = ctx.schemaType("string");
        ValidationErrors errors = new ValidationErrors();
        if (obj == null) {
            errors.add(new ValidationError(ctx, "String expected but got null."));
            return errors;
        }
        if (obj instanceof JsonNode) {
            JsonNode node = (JsonNode)obj;
            if (!JsonNodeType.STRING.equals((Object)node.getNodeType())) {
                errors.add(ctx, String.format("String expected but got %s of type %s", node, node.getNodeType()));
                return errors;
            }
            value = node.textValue();
        } else if (obj instanceof String) {
            String s;
            value = s = (String)obj;
        } else {
            throw new RuntimeException("Should not happen! " + String.valueOf(obj.getClass()));
        }
        if (this.schema.getFormat() != null) {
            switch (this.schema.getFormat()) {
                case "uuid": {
                    if (Utils.isValidUUID(value)) break;
                    errors.add(ctx, String.format("The string '%s' is not a valid UUID.", value));
                    break;
                }
                case "email": {
                    if (Utils.isValidEMail(value)) break;
                    errors.add(ctx, String.format("The string '%s' is not a valid email.", value));
                    break;
                }
                case "uri": {
                    if (Utils.isValidUri(value)) break;
                    errors.add(ctx, String.format("The string '%s' is not a valid URI.", value));
                    break;
                }
                case "date": {
                    if (Utils.isValidDate(value)) break;
                    errors.add(ctx, String.format("The string '%s' is not a valid date of the pattern YYYY-MM-DD.", value));
                    break;
                }
                case "date-time": {
                    if (Utils.isValidDateTime(value)) break;
                    errors.add(ctx, String.format("The string '%s' is not a valid date-time according to ISO 8601.", value));
                    break;
                }
                case "ip": {
                    if (!Utils.isValidIp(value)) {
                        errors.add(ctx, String.format("The string '%s' is not a valid ip address.", value));
                    }
                }
                default: {
                    log.warn("Unknown string format of {}.", (Object)this.schema.getFormat());
                }
            }
        }
        if (this.schema.getConst() != null && !this.schema.getConst().equals(value)) {
            errors.add(ctx, String.format("The string '%s' does not match the const %s.", value, this.schema.getConst()));
        } else if (this.schema.getEnum() != null && !this.schema.getEnum().contains(value)) {
            errors.add(ctx, String.format("The string '%s' does not contain a value from the enum %s.", value, this.getEnumValues()));
        }
        if (this.schema.getPattern() != null && !this.matchRegexPattern(value)) {
            errors.add(ctx, String.format("The string '%s' does not match the regex pattern %s.", value, this.schema.getPattern()));
        }
        return errors;
    }

    private String getEnumValues() {
        return String.join((CharSequence)",", this.schema.getEnum());
    }

    private boolean matchRegexPattern(String v) {
        return Pattern.compile(this.schema.getPattern()).matcher(v).matches();
    }
}

