/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.openapi.validators;

import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.openapi.validators.ValidationContext;
import com.predic8.membrane.core.openapi.validators.ValidationError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class ValidationErrors {
    private final List<ValidationError> errors = new ArrayList<ValidationError>();

    public static ValidationErrors create(ValidationContext ctx, String message) {
        ValidationErrors ve = new ValidationErrors();
        ve.add(ctx, message);
        return ve;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public ValidationErrors add(ValidationError error) {
        if (error != null) {
            this.errors.add(error);
        }
        return this;
    }

    public void add(List<ValidationError> errors) {
        this.errors.addAll(errors);
    }

    public ValidationErrors add(ValidationErrors ve) {
        if (ve != null) {
            this.errors.addAll(ve.errors);
        }
        return this;
    }

    public ValidationErrors add(ValidationContext ctx, String message) {
        this.errors.add(new ValidationError(ctx, message));
        return this;
    }

    public int size() {
        return this.errors.size();
    }

    public static ValidationErrors empty() {
        return new ValidationErrors();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public ValidationError get(int i) {
        return this.errors.get(i);
    }

    public Stream<ValidationError> stream() {
        return this.errors.stream();
    }

    public Map<String, Object> getErrorMessage(Direction direction) {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        if (this.errors.isEmpty()) {
            root.put("message", "No validation errors!");
            return root;
        }
        Map<String, List<Map<String, Object>>> m = this.getValidationErrorsGroupedByLocation(direction);
        ValidationContext ctx = this.errors.getFirst().getContext();
        Utils.setFieldIfNotNull(root, "method", ctx.getMethod());
        Utils.setFieldIfNotNull(root, "uriTemplate", ctx.getUriTemplate());
        Utils.setFieldIfNotNull(root, "path", ctx.getPath());
        root.put("errors", m);
        return root;
    }

    private Map<String, List<Map<String, Object>>> getValidationErrorsGroupedByLocation(Direction direction) {
        HashMap<String, List<Map<String, Object>>> m = new HashMap<String, List<Map<String, Object>>>();
        this.errors.forEach(ve -> {
            ArrayList<Map<String, Object>> ves = new ArrayList<Map<String, Object>>();
            ves.add(ve.getContentMap());
            m.merge(this.getLocationFor(direction, (ValidationError)ve), ves, (vesOld, vesNew) -> {
                vesOld.addAll(vesNew);
                return vesOld;
            });
        });
        return m;
    }

    private String getLocationFor(Direction direction, ValidationError ve) {
        if (direction.equals((Object)Direction.REQUEST)) {
            return ve.getContext().getLocationForRequest();
        }
        return ve.getContext().getLocationForResponse();
    }

    public boolean hasErrors() {
        return this.size() > 0;
    }

    public String toString() {
        return "ValidationErrors{errors=" + String.valueOf(this.errors) + "}";
    }

    public static enum Direction {
        REQUEST,
        RESPONSE;

    }
}

