/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.InterceptorUtil;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.RuleKey;
import com.predic8.membrane.core.stats.RuleStatisticCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxy
implements Proxy {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractProxy.class.getName());
    protected String name = "";
    protected RuleKey key;
    protected volatile boolean blockRequest;
    protected volatile boolean blockResponse;
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private final RuleStatisticCollector ruleStatisticCollector = new RuleStatisticCollector();
    private boolean active;
    private String error;
    protected Router router;

    public AbstractProxy() {
    }

    public AbstractProxy(RuleKey ruleKey) {
        this.key = ruleKey;
    }

    protected <T extends Interceptor> Optional<T> getFirstInterceptorOfType(Class<T> type) {
        return InterceptorUtil.getFirstInterceptorOfType(this.interceptors, type);
    }

    @Override
    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @MCChildElement(allowForeign=true, order=100)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public String getName() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.name, (CharSequence)(this.getKey() != null ? this.getKey().toString() : ""));
    }

    @Override
    public RuleKey getKey() {
        return this.key;
    }

    @Override
    public boolean isBlockRequest() {
        return this.blockRequest;
    }

    @Override
    public boolean isBlockResponse() {
        return this.blockResponse;
    }

    @Override
    @MCAttribute
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setKey(RuleKey ruleKey) {
        this.key = ruleKey;
    }

    @Override
    @MCAttribute
    public void setBlockRequest(boolean blockStatus) {
        this.blockRequest = blockStatus;
    }

    @Override
    @MCAttribute
    public void setBlockResponse(boolean blockStatus) {
        this.blockResponse = blockStatus;
    }

    @Override
    public final void init(Router router) {
        this.router = router;
        try {
            this.init();
            for (Interceptor i : this.interceptors) {
                i.init(router);
            }
            this.active = true;
        }
        catch (Exception e) {
            if (!router.isRetryInit()) {
                throw e;
            }
            log.error("", (Throwable)e);
            this.active = false;
            this.error = e.getMessage();
        }
    }

    public void init() {
    }

    @Override
    public boolean isTargetAdjustHostHeader() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getErrorState() {
        return this.error;
    }

    @Override
    public AbstractProxy clone() throws CloneNotSupportedException {
        AbstractProxy clone = (AbstractProxy)super.clone();
        try {
            clone.init(this.router);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    @Override
    public RuleStatisticCollector getStatisticCollector() {
        return this.ruleStatisticCollector;
    }

    @Override
    public String getProtocol() {
        return "unknown";
    }

    public String toString() {
        return this.getName();
    }
}

