/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.proxies.RuleKey;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleKey
implements RuleKey {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractRuleKey.class.getName());
    protected int port;
    private String path;
    protected volatile Pattern pathPattern;
    protected boolean pathRegExp = true;
    protected boolean usePathPattern;
    protected String ip;

    public AbstractRuleKey(int port, String ip) {
        this.port = port;
        this.ip = ip;
    }

    public AbstractRuleKey(RuleKey key) {
        this.port = key.getPort();
        this.path = key.getPath();
        this.usePathPattern = key.isUsePathPattern();
        this.ip = key.getIp();
        if (key instanceof AbstractRuleKey) {
            AbstractRuleKey arKey = (AbstractRuleKey)key;
            this.pathRegExp = arKey.getPathRegExp();
            if (this.pathRegExp) {
                this.pathPattern = arKey.getPathPattern();
            }
        }
    }

    @Override
    public String getHost() {
        return "";
    }

    @Override
    public String getMethod() {
        return "";
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isHostWildcard() {
        return false;
    }

    @Override
    public boolean isMethodWildcard() {
        return false;
    }

    @Override
    public boolean isPathRegExp() {
        return this.pathRegExp;
    }

    public boolean getPathRegExp() {
        return this.pathRegExp;
    }

    @Override
    public void setPathRegExp(boolean pathRegExp) {
        this.pathRegExp = pathRegExp;
    }

    @Override
    public boolean isUsePathPattern() {
        return this.usePathPattern;
    }

    @Override
    public void setUsePathPattern(boolean usePathPattern) {
        this.usePathPattern = usePathPattern;
        this.pathPattern = null;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
        this.pathPattern = null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean matchesPath(String path) {
        if (this.isPathRegExp()) {
            return this.matchesPathPattern(path);
        }
        return path.startsWith(this.path);
    }

    private boolean matchesPathPattern(String path) {
        log.debug("matches path: {} with path pattern: {}", (Object)path, (Object)this.getPathPattern());
        return this.getPathPattern().matcher(path).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern getPathPattern() {
        if (this.pathPattern != null) {
            return this.pathPattern;
        }
        AbstractRuleKey abstractRuleKey = this;
        synchronized (abstractRuleKey) {
            if (this.pathPattern != null) {
                return this.pathPattern;
            }
            this.pathPattern = Pattern.compile(this.computePathPattern(this.path));
        }
        return this.pathPattern;
    }

    private String computePathPattern(String path) {
        return path != null ? path : ".*";
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Override
    public boolean matchesHostHeader(String hostHeader) {
        return false;
    }

    @Override
    public boolean matchesVersion(String version) {
        return !"STOMP".equals(version);
    }

    @Override
    public boolean complexMatch(Exchange exc) {
        return true;
    }
}

