/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.Path;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.proxies.AbstractRuleKey;
import com.predic8.membrane.core.proxies.RuleKey;
import com.predic8.membrane.core.proxies.SSLableProxy;
import com.predic8.membrane.core.proxies.ServiceProxyKey;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;

public abstract class AbstractServiceProxy
extends SSLableProxy {
    protected Target target = new Target();

    @Override
    public void init() {
        super.init();
        if (this.target.port == -1) {
            int n = this.target.port = this.target.getSslParser() != null ? 443 : 80;
        }
        if (this.target.getSslParser() != null) {
            this.setSslOutboundContext(new StaticSSLContext(this.target.getSslParser(), this.router.getResolverMap(), this.router.getBaseLocation()));
        }
    }

    public String getHost() {
        return this.key.getHost();
    }

    @MCAttribute
    public void setHost(String host) {
        RuleKey ruleKey = this.key;
        if (!(ruleKey instanceof ServiceProxyKey)) {
            return;
        }
        ServiceProxyKey sp = (ServiceProxyKey)ruleKey;
        sp.setHost(host);
    }

    public Path getPath() {
        RuleKey ruleKey = this.key;
        if (!(ruleKey instanceof AbstractRuleKey)) {
            return null;
        }
        AbstractRuleKey ark = (AbstractRuleKey)ruleKey;
        if (!ark.isUsePathPattern()) {
            return null;
        }
        return new Path(ark.isPathRegExp(), ark.getPath());
    }

    @MCChildElement(order=50)
    public void setPath(Path path) {
        AbstractRuleKey k = (AbstractRuleKey)this.key;
        k.setUsePathPattern(path != null);
        if (path != null) {
            k.setPathRegExp(path.isRegExp());
            k.setPath(path.getValue());
        }
    }

    public Target getTarget() {
        return this.target;
    }

    @MCChildElement(order=150)
    public void setTarget(Target target) {
        this.target = target;
    }

    public String getTargetScheme() {
        return this.getSslOutboundContext() != null ? "https" : "http";
    }

    public String getTargetHost() {
        return this.target.getHost();
    }

    public int getTargetPort() {
        return this.target.getPort();
    }

    public String getTargetURL() {
        return this.target.getUrl();
    }

    public SSLParser getTargetSSL() {
        return this.target.getSslParser();
    }

    @Override
    public boolean isTargetAdjustHostHeader() {
        return this.target.isAdjustHostHeader();
    }

    @MCElement(name="target", topLevel=false)
    public static class Target {
        private String host;
        private int port = -1;
        private String method;
        protected String url;
        private boolean adjustHostHeader = true;
        private SSLParser sslParser;

        public Target() {
        }

        public Target(String host) {
            this.setHost(host);
        }

        public Target(String host, int port) {
            this.setHost(host);
            this.setPort(port);
        }

        public String getHost() {
            return this.host;
        }

        @MCAttribute
        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        @MCAttribute
        public void setPort(int port) {
            this.port = port;
        }

        public String getUrl() {
            return this.url;
        }

        @MCAttribute
        public void setUrl(String url) {
            this.url = url;
        }

        public SSLParser getSslParser() {
            return this.sslParser;
        }

        @MCChildElement(allowForeign=true)
        public void setSslParser(SSLParser sslParser) {
            this.sslParser = sslParser;
        }

        public boolean isAdjustHostHeader() {
            return this.adjustHostHeader;
        }

        @MCAttribute
        public void setAdjustHostHeader(boolean adjustHostHeader) {
            this.adjustHostHeader = adjustHostHeader;
        }

        public String getMethod() {
            return this.method;
        }

        @MCAttribute
        public void setMethod(String method) {
            this.method = method;
        }
    }
}

