/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.core.RuleManager;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.proxies.InternalProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SOAPProxy;
import com.predic8.membrane.core.proxies.ServiceProxy;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDisplayInfo {
    private static final Logger log = LoggerFactory.getLogger((String)ProxyDisplayInfo.class.getName());
    private static final int INDENT = 55;

    public static void logInfosAboutStartedProxies(RuleManager manager) {
        log.info("Started {} API{}:", (Object)manager.getRules().size(), (Object)(manager.getRules().size() > 1 ? "s" : ""));
        manager.getRules().forEach(proxy -> log.info("  {} {}{}", new Object[]{ProxyDisplayInfo.proxyDisplayName(proxy), proxy.getName(), ProxyDisplayInfo.additionalProxyInfo(proxy)}));
    }

    private static String additionalProxyInfo(Proxy proxy) {
        if (proxy instanceof APIProxy) {
            APIProxy a = (APIProxy)proxy;
            Map<String, OpenAPIRecord> recs = a.getApiRecords();
            if (!recs.isEmpty()) {
                return " using OpenAPI specifications:\n" + ProxyDisplayInfo.formatLocationInfo(recs);
            }
        } else if (proxy instanceof SOAPProxy) {
            SOAPProxy s = (SOAPProxy)proxy;
            return " %s\n    using WSDL @ %s".formatted(ProxyDisplayInfo.getPathString(s), s.getWsdl());
        }
        return "";
    }

    private static String getPathString(SOAPProxy s) {
        if (s.getPath() != null) {
            return s.getPath().getValue();
        }
        return "";
    }

    @NotNull
    private static String getPath(Proxy proxy) {
        String path = proxy.getKey().getPath();
        return path != null ? path : "";
    }

    @Nullable
    private static String getHost(Proxy proxy) {
        String host = proxy.getKey().getHost();
        return Objects.equals(host, "*") ? ProxyDisplayInfo.getIP(proxy) : host;
    }

    @NotNull
    private static String getIP(Proxy proxy) {
        String ip = proxy.getKey().getIp();
        if (ip == null) {
            return "0.0.0.0";
        }
        return ip;
    }

    private static String formatLocationInfo(Map<String, OpenAPIRecord> specs) {
        return specs.entrySet().stream().map(e -> " ".repeat(55) + "- \"%s\" @ %s".formatted(e.getKey(), ((OpenAPIRecord)e.getValue()).getSpec().getLocation())).collect(Collectors.joining("\n"));
    }

    private static String proxyDisplayName(Proxy proxy) {
        if (proxy instanceof APIProxy) {
            return "API";
        }
        if (proxy instanceof ServiceProxy) {
            return "Service";
        }
        if (proxy instanceof SOAPProxy) {
            return "SOAP";
        }
        if (proxy instanceof InternalProxy) {
            return "Internal";
        }
        return "Proxy";
    }
}

