/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.interceptor.WSDLInterceptor;
import com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor;
import com.predic8.membrane.core.interceptor.server.WSDLPublisherInterceptor;
import com.predic8.membrane.core.interceptor.soap.WebServiceExplorerInterceptor;
import com.predic8.membrane.core.openapi.util.UriUtil;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.SOAPProxyMultipleServicesException;
import com.predic8.membrane.core.proxies.ServiceProxyKey;
import com.predic8.membrane.core.resolver.HTTPSchemaResolver;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.URLUtil;
import com.predic8.wsdl.AbstractBinding;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.Port;
import com.predic8.wsdl.Service;
import com.predic8.wsdl.WSDLElement;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.WSDLParserContext;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="soapProxy")
public class SOAPProxy
extends AbstractServiceProxy {
    private static final Logger log = LoggerFactory.getLogger((String)SOAPProxy.class.getName());
    private static final Pattern relativePathPattern = Pattern.compile("^./[^/?]*\\?");
    protected String wsdl;
    protected String portName;
    protected HttpClientConfiguration httpClientConfig;
    protected String serviceName;
    protected ResolverMap resolverMap;
    private int automaticallyAddedInterceptorCount;

    public SOAPProxy() {
        this.key = new ServiceProxyKey(80);
    }

    @Override
    public void init() {
        this.resolverMap = this.router.getResolverMap();
        if (this.httpClientConfig != null) {
            HTTPSchemaResolver httpSR = new HTTPSchemaResolver(this.router.getHttpClientFactory());
            httpSR.setHttpClientConfig(this.httpClientConfig);
            this.resolverMap = this.resolverMap.clone();
            this.resolverMap.addSchemaResolver(httpSR);
        }
        this.configureFromWSDL();
        super.init();
    }

    protected void configureFromWSDL() {
        Definitions definitions = this.parseWSDLOnly();
        Service service = this.getService(definitions);
        this.setProxyName(service, definitions);
        String location = this.getLocation(service);
        if (location.startsWith("https")) {
            this.target.setSslParser(new SSLParser());
        }
        this.prepareRouting(location);
        while (this.automaticallyAddedInterceptorCount > 0) {
            this.interceptors.removeFirst();
            --this.automaticallyAddedInterceptorCount;
        }
        this.addWebServiceExplorer();
        this.addWSDLPublisherInterceptor();
        this.addWSDLInterceptor();
        this.renameMe();
    }

    private Definitions parseWSDLOnly() {
        try {
            return this.getWsdlParser().parse(this.getWsdlParserContext());
        }
        catch (Exception e) {
            String msg = "Could not parse WSDL from %s.".formatted(this.getWsdlParserContext().getInput());
            log.error("{}: {}", (Object)msg, (Object)e.getMessage());
            throw new ConfigurationException(msg, e);
        }
    }

    private void prepareRouting(String location) {
        try {
            URL url = new URL(location);
            this.setTarget(url);
            if (this.key.getPath() == null) {
                this.key.setUsePathPattern(true);
                this.key.setPathRegExp(false);
                this.key.setPath(url.getPath());
            } else {
                this.configureRewritingOfPath(SOAPProxy.getTargetPath(url));
            }
            ((ServiceProxyKey)this.key).setMethod("*");
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("WSDL endpoint location '" + location + "' is not an URL.");
        }
    }

    private void configureRewritingOfPath(String targetPath) {
        if (targetPath == null) {
            return;
        }
        RewriteInterceptor ri = new RewriteInterceptor();
        ri.setMappings(Lists.newArrayList((Object[])new RewriteInterceptor.Mapping[]{new RewriteInterceptor.Mapping("^" + Pattern.quote(this.key.getPath()), Matcher.quoteReplacement(targetPath), "rewrite")}));
        this.interceptors.addFirst(ri);
        ++this.automaticallyAddedInterceptorCount;
    }

    @NotNull
    private static String getTargetPath(URL url) {
        if (url.getQuery() != null) {
            return url.getPath() + "?" + url.getQuery();
        }
        return url.getPath();
    }

    @NotNull
    private String getLocation(Service service) {
        String location = this.getPort(service).getAddress().getLocation();
        if (location == null) {
            throw new ConfigurationException("In the WSDL %s, there is no @location defined on the port.".formatted(this.wsdl));
        }
        return location;
    }

    @NotNull
    private Port getPort(Service service) {
        return SOAPProxy.selectPort(service.getPorts(), this.portName);
    }

    @NotNull
    private WSDLParserContext getWsdlParserContext() {
        WSDLParserContext ctx = new WSDLParserContext();
        ctx.setInput((Object)ResolverMap.combine(this.router.getBaseLocation(), this.wsdl));
        return ctx;
    }

    @NotNull
    private WSDLParser getWsdlParser() {
        WSDLParser wsdlParser = new WSDLParser();
        wsdlParser.setResourceResolver((Object)this.resolverMap.toExternalResolver().toExternalResolver());
        return wsdlParser;
    }

    private Service getService(Definitions definitions) {
        List services = definitions.getServices();
        if (services.size() == 1) {
            return (Service)services.getFirst();
        }
        if (this.serviceName == null) {
            throw new SOAPProxyMultipleServicesException(this, SOAPProxy.getServiceNames(services));
        }
        return this.getServiceByName(services, this.serviceName);
    }

    private Service getServiceByName(List<Service> services, String serviceName) {
        return services.stream().filter(s -> s.getName().equals(serviceName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No service with name %s found in the WSDL. Available services are: %s".formatted(serviceName, SOAPProxy.getServiceNames(services))));
    }

    @NotNull
    private static List<String> getServiceNames(List<Service> services) {
        return services.stream().map(WSDLElement::getName).toList();
    }

    private void setTarget(URL url) {
        if (this.wsdl.startsWith("internal:")) {
            try {
                this.target.setUrl(UriUtil.getPathFromURL(this.router.getUriFactory(), this.wsdl));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        this.target.setHost(url.getHost());
        this.target.setPort(this.getPort(url));
    }

    private int getPort(URL url) {
        return url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
    }

    private void setProxyName(Service service, Definitions definitions) {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = StringUtils.isEmpty((CharSequence)service.getName()) ? definitions.getName() : service.getName();
        }
    }

    public static Port selectPort(List<Port> ports, String portName) {
        if (portName != null) {
            for (Port port : ports) {
                if (!portName.equals(port.getName())) continue;
                return port;
            }
            throw new IllegalArgumentException("No port with name '" + portName + "' found.");
        }
        return SOAPProxy.getPort(ports);
    }

    private static Port getPort(List<Port> ports) {
        Port port = SOAPProxy.getPortByNamespace(ports, "http://schemas.xmlsoap.org/wsdl/soap/");
        if (port == null) {
            port = SOAPProxy.getPortByNamespace(ports, "http://schemas.xmlsoap.org/wsdl/soap12/");
        }
        if (port == null) {
            throw new IllegalArgumentException("No SOAP/1.1 or SOAP/1.2 ports found in WSDL.");
        }
        return port;
    }

    private static Port getPortByNamespace(List<Port> ports, String namespace) {
        for (Port port : ports) {
            try {
                AbstractBinding binding;
                if (port.getBinding() == null || port.getBinding().getBinding() == null || !"http://schemas.xmlsoap.org/soap/http".equals((binding = port.getBinding().getBinding()).getProperty("transport")) || !namespace.equals(((QName)binding.getElementName()).getNamespaceURI())) continue;
                return port;
            }
            catch (Exception e) {
                log.warn("Error inspecting WSDL port binding.", (Throwable)e);
            }
        }
        return null;
    }

    private void addWSDLInterceptor() {
        if (this.getFirstInterceptorOfType(WSDLInterceptor.class).isEmpty()) {
            WSDLInterceptor wsdlInterceptor = new WSDLInterceptor();
            this.interceptors.addFirst(wsdlInterceptor);
            ++this.automaticallyAddedInterceptorCount;
        }
    }

    private void renameMe() {
        if (this.key.getPath() == null) {
            return;
        }
        Optional<WSDLInterceptor> wsdlInterceptor = this.getFirstInterceptorOfType(WSDLInterceptor.class);
        if (wsdlInterceptor.isEmpty()) {
            log.warn("No wsdl interceptor set.");
            return;
        }
        String keyPath = this.key.getPath();
        String name = this.getReplacementName(keyPath);
        wsdlInterceptor.get().setPathRewriter(path2 -> {
            try {
                if (path2.contains("://")) {
                    return new URL(new URL(path2), keyPath).toString();
                }
                Matcher m = relativePathPattern.matcher(path2);
                return m.replaceAll("./" + name + "?");
            }
            catch (MalformedURLException e) {
                log.error("Cannot parse URL {}", (Object)path2);
                return path2;
            }
        });
    }

    @NotNull
    private String getReplacementName(String keyPath) {
        try {
            return URLUtil.getName(this.router.getUriFactory(), keyPath);
        }
        catch (URISyntaxException e) {
            log.error("Error parsing URL {}", (Object)keyPath, (Object)e);
            throw new RuntimeException("Check!");
        }
    }

    private void addWebServiceExplorer() {
        WebServiceExplorerInterceptor sui = new WebServiceExplorerInterceptor();
        sui.setWsdl(this.wsdl);
        sui.setPortName(this.portName);
        this.interceptors.addFirst(sui);
        ++this.automaticallyAddedInterceptorCount;
    }

    private void addWSDLPublisherInterceptor() {
        if (this.hasWSDLPublisherInterceptor()) {
            return;
        }
        WSDLPublisherInterceptor wp = new WSDLPublisherInterceptor();
        wp.setWsdl(this.wsdl);
        wp.init(this.router);
        this.interceptors.addFirst(wp);
        ++this.automaticallyAddedInterceptorCount;
    }

    private boolean hasWSDLPublisherInterceptor() {
        return this.getFirstInterceptorOfType(WSDLPublisherInterceptor.class).isPresent();
    }

    public String getWsdl() {
        return this.wsdl;
    }

    @MCAttribute
    @Required
    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getPortName() {
        return this.portName;
    }

    @MCAttribute
    public void setPortName(String portName) {
        this.portName = portName;
    }

    public HttpClientConfiguration getWsdlHttpClientConfig() {
        return this.httpClientConfig;
    }

    @MCAttribute
    public void setWsdlHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @MCAttribute
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

