/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.proxies.AbstractProxy;
import com.predic8.membrane.core.proxies.AbstractRuleKey;
import com.predic8.membrane.core.proxies.RuleKey;
import com.predic8.membrane.core.transport.ssl.AcmeSSLContext;
import com.predic8.membrane.core.transport.ssl.GeneratingSSLContext;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import org.jetbrains.annotations.NotNull;

public class SSLableProxy
extends AbstractProxy {
    private SSLContext sslInboundContext;
    private SSLParser sslInboundParser;
    private SSLContext sslOutboundContext;

    public SSLableProxy() {
    }

    public SSLableProxy(AbstractRuleKey ruleKey) {
        super(ruleKey);
    }

    @Override
    public void init() {
        if (this.sslInboundParser == null) {
            return;
        }
        if (this.sslInboundParser.getAcme() != null) {
            if (!(this.key instanceof AbstractRuleKey)) {
                throw new RuntimeException("<acme> only be used inside of <serviceProxy> and similar rules.");
            }
            String[] host = this.key.getHost().split(" +");
            AcmeSSLContext acmeCtx = (AcmeSSLContext)this.getSslInboundContext();
            if (acmeCtx == null) {
                acmeCtx = new AcmeSSLContext(this.sslInboundParser, host, this.router.getHttpClientFactory(), this.router.getTimerManager());
            }
            this.setSslInboundContext(acmeCtx);
            acmeCtx.init(this.router.getKubernetesClientFactory(), this.router.getHttpClientFactory());
            return;
        }
        this.sslInboundContext = this.generateSslInboundContext();
    }

    public SSLProvider getSslOutboundContext() {
        return this.sslOutboundContext;
    }

    protected void setSslOutboundContext(SSLContext sslOutboundContext) {
        this.sslOutboundContext = sslOutboundContext;
    }

    public boolean isOutboundSSL() {
        return this.sslOutboundContext != null;
    }

    @Override
    public String getProtocol() {
        return this.isInboundSSL() ? "https" : "http";
    }

    public int getPort() {
        return this.key.getPort();
    }

    @MCAttribute
    public void setPort(int port) {
        RuleKey ruleKey = this.key;
        if (!(ruleKey instanceof AbstractRuleKey)) {
            return;
        }
        AbstractRuleKey ark = (AbstractRuleKey)ruleKey;
        ark.setPort(port);
    }

    public String getIp() {
        return this.key.getIp();
    }

    @MCAttribute
    public void setIp(String ip) {
        this.key.setIp(ip);
    }

    @MCChildElement(order=75, allowForeign=true)
    public void setSslInboundParser(SSLParser sslInboundParser) {
        this.sslInboundParser = sslInboundParser;
    }

    public SSLParser getSslInboundParser() {
        return this.sslInboundParser;
    }

    public SSLContext getSslInboundContext() {
        return this.sslInboundContext;
    }

    protected void setSslInboundContext(SSLContext sslInboundContext) {
        this.sslInboundContext = sslInboundContext;
    }

    public boolean isInboundSSL() {
        return this.sslInboundContext != null;
    }

    @NotNull
    private SSLContext generateSslInboundContext() {
        if (this.sslInboundParser.getKeyGenerator() != null) {
            return new GeneratingSSLContext(this.sslInboundParser, this.router.getResolverMap(), this.router.getBaseLocation());
        }
        return new StaticSSLContext(this.sslInboundParser, this.router.getResolverMap(), this.router.getBaseLocation());
    }
}

