/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.core.proxies.AbstractRuleKey;
import com.predic8.membrane.core.proxies.RuleKey;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProxyKey
extends AbstractRuleKey {
    private static final Logger log = LoggerFactory.getLogger((String)ServiceProxyKey.class.getName());
    private String method = "*";
    private String host = "*";
    private boolean isHostWildCard = true;
    private Pattern hostPattern;

    public ServiceProxyKey(RuleKey key) {
        super(key);
        this.method = key.getMethod();
        this.host = key.getHost();
        if (key instanceof AbstractRuleKey) {
            AbstractRuleKey arKey = (AbstractRuleKey)key;
            this.isHostWildCard = arKey.isHostWildcard();
        }
        if (key instanceof ServiceProxyKey) {
            ServiceProxyKey spKey = (ServiceProxyKey)key;
            this.hostPattern = spKey.getHostPattern();
        }
    }

    public ServiceProxyKey(int port) {
        this(port, null);
    }

    public ServiceProxyKey(int port, String ip) {
        super(port, ip);
    }

    public ServiceProxyKey(String host, String method, String path, int port) {
        this(host, method, path, port, null);
    }

    public ServiceProxyKey(String host, String method, String path, int port, String ip) {
        super(port, ip);
        this.setHost(host);
        this.setPath(path);
        this.method = method;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public boolean isMethodWildcard() {
        return "*".equals(this.method.trim());
    }

    @Override
    public boolean isHostWildcard() {
        return this.isHostWildCard;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host.trim();
        this.isHostWildCard = "*".equals(this.host);
        if (!this.isHostWildCard) {
            String pattern = ServiceProxyKey.createHostPattern(this.host);
            log.debug("Created host pattern match: {}", (Object)pattern);
            this.hostPattern = Pattern.compile(pattern, 2);
        } else {
            this.hostPattern = null;
        }
    }

    public static String createHostPattern(String host) {
        StringBuilder regex = new StringBuilder();
        boolean quoted = false;
        boolean notWhitespace = false;
        regex.append("(");
        block4: for (char c : host.toCharArray()) {
            switch (c) {
                case ' ': {
                    if (!notWhitespace) continue block4;
                    if (quoted) {
                        regex.append("\\E");
                        quoted = false;
                    }
                    notWhitespace = false;
                    regex.append(")|(");
                    continue block4;
                }
                case '*': {
                    if (quoted) {
                        regex.append("\\E");
                        quoted = false;
                    }
                    regex.append(".+");
                    notWhitespace = true;
                    continue block4;
                }
                default: {
                    if (!quoted) {
                        regex.append("\\Q");
                        quoted = true;
                        notWhitespace = true;
                    }
                    if (c == '\\') {
                        regex.append('\\');
                    }
                    regex.append(c);
                }
            }
        }
        if (quoted) {
            regex.append("\\E");
        }
        if (!notWhitespace && regex.length() > 1) {
            regex.setLength(regex.length() - 3);
        }
        regex.append(")");
        return regex.toString();
    }

    @Override
    public boolean matchesHostHeader(String hostHeader) {
        if (this.isHostWildCard) {
            return true;
        }
        if (hostHeader == null) {
            return false;
        }
        String requestHost = hostHeader.split(":")[0];
        log.debug("Rule host: {} Request host: {}", (Object)this.host, (Object)requestHost);
        return this.hostPattern.matcher(requestHost).matches();
    }

    public Pattern getHostPattern() {
        return this.hostPattern;
    }

    public String toString() {
        return this.getHostString() + ":" + this.port + this.getMethodString() + this.getPathString();
    }

    private String getPathString() {
        if (this.getPath() != null && !this.getPath().isEmpty()) {
            return " " + this.getPath();
        }
        return "";
    }

    @NotNull
    private String getMethodString() {
        return this.method.equals("*") ? "" : " %s".formatted(this.method);
    }

    private String getHostString() {
        return this.host.equals("*") ? "0.0.0.0" : this.host;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceProxyKey other = (ServiceProxyKey)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.getPath() == null) {
            return other.getPath() == null;
        }
        return this.getPath().equals(other.getPath());
    }
}

