/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.ExchangeState;
import com.predic8.membrane.core.http.AbstractBody;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticCollector {
    private static final Logger log = LoggerFactory.getLogger((String)StatisticCollector.class.getName());
    private final NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private final boolean countErrorExchanges;
    private int totalCount = 0;
    private int goodCount = 0;
    private int errorCount = 0;
    private int minTime = Integer.MAX_VALUE;
    private int maxTime = -1;
    private long totalTime = 0L;
    private long totalBytesSent = 0L;
    private long totalBytesReceived = 0L;

    public StatisticCollector(boolean countErrorExchanges) {
        this.countErrorExchanges = countErrorExchanges;
        this.nf.setMaximumFractionDigits(3);
    }

    public void collectFrom(AbstractExchange exc) {
        long timeReqSent;
        ++this.totalCount;
        if (exc.getStatus() == ExchangeState.FAILED) {
            ++this.errorCount;
            if (!this.countErrorExchanges) {
                return;
            }
        }
        if ((timeReqSent = exc.getTimeReqSent()) == 0L) {
            return;
        }
        long timeResSent = exc.getTimeResSent();
        if (timeResSent == 0L) {
            return;
        }
        ++this.goodCount;
        int time = (int)(timeResSent - timeReqSent);
        if (time < this.minTime) {
            this.minTime = time;
        }
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        this.totalTime += (long)time;
        try {
            AbstractBody requestBody = exc.getRequest().getBody();
            this.totalBytesSent += requestBody.isRead() ? (long)requestBody.getLength() : 0L;
            AbstractBody responseBody = exc.getResponse().getBody();
            this.totalBytesReceived += responseBody.isRead() ? (long)responseBody.getLength() : 0L;
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
        }
    }

    public void collectFrom(StatisticCollector s) {
        this.totalCount += s.totalCount;
        this.goodCount += s.goodCount;
        this.errorCount += s.errorCount;
        this.minTime = Math.min(this.minTime, s.minTime);
        this.maxTime = Math.max(this.maxTime, s.maxTime);
        this.totalTime += s.totalTime;
        this.totalBytesSent += s.totalBytesSent;
        this.totalBytesReceived += s.totalBytesReceived;
    }

    public int getCount() {
        return this.totalCount;
    }

    public int getGoodCount() {
        return this.goodCount;
    }

    public String getMinTime() {
        return this.minTime == Integer.MAX_VALUE ? "" : this.nf.format(this.minTime) + " ms";
    }

    public String getMaxTime() {
        return this.maxTime == -1 ? "" : this.nf.format(this.maxTime) + " ms";
    }

    public String getAvgTime() {
        return this.goodCount == 0 ? "" : this.nf.format((double)this.totalTime / (double)this.goodCount) + " ms";
    }

    public long getGoodTotalTime() {
        return this.totalTime;
    }

    public long getGoodTotalBytesReceived() {
        return this.totalBytesReceived;
    }

    public long getGoodTotalBytesSent() {
        return this.totalBytesSent;
    }

    public String getBytesSent() {
        return this.goodCount == 0 ? "" : this.nf.format(this.totalBytesSent);
    }

    public String getBytesReceived() {
        return this.goodCount == 0 ? "" : this.nf.format(this.totalBytesReceived);
    }

    public String toString() {
        return "min: " + this.getMinTime() + "   max: " + this.getMaxTime() + "   avg: " + this.getAvgTime() + "   total: " + this.getCount() + "   error: " + this.getErrorCount();
    }

    public String getErrorCount() {
        return "" + this.errorCount;
    }
}

