/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.proxies;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.ExchangeState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TimeCollector {
    private final boolean countErrorExchanges;
    private static List<Long> buckets = Stream.of(500L, 1000L, 2000L, 4000L, 10000L).collect(Collectors.toList());
    private final Map<String, Map<String, Long>> trackedTimes;
    private Map<String, Long> membraneReqProcess;
    private final Map<String, Long> membraneResProcess;
    private final Map<String, Long> responseProcess;
    private final Map<String, Long> totalTimeProcess;

    public TimeCollector(boolean countErrorExchanges) {
        this.countErrorExchanges = countErrorExchanges;
        this.trackedTimes = new HashMap<String, Map<String, Long>>();
        this.membraneReqProcess = new HashMap<String, Long>();
        this.membraneResProcess = new HashMap<String, Long>();
        this.totalTimeProcess = new HashMap<String, Long>();
        this.responseProcess = new HashMap<String, Long>();
        this.trackedTimes.put("process_req_time", this.membraneReqProcess);
        this.trackedTimes.put("process_res_time", this.membraneResProcess);
        this.trackedTimes.put("response_time", this.responseProcess);
        this.trackedTimes.put("total_time", this.totalTimeProcess);
    }

    public Map<String, Map<String, Long>> getTrackedTimes() {
        return this.trackedTimes;
    }

    public void collectFrom(AbstractExchange exc) {
        if (exc.getStatus() == ExchangeState.FAILED && !this.countErrorExchanges) {
            return;
        }
        if (exc.getTimeReqSent() == 0L) {
            return;
        }
        if (exc.getTimeResSent() == 0L) {
            return;
        }
        long timeMembraneReqProcess = exc.getTimeReqSent() - exc.getTimeReqReceived();
        this.addToBucket(timeMembraneReqProcess, this.membraneReqProcess);
        if (exc.getTimeResReceived() == 0L) {
            return;
        }
        long timeResponseProcess = exc.getTimeResReceived() - exc.getTimeReqSent();
        this.addToBucket(timeResponseProcess, this.responseProcess);
        long timeMembraneResProcess = exc.getTimeResSent() - exc.getTimeResReceived();
        this.addToBucket(timeMembraneResProcess, this.membraneResProcess);
        long totalTime = timeMembraneReqProcess + timeResponseProcess + timeMembraneResProcess;
        this.addToBucket(totalTime, this.totalTimeProcess);
    }

    private void addToBucket(long value, Map<String, Long> buckets) {
        buckets.merge("SUM", value, Long::sum);
        buckets.merge("COUNT", 1L, Long::sum);
        for (long bucket : TimeCollector.buckets) {
            if (value > bucket) continue;
            buckets.merge(String.valueOf(bucket), 1L, Long::sum);
        }
        buckets.merge("+Inf", 1L, Long::sum);
    }

    public static List<Long> getBuckets() {
        return buckets;
    }

    public static void setBuckets(List<Long> buckets) {
        TimeCollector.buckets = buckets;
    }
}

