/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.resolver;

import com.google.common.collect.Lists;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.util.URIUtil;
import com.predic8.membrane.core.util.functionalInterfaces.ExceptionThrowingConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSchemaResolver
implements SchemaResolver {
    private static final Logger log = LoggerFactory.getLogger((String)FileSchemaResolver.class.getName());
    WatchService watchService;
    private final ConcurrentHashMap<String, WatchKey> watchServiceForFile = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ExceptionThrowingConsumer<InputStream>> watchedFiles = new ConcurrentHashMap();
    private final Runnable fileWatchJob = new Runnable(){

        @Override
        public void run() {
            while (!FileSchemaResolver.this.watchedFiles.isEmpty()) {
                for (String url : FileSchemaResolver.this.watchServiceForFile.keySet()) {
                    WatchKey wk = FileSchemaResolver.this.watchServiceForFile.get(url);
                    List<WatchEvent<?>> events = wk.pollEvents();
                    for (WatchEvent<?> event : events) {
                        Path changedFile = (Path)event.context();
                        Path urlPath = Paths.get(url, new String[0]).getFileName();
                        if (!changedFile.toString().equals(urlPath.toString())) continue;
                        try {
                            ExceptionThrowingConsumer<InputStream> inputStreamConsumer = FileSchemaResolver.this.watchedFiles.get(url);
                            FileSchemaResolver.this.watchServiceForFile.remove(url);
                            FileSchemaResolver.this.watchedFiles.remove(url);
                            inputStreamConsumer.accept(FileSchemaResolver.this.resolve(url));
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            FileSchemaResolver.this.fileWatcher = null;
        }
    };
    Thread fileWatcher = null;

    @Override
    public List<String> getSchemas() {
        return Lists.newArrayList((Object[])new String[]{"file", null});
    }

    @Override
    public InputStream resolve(String fileUrl) throws ResourceRetrievalException {
        String path = URIUtil.pathFromFileURI(fileUrl);
        log.debug("Resolving {}", (Object)path);
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            log.error("File {} not found: {}", (Object)path, (Object)e.getMessage());
            throw new ResourceRetrievalException(fileUrl, e);
        }
    }

    @Override
    public void observeChange(String url, ExceptionThrowingConsumer<InputStream> consumer) {
        url = Paths.get(URIUtil.pathFromFileURI(url), new String[0]).toAbsolutePath().toString();
        if (this.watchService == null) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Path path = Paths.get(url, new String[0]).getParent();
        WatchKey watchKey = null;
        try {
            watchKey = path.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.watchServiceForFile.put(url, watchKey);
        this.watchedFiles.put(url, consumer);
        if (this.fileWatcher == null) {
            this.fileWatcher = new Thread(this.fileWatchJob);
        }
        if (!this.fileWatcher.isAlive()) {
            this.fileWatcher.start();
        }
    }

    @Override
    public List<String> getChildren(String url) {
        String[] children = new File(URIUtil.pathFromFileURI(url)).list();
        if (children == null) {
            return null;
        }
        return Arrays.asList(children);
    }

    @Override
    public long getTimestamp(String url) {
        return new File(URIUtil.pathFromFileURI(url)).lastModified();
    }
}

