/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.resolver;

import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.ByteUtil;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.functionalInterfaces.ExceptionThrowingConsumer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

@MCElement(name="httpSchemaResolver")
public class HTTPSchemaResolver
implements SchemaResolver {
    private HttpClientFactory httpClientFactory;
    private final ConcurrentHashMap<String, byte[]> watchedUrlMd5s = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ExceptionThrowingConsumer<InputStream>> consumerForUrls = new ConcurrentHashMap();
    private final int httpWatchIntervalInSeconds = 1;
    Thread httpWatcher = null;
    final byte[] NO_HASH = "NO_HASH".getBytes();
    private HttpClientConfiguration httpClientConfig = new HttpClientConfiguration();
    private HttpClient httpClient;
    private final URIFactory uriFactory = new URIFactory(false);
    private final Runnable httpWatchJob = new Runnable(){

        @Override
        public void run() {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            try (HttpClient client = HTTPSchemaResolver.this.httpClientFactory.createClient(null);){
                while (!HTTPSchemaResolver.this.watchedUrlMd5s.isEmpty()) {
                    try {
                        for (String url : HTTPSchemaResolver.this.watchedUrlMd5s.keySet()) {
                            md.reset();
                            Response response = client.call(HTTPSchemaResolver.this.createResolveExchange(url)).getResponse();
                            if (response.getStatusCode() != 200) {
                                throw new ResourceRetrievalException(url, response.getStatusCode());
                            }
                            byte[] hash = md.digest(response.getBody().getContent());
                            if (Arrays.equals(HTTPSchemaResolver.this.watchedUrlMd5s.get(url), HTTPSchemaResolver.this.NO_HASH)) {
                                HTTPSchemaResolver.this.watchedUrlMd5s.put(url, hash);
                                continue;
                            }
                            if (Arrays.equals(hash, HTTPSchemaResolver.this.watchedUrlMd5s.get(url))) continue;
                            ExceptionThrowingConsumer<InputStream> inputStreamConsumer = HTTPSchemaResolver.this.consumerForUrls.get(url);
                            HTTPSchemaResolver.this.watchedUrlMd5s.remove(url);
                            HTTPSchemaResolver.this.consumerForUrls.remove(url);
                            inputStreamConsumer.accept(response.getBodyAsStream());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                HTTPSchemaResolver.this.httpWatcher = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    private Exchange createResolveExchange(String url) throws URISyntaxException {
        return new Request.Builder().method("GET").url(this.uriFactory, url).header("User-Agent", "Membrane API Gateway").buildExchange();
    }

    public HTTPSchemaResolver(@Nullable HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    private synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            if (this.httpClientFactory == null) {
                this.httpClientFactory = new HttpClientFactory(null);
            }
            this.httpClient = this.httpClientFactory.createClient(this.httpClientConfig);
        }
        return this.httpClient;
    }

    @Override
    public List<String> getSchemas() {
        return Lists.newArrayList((Object[])new String[]{"http", "https"});
    }

    @Override
    public InputStream resolve(String url) throws ResourceRetrievalException {
        try {
            Response response = this.getHttpClient().call(this.createResolveExchange(url)).getResponse();
            response.readBody();
            if (response.getStatusCode() != 200) {
                throw new ResourceRetrievalException(url, response.getStatusCode());
            }
            return new ByteArrayInputStream(ByteUtil.getByteArrayData(response.getBodyAsStreamDecoded()));
        }
        catch (ResourceRetrievalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRetrievalException(url, e);
        }
    }

    @Override
    public void observeChange(String url, ExceptionThrowingConsumer<InputStream> consumer) {
        this.watchedUrlMd5s.put(url, this.NO_HASH);
        this.consumerForUrls.put(url, consumer);
        if (this.httpWatcher == null) {
            this.httpWatcher = new Thread(this.httpWatchJob);
        }
        if (!this.httpWatcher.isAlive()) {
            this.httpWatcher.start();
        }
    }

    @Override
    public List<String> getChildren(String url) {
        return null;
    }

    @Override
    public long getTimestamp(String url) {
        return 0L;
    }

    public synchronized HttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public synchronized void setHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
        this.httpClient = null;
    }
}

