/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.resolver;

import com.google.common.base.Objects;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.kubernetes.KubernetesSchemaResolver;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientFactory;
import com.predic8.membrane.core.resolver.ClasspathSchemaResolver;
import com.predic8.membrane.core.resolver.FileSchemaResolver;
import com.predic8.membrane.core.resolver.HTTPSchemaResolver;
import com.predic8.membrane.core.resolver.Resolver;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.RuleResolver;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.LSInputImpl;
import com.predic8.membrane.core.util.URIUtil;
import com.predic8.membrane.core.util.functionalInterfaces.ExceptionThrowingConsumer;
import com.predic8.xml.util.ExternalResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;

@MCElement(name="resolverMap")
public class ResolverMap
implements Cloneable,
Resolver {
    private static final Logger log = LoggerFactory.getLogger((String)ResolverMap.class.getName());
    int count = 0;
    private String[] schemas;
    private SchemaResolver[] resolvers;

    public static String combine(String ... locations) {
        String resolved = ResolverMap.combineInternal(locations);
        log.debug("Resolved locations: {} to: {}", (Object)locations, (Object)resolved);
        return resolved;
    }

    private static String combineInternal(String ... locations) {
        if (locations.length < 2) {
            throw new InvalidParameterException();
        }
        if (locations.length > 2) {
            String[] l = new String[locations.length - 1];
            System.arraycopy(locations, 0, l, 0, locations.length - 1);
            return ResolverMap.combine(ResolverMap.combine(l), locations[locations.length - 1]);
        }
        String parent = locations[0];
        String relativeChild = locations[1];
        if (relativeChild.contains(":/") || relativeChild.contains(":\\") || parent == null || parent.isEmpty()) {
            return relativeChild;
        }
        if (parent.startsWith("file://")) {
            if (relativeChild.startsWith("\\") || relativeChild.startsWith("/")) {
                return URIUtil.convertPath2FilePathString(new File(relativeChild).getAbsolutePath());
            }
            File parentFile = new File(URIUtil.pathFromFileURI(parent));
            if (!parent.endsWith("/") && !parent.endsWith("\\")) {
                parentFile = parentFile.getParentFile();
            }
            try {
                return ResolverMap.keepTrailingSlash(parentFile, relativeChild);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Error combining: " + Arrays.toString(locations), e);
            }
        }
        if (parent.contains(":/")) {
            try {
                if (parent.startsWith("http")) {
                    return new URI(parent).resolve(ResolverMap.prepare4Uri(relativeChild)).toString();
                }
                if (parent.startsWith("classpath:")) {
                    return new URI(parent).resolve(ResolverMap.prepare4Uri(relativeChild)).toString();
                }
                return URIUtil.convertPath2FileURI(parent).resolve(ResolverMap.prepare4Uri(relativeChild)).toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (parent.startsWith("/")) {
            try {
                return URIUtil.pathFromFileURI(URIUtil.convertPath2FileURI(parent).resolve(relativeChild));
            }
            catch (Exception e) {
                throw new ConfigurationException("Error resolving paths to resources. Check proxies.xml, OpenAPI, JSON/XSD Schema and WSDL documents for references.\n\nParent path: %s\nChild path: %s\n".formatted(parent, relativeChild));
            }
        }
        File parentFile = new File(parent);
        if (!parent.endsWith("/") && !parent.endsWith("\\")) {
            parentFile = parentFile.getParentFile();
        }
        try {
            return new File(parentFile, relativeChild).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String prepare4Uri(String path) {
        path = path.replaceAll("\\\\", "/");
        path = path.replaceAll(" ", "%20");
        return path;
    }

    @NotNull
    protected static String keepTrailingSlash(File parentFile, String relativeChild) throws URISyntaxException {
        String res = URIUtil.toFileURIString(new File(parentFile, relativeChild));
        if (ResolverMap.endsWithSlash(relativeChild)) {
            return res + "/";
        }
        return res;
    }

    private static boolean endsWithSlash(String path) {
        return path.endsWith("/") || path.endsWith("\\");
    }

    public ResolverMap() {
        this(null, null);
    }

    public ResolverMap(HttpClientFactory httpClientFactory, KubernetesClientFactory kubernetesClientFactory) {
        this.schemas = new String[10];
        this.resolvers = new SchemaResolver[10];
        this.addSchemaResolver(new ClasspathSchemaResolver());
        this.addSchemaResolver(new HTTPSchemaResolver(httpClientFactory));
        this.addSchemaResolver(new KubernetesSchemaResolver(kubernetesClientFactory));
        this.addSchemaResolver(new FileSchemaResolver());
    }

    private ResolverMap(ResolverMap other) {
        this.count = other.count;
        this.schemas = new String[other.schemas.length];
        this.resolvers = new SchemaResolver[other.resolvers.length];
        System.arraycopy(other.schemas, 0, this.schemas, 0, this.count);
        System.arraycopy(other.resolvers, 0, this.resolvers, 0, this.count);
    }

    public ResolverMap clone() {
        return new ResolverMap(this);
    }

    public void addSchemaResolver(SchemaResolver sr) {
        for (String schema : sr.getSchemas()) {
            this.addSchemaResolver(schema == null ? null : schema + ":", sr);
        }
    }

    private void addSchemaResolver(String schema, SchemaResolver resolver) {
        int newIndex;
        for (int i = 0; i < this.count; ++i) {
            if (!Objects.equal((Object)this.schemas[i], (Object)schema)) continue;
            this.resolvers[i] = resolver;
            return;
        }
        if (++this.count > this.schemas.length) {
            String[] schemas2 = new String[this.schemas.length * 2];
            System.arraycopy(this.schemas, 0, schemas2, 0, this.schemas.length);
            this.schemas = schemas2;
            SchemaResolver[] resolvers2 = new SchemaResolver[this.resolvers.length * 2];
            System.arraycopy(this.resolvers, 0, resolvers2, 0, this.resolvers.length);
            this.resolvers = resolvers2;
        }
        if ((newIndex = this.count - 1) > 0 && this.schemas[newIndex - 1] == null) {
            this.schemas[newIndex] = this.schemas[newIndex - 1];
            this.resolvers[newIndex] = this.resolvers[newIndex - 1];
            --newIndex;
        }
        this.schemas[newIndex] = schema;
        this.resolvers[newIndex] = resolver;
    }

    private SchemaResolver getSchemaResolver(String uri) {
        for (int i = 0; i < this.count; ++i) {
            if (this.schemas[i] == null) {
                return this.resolvers[i];
            }
            if (!uri.startsWith(this.schemas[i])) continue;
            return this.resolvers[i];
        }
        throw new RuntimeException("No SchemaResolver defined for " + uri);
    }

    public void addRuleResolver(Router r) {
        this.addSchemaResolver(new RuleResolver(r));
    }

    @Override
    public long getTimestamp(String uri) throws FileNotFoundException {
        return this.getSchemaResolver(uri).getTimestamp(uri);
    }

    @Override
    public InputStream resolve(String uri) throws ResourceRetrievalException {
        return this.getSchemaResolver(uri).resolve(uri);
    }

    @Override
    public void observeChange(String uri, ExceptionThrowingConsumer<InputStream> consumer) throws ResourceRetrievalException {
        this.getSchemaResolver(uri).observeChange(uri, consumer);
    }

    @Override
    public List<String> getChildren(String uri) throws FileNotFoundException {
        return this.getSchemaResolver(uri).getChildren(uri);
    }

    public HTTPSchemaResolver getHTTPSchemaResolver() {
        return (HTTPSchemaResolver)this.getSchemaResolver("http:");
    }

    public SchemaResolver getFileSchemaResolver() {
        return this.getSchemaResolver("file:");
    }

    public LSResourceResolver toLSResourceResolver() {
        return (type, namespaceURI, publicId, systemId, baseURI) -> {
            if (systemId == null) {
                return null;
            }
            try {
                if (!systemId.contains("://")) {
                    systemId = new URI(baseURI).resolve(systemId).toString();
                }
                return new LSInputImpl(publicId, systemId, this.resolve(systemId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public ExternalResolverConverter toExternalResolver() {
        return new ExternalResolverConverter();
    }

    public KubernetesSchemaResolver getKubernetesSchemaResolver() {
        return (KubernetesSchemaResolver)this.getSchemaResolver("kubernetes:");
    }

    public class ExternalResolverConverter {
        public ExternalResolver toExternalResolver() {
            return new ExternalResolver(){

                public InputStream resolveAsFile(String filename, String baseDir) {
                    try {
                        if (baseDir != null) {
                            return ResolverMap.this.resolve(ResolverMap.combine(baseDir, filename));
                        }
                        return ResolverMap.this.resolve(filename);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                protected InputStream resolveViaHttp(Object url) {
                    try {
                        Object url2 = (String)url;
                        int q = ((String)url2).indexOf(63);
                        url2 = q == -1 ? ((String)url2).replaceAll("/[^/]+/\\.\\./", "/") : ((String)url2).substring(0, q).replaceAll("/[^/]+/\\.\\./", "/") + ((String)url2).substring(q);
                        return ResolverMap.this.getSchemaResolver((String)url2).resolve((String)url2);
                    }
                    catch (ResourceRetrievalException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }
}

