/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.resolver;

import com.google.common.collect.Lists;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.HTTPClientInterceptor;
import com.predic8.membrane.core.interceptor.InternalRoutingInterceptor;
import com.predic8.membrane.core.interceptor.RuleMatchingInterceptor;
import com.predic8.membrane.core.proxies.AbstractProxy;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.InternalProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.util.functionalInterfaces.ExceptionThrowingConsumer;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleResolver
implements SchemaResolver {
    private static final Logger log = LoggerFactory.getLogger(RuleResolver.class);
    final Router router;

    public RuleResolver(Router router) {
        this.router = router;
    }

    @Override
    public InputStream resolve(String urlString) {
        log.debug("Resolving from {}", (Object)urlString);
        URI uri = URI.create(urlString);
        String proxyName = uri.getHost();
        Proxy proxy = this.router.getRuleManager().getRuleByName(proxyName, Proxy.class);
        if (proxy == null) {
            throw new RuntimeException("Rule with name '%s' not found".formatted(proxyName));
        }
        if (!proxy.isActive()) {
            throw new RuntimeException("Rule with name '%s' not active".formatted(proxyName));
        }
        if (proxy instanceof InternalProxy) {
            InternalProxy ip = (InternalProxy)proxy;
            log.debug("Resolving from internal proxy {}", (Object)ip);
            try {
                Exchange exc = Request.get("?wsdl").buildExchange();
                exc.getDestinations().clear();
                exc.getDestinations().add(urlString);
                exc.setProxy(proxy);
                InternalRoutingInterceptor isri = new InternalRoutingInterceptor();
                isri.init(this.router);
                isri.handleRequest(exc);
            }
            catch (Exception e) {
                log.debug("", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (!(proxy instanceof AbstractProxy)) {
            throw new RuntimeException("Rule with name '" + proxyName + "' is not of type AbstractProxy");
        }
        AbstractProxy p = (AbstractProxy)proxy;
        try {
            String pathAndQuery = RuleResolver.getPathAndQuery(uri);
            Exchange exchange = new Request.Builder().get(pathAndQuery).buildExchange();
            RuleMatchingInterceptor.assignRule(exchange, p);
            ArrayList<HTTPClientInterceptor> additionalInterceptors = new ArrayList<HTTPClientInterceptor>();
            if (p instanceof AbstractServiceProxy) {
                AbstractServiceProxy asp = (AbstractServiceProxy)p;
                exchange.setDestinations(Stream.of(this.toUrl(asp.getTargetSSL() != null ? "https" : "http", asp.getHost(), asp.getTargetPort()).toString() + pathAndQuery).collect(Collectors.toList()));
                exchange.getRequest().getHeader().setHost(asp.getHost());
                HTTPClientInterceptor httpClientInterceptor = new HTTPClientInterceptor();
                httpClientInterceptor.init(this.router);
                additionalInterceptors.add(httpClientInterceptor);
            }
            additionalInterceptors.clear();
            this.router.getFlowController().invokeRequestHandlers(exchange, Stream.concat(p.getInterceptors().stream(), additionalInterceptors.stream()).toList());
            return exchange.getResponse().getBodyAsStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String getPathAndQuery(URI uri) {
        if (uri.getQuery().isEmpty()) {
            return uri.getPath();
        }
        return uri.getPath() + "?" + uri.getQuery();
    }

    protected static String getRuleName(String url) {
        URI uri = URI.create(url);
        if (!uri.getScheme().equals("internal")) {
            throw new RuntimeException("Not a service URL!");
        }
        return uri.getHost();
    }

    public URL toUrl(String scheme, String host, int port) {
        try {
            return new URL(scheme + "://" + host + ":" + port);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void observeChange(String url, ExceptionThrowingConsumer<InputStream> consumer) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<String> getChildren(String url) {
        return null;
    }

    @Override
    public long getTimestamp(String url) {
        return 0L;
    }

    @Override
    public List<String> getSchemas() {
        return Lists.newArrayList((Object[])new String[]{"internal"});
    }
}

