/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.security;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSecurityScheme
implements SecurityScheme {
    protected Set<String> scopes = new HashSet<String>();

    @Override
    public void add(Exchange exc) {
        try {
            ArrayList<AbstractSecurityScheme> securitySchemes = (ArrayList<AbstractSecurityScheme>)exc.getProperty("membrane.security.schemes");
            if (securitySchemes == null) {
                securitySchemes = new ArrayList<AbstractSecurityScheme>();
                exc.setProperty("membrane.security.schemes", securitySchemes);
            }
            securitySchemes.add(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AbstractSecurityScheme scopes(String ... scopes) {
        this.scopes = new HashSet<String>(Arrays.stream(scopes).toList());
        return this;
    }

    public AbstractSecurityScheme scopes(Set<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    @Override
    public boolean hasScope(String scope) {
        return this.scopes.contains(scope);
    }

    @Override
    public Set<String> getScopes() {
        return this.scopes;
    }
}

