/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.security;

import com.predic8.membrane.core.config.security.Store;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class KeyStoreUtil {
    public static KeyStore filterKeyStoreByAlias(KeyStore ks, char[] keyPass, String keyAlias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore filteredKeyStore = KeyStore.getInstance(ks.getType());
        filteredKeyStore.load(null, keyPass);
        Key key = ks.getKey(keyAlias, keyPass);
        Certificate[] certificateChain = ks.getCertificateChain(keyAlias);
        filteredKeyStore.setKeyEntry(keyAlias, key, keyPass, certificateChain);
        return filteredKeyStore;
    }

    @NotNull
    public static String getDigest(KeyStore ks, String alias) throws CertificateEncodingException, KeyStoreException, NoSuchAlgorithmException {
        byte[] pkeEnc = ks.getCertificate(alias).getEncoded();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(pkeEnc);
        byte[] mdbytes = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mdbytes.length; ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    @NotNull
    public static KeyStore getAndLoadKeyStore(Store store, ResolverMap resourceResolver, String baseLocation, String type, char[] password) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = store.getProvider() != null ? KeyStore.getInstance(type, store.getProvider()) : KeyStore.getInstance(type);
        ks.load(resourceResolver.resolve(ResolverMap.combine(baseLocation, store.getLocation())), password);
        return ks;
    }

    public static String firstAliasOrThrow(KeyStore ks) throws KeyStoreException {
        Optional<String> alias = KeyStoreUtil.getFirstCertAlias(ks);
        if (!alias.isPresent()) {
            throw new RuntimeException("No certificate available in key store.");
        }
        String keyAlias = alias.get();
        return keyAlias;
    }

    public static String aliasOrThrow(KeyStore ks, String alias) throws KeyStoreException {
        if (!ks.isKeyEntry(alias)) {
            throw new RuntimeException("Certificate of alias " + alias + " not present in key store.");
        }
        String keyAlias = alias;
        return keyAlias;
    }

    public static Optional<String> getFirstCertAlias(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keystore.isKeyEntry(alias)) continue;
            return Optional.of(alias);
        }
        return Optional.empty();
    }
}

