/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.stats;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.proxies.StatisticCollector;
import com.predic8.membrane.core.proxies.TimeCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RuleStatisticCollector {
    private final ConcurrentHashMap<Integer, StatisticCollector> statusCodes = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, TimeCollector> timeCollector = new ConcurrentHashMap();

    private StatisticCollector getStatisticCollectorByStatusCode(int code) {
        StatisticCollector sc = this.statusCodes.get(code);
        if (sc == null) {
            sc = new StatisticCollector(true);
            StatisticCollector sc2 = this.statusCodes.putIfAbsent(code, sc);
            if (sc2 != null) {
                sc = sc2;
            }
        }
        return sc;
    }

    private TimeCollector getTimeCollectorByStatusCode(int code) {
        TimeCollector tc = this.timeCollector.get(code /= 100);
        if (tc == null) {
            tc = new TimeCollector(true);
            TimeCollector tc2 = this.timeCollector.putIfAbsent(code, tc);
            if (tc2 != null) {
                tc = tc2;
            }
        }
        return tc;
    }

    public Map<Integer, StatisticCollector> getStatisticsByStatusCodes() {
        return this.statusCodes;
    }

    public Map<Integer, TimeCollector> getTimeStatisticsByStatusCodeRange() {
        return this.timeCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(Exchange exc) {
        TimeCollector tc;
        StatisticCollector sc;
        StatisticCollector statisticCollector = sc = this.getStatisticCollectorByStatusCode(exc.getResponse().getStatusCode());
        synchronized (statisticCollector) {
            sc.collectFrom(exc);
        }
        TimeCollector timeCollector = tc = this.getTimeCollectorByStatusCode(exc.getResponse().getStatusCode());
        synchronized (timeCollector) {
            tc.collectFrom(exc);
        }
    }

    public int getCount() {
        int c = 0;
        for (StatisticCollector statisticCollector : this.statusCodes.values()) {
            c += statisticCollector.getCount();
        }
        return c;
    }
}

