/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.AbortException;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.NoMoreRequestsException;
import com.predic8.membrane.core.transport.http.NoResponseException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetAddress;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractHttpHandler.class.getName());
    protected Exchange exchange;
    protected Request srcReq;
    private final Transport transport;

    public AbstractHttpHandler(Transport transport) {
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public abstract void shutdownInput() throws IOException;

    public abstract InetAddress getLocalAddress();

    public abstract int getLocalPort();

    protected void invokeHandlers() throws AbortException, NoMoreRequestsException, EOFWhileReadingFirstLineException {
        try {
            this.getTransport().getRouter().getFlowController().invokeRequestHandlers(this.exchange, this.transport.getInterceptors());
            if (this.exchange.getResponse() == null) {
                log.info("Interceptor chain returned no response");
                ProblemDetails.internal(this.transport.getRouter().isProduction(), "http-handler").addSubSee("no-response-produced").detail("No response was generated by the interceptor chain.").internal("interceptors", this.transport.getInterceptors()).buildAndSetResponse(this.exchange);
            }
        }
        catch (Exception e) {
            if (this.exchange.getResponse() == null) {
                this.exchange.setResponse(this.generateErrorResponse(e));
            }
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbortException.class, NoMoreRequestsException.class, NoResponseException.class, EOFWhileReadingFirstLineException.class}, (Object)exception2, n)) {
                case 0: {
                    AbortException abortException = (AbortException)exception2;
                    throw abortException;
                }
                case 1: {
                    NoMoreRequestsException noMoreRequestsException = (NoMoreRequestsException)exception2;
                    throw noMoreRequestsException;
                }
                case 2: {
                    NoResponseException noResponseException = (NoResponseException)exception2;
                    throw noResponseException;
                }
                case 3: {
                    EOFWhileReadingFirstLineException eofWhileReadingFirstLineException = (EOFWhileReadingFirstLineException)exception2;
                    throw eofWhileReadingFirstLineException;
                }
            }
            log.warn("An exception occurred while handling a request: ", (Throwable)e);
        }
    }

    private Response generateErrorResponse(Exception e) {
        return ProblemDetails.internal(this.transport.getRouter().isProduction(), "http-handler").addSubSee("error-during-request-phase").exception(e).build();
    }

    public boolean isMatchLocalPort() {
        return true;
    }

    public String getContextPath(Exchange exc) {
        return "";
    }
}

