/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.transport.http.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteStreamLogging {
    static Logger log = LoggerFactory.getLogger(ByteStreamLogging.class);

    public static void log(String name, int b) {
        ByteStreamLogging.log(name, (byte)b);
    }

    public static void log(String name, byte ... b) {
        ByteStreamLogging.log(name, b, 0, b.length);
    }

    public static void log(String name, byte[] b, int off, int len) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(name).append("] ").append("[ ");
        for (int i = off; i < off + len; ++i) {
            sb.append(b[i]).append(" ");
        }
        sb.append("] ");
        sb.append(new String(b, off, len));
        log.info(sb.toString());
    }

    public static OutputStream wrapConnectionOutputStream(final Connection con, final String name) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                ByteStreamLogging.log(name, b);
                con.out.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                ByteStreamLogging.log(name, b);
                con.out.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteStreamLogging.log(name, b, off, len);
                con.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                con.out.close();
            }

            @Override
            public void flush() throws IOException {
                con.out.flush();
            }
        };
    }

    public static InputStream wrapConnectionInputStream(final Connection con, final String name) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                int res = con.in.read();
                ByteStreamLogging.log(name, res);
                return res;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int res = con.in.read(b);
                ByteStreamLogging.log(name, b);
                return res;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int res = con.in.read(b, off, len);
                ByteStreamLogging.log(name, b, off, len);
                return res;
            }

            @Override
            public void close() throws IOException {
                con.in.close();
            }

            @Override
            public boolean markSupported() {
                return con.in.markSupported();
            }

            @Override
            public int available() throws IOException {
                return con.in.available();
            }

            @Override
            public long skip(long n) throws IOException {
                return con.in.skip(n);
            }

            @Override
            public synchronized void mark(int readlimit) {
                con.in.mark(readlimit);
            }

            @Override
            public synchronized void reset() throws IOException {
                con.in.reset();
            }
        };
    }
}

