/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.util.HttpUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public record HostColonPort(boolean useSSL, String host, int port) {
    public HostColonPort(boolean useSSL, String hostAndPort) {
        this(useSSL, HostColonPort.hostPart(hostAndPort), HostColonPort.portPart(hostAndPort, useSSL ? 443 : 80));
    }

    public HostColonPort(String host, int port) {
        this(false, host, port);
    }

    public HostColonPort(URL url) throws MalformedURLException {
        this(url.getProtocol().endsWith("s"), url.getHost(), HttpUtil.getPort(url));
    }

    public String getProtocol() {
        return this.isHttpsPort() ? "https" : "http";
    }

    public URL toURL() throws URISyntaxException, MalformedURLException {
        return new URI(this.getProtocol(), this.toString(), null).toURL();
    }

    public String getUrl() {
        return "%s://%s".formatted(this.getProtocol(), this);
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.getProtocol(), null, this.host, this.port, null, null, null);
    }

    public static HostColonPort fromURI(String uri) throws URISyntaxException, MalformedURLException {
        URL url = new URI(uri).toURL();
        boolean isSSL = "https".equals(url.getProtocol());
        return new HostColonPort(isSSL, url.getHost(), HttpUtil.getPort(url));
    }

    @Override
    public String toString() {
        return this.host + ":" + this.port;
    }

    private boolean isHttpsPort() {
        return this.port == 443 || this.port == 8443;
    }

    private static String hostPart(String addr) {
        int colon = addr.indexOf(":");
        return colon > -1 ? addr.substring(0, colon) : addr;
    }

    private static int portPart(String addr, int defaultValue) {
        int colon = addr.indexOf(":");
        return colon > -1 ? Integer.parseInt(addr.substring(colon + 1)) : defaultValue;
    }
}

