/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.ChunkedBodyTransferrer;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.PlainBodyTransferrer;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.model.AbstractExchangeViewerListener;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http.ConnectionManager;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.HostColonPort;
import com.predic8.membrane.core.transport.http.HttpClientStatusEventBus;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.transport.http.StreamPump;
import com.predic8.membrane.core.transport.http.WebSocketStreamPump;
import com.predic8.membrane.core.transport.http.client.AuthenticationConfiguration;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import com.predic8.membrane.core.transport.http2.Http2Client;
import com.predic8.membrane.core.transport.http2.Http2ClientPool;
import com.predic8.membrane.core.transport.http2.Http2TlsSupport;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.TimerManager;
import com.predic8.membrane.core.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements AutoCloseable {
    public static final String HTTP2 = "h2";
    private static final Logger log = LoggerFactory.getLogger((String)HttpClient.class.getName());
    @GuardedBy(value="HttpClient.class")
    private static SSLProvider defaultSSLProvider;
    private final ProxyConfiguration proxy;
    private final SSLContext proxySSLContext;
    private final AuthenticationConfiguration authentication;
    private final int timeBetweenTriesMs = 250;
    private final int maxRetries;
    private final int connectTimeout;
    private final int soTimeout;
    private final String localAddr;
    private final SSLContext sslContext;
    private final boolean useHttp2;
    private final ConnectionManager conMgr;
    private final Http2ClientPool http2ClientPool;
    private StreamPump.StreamPumpStats streamPumpStats;
    private static final String[] HTTP2_PROTOCOLS;
    private static final String[] HTTP1_PROTOCOLS;

    public HttpClient() {
        this(null, null);
    }

    public HttpClient(@javax.annotation.Nullable HttpClientConfiguration configuration) {
        this(configuration, null);
    }

    public HttpClient(@javax.annotation.Nullable HttpClientConfiguration configuration, @javax.annotation.Nullable TimerManager timerManager) {
        if (configuration == null) {
            configuration = new HttpClientConfiguration();
        }
        this.proxy = configuration.getProxy();
        this.proxySSLContext = this.proxy != null && this.proxy.getSslParser() != null ? new StaticSSLContext(this.proxy.getSslParser(), new ResolverMap(), null) : null;
        if (configuration.getSslParser() != null) {
            if (configuration.getBaseLocation() == null) {
                throw new RuntimeException("Cannot find keystores as base location is unknown");
            }
            this.sslContext = new StaticSSLContext(configuration.getSslParser(), new ResolverMap(), configuration.getBaseLocation());
        } else {
            this.sslContext = null;
        }
        this.authentication = configuration.getAuthentication();
        this.maxRetries = configuration.getMaxRetries();
        this.connectTimeout = configuration.getConnection().getTimeout();
        this.soTimeout = configuration.getConnection().getSoTimeout();
        this.localAddr = configuration.getConnection().getLocalAddr();
        this.conMgr = new ConnectionManager(configuration.getConnection().getKeepAliveTimeout(), timerManager);
        this.useHttp2 = configuration.isUseExperimentalHttp2();
        this.http2ClientPool = this.getHttp2ClientPool(this.useHttp2, configuration);
    }

    @Nullable
    private Http2ClientPool getHttp2ClientPool(boolean useHttp2, @NotNull HttpClientConfiguration configuration) {
        if (useHttp2) {
            return new Http2ClientPool(configuration.getConnection().getKeepAliveTimeout());
        }
        return null;
    }

    public void setStreamPumpStats(StreamPump.StreamPumpStats streamPumpStats) {
        this.streamPumpStats = streamPumpStats;
    }

    protected void finalize() {
        this.close();
    }

    private void setRequestURI(Request req, String dest) throws MalformedURLException {
        if (this.proxy != null || req.isCONNECTRequest()) {
            req.setUri(dest);
            return;
        }
        if (!dest.startsWith("http")) {
            throw new MalformedURLException("The exchange's destination URI %s does not start with 'http'. Specify a <target> within the API configuration or make sure the exchanges destinations list contains a valid URI.\n".formatted(dest));
        }
        String originalUri = req.getUri();
        req.setUri(HttpUtil.getPathAndQueryString(dest));
        if ("/".equals(originalUri) && req.getUri().isEmpty()) {
            req.setUri("/");
        }
    }

    private HostColonPort getTargetHostAndPort(boolean connect, String dest) throws MalformedURLException {
        if (connect) {
            return new HostColonPort(false, dest);
        }
        return new HostColonPort(new URL(dest));
    }

    private HostColonPort init(Exchange exc, String dest, boolean adjustHostHeader) throws IOException {
        this.setRequestURI(exc.getRequest(), dest);
        HostColonPort target = this.getTargetHostAndPort(exc.getRequest().isCONNECTRequest(), dest);
        if (this.authentication != null) {
            exc.getRequest().getHeader().setAuthorization(this.authentication.getUsername(), this.authentication.getPassword());
        }
        if (adjustHostHeader && (exc.getProxy() == null || exc.getProxy().isTargetAdjustHostHeader())) {
            URL d = new URL(dest);
            exc.getRequest().getHeader().setHost(d.getHost() + ":" + HttpUtil.getPort(d));
        }
        return target;
    }

    private SSLProvider getOutboundSSLProvider(Exchange exc, HostColonPort hcp) {
        Object sslPropObj = exc.getProperty("membrane.ssl.context");
        if (sslPropObj != null) {
            return (SSLProvider)sslPropObj;
        }
        if (hcp.useSSL()) {
            if (this.sslContext != null) {
                return this.sslContext;
            }
            return HttpClient.getDefaultSSLProvider();
        }
        return null;
    }

    private static synchronized SSLProvider getDefaultSSLProvider() {
        if (defaultSSLProvider == null) {
            defaultSSLProvider = new StaticSSLContext(new SSLParser(), null, null);
        }
        return defaultSSLProvider;
    }

    public Exchange call(Exchange exc) throws Exception {
        return this.call(exc, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange call(Exchange exc, boolean adjustHostHeader, boolean failOverOn5XX) throws Exception {
        if (exc.getDestinations().isEmpty()) {
            throw new IllegalStateException("List of destinations is empty. Please specify at least one destination.");
        }
        HttpClientStatusEventBus httpClientStatusEventBus = (HttpClientStatusEventBus)exc.getProperty("HttpClientStatusEventBus");
        Exception exception = null;
        boolean trackNodeStatus = HttpClient.trackNodeStatus(exc);
        for (int counter = 0; counter < this.maxRetries; ++counter) {
            Integer responseStatusCode = null;
            String dest = this.getDestination(exc, counter);
            log.debug("try # {} to {}", (Object)counter, (Object)dest);
            HostColonPort target = this.init(exc, dest, adjustHostHeader);
            try {
                Response response;
                Connection con = HttpClient.getConnection(exc, counter, target);
                boolean usingHttp2 = false;
                SSLProvider sslProvider = this.getOutboundSSLProvider(exc, target);
                Http2Client h2c = null;
                String sniServerName = this.getSNIServerName(exc);
                if (con == null && this.useHttp2 && (h2c = this.http2ClientPool.reserveStream(target.host(), target.port(), sslProvider, sniServerName, this.proxy, this.proxySSLContext)) != null) {
                    con = h2c.getConnection();
                    usingHttp2 = true;
                }
                if (con == null) {
                    con = this.conMgr.getConnection(target.host(), target.port(), this.localAddr, sslProvider, this.connectTimeout, sniServerName, this.proxy, this.proxySSLContext, this.getApplicationProtocols());
                    if (this.useHttp2 && Http2TlsSupport.isHttp2(con.socket)) {
                        usingHttp2 = true;
                    } else {
                        exc.setTargetConnection(con);
                    }
                    con.setKeepAttachedToExchange(usingHttp2 || exc.getRequest().isBindTargetConnectionToIncoming());
                }
                if (this.proxy != null && sslProvider == null) {
                    exc.getRequest().getHeader().setProxyAuthorization(this.proxy.getCredentials());
                }
                if (usingHttp2) {
                    response = this.doHttp2Call(exc, con, target, h2c, sslProvider, sniServerName);
                } else {
                    String newProtocol = null;
                    if (exc.getRequest().isCONNECTRequest()) {
                        this.handleConnectRequest(exc, con);
                        response = Response.ok().build();
                        newProtocol = "CONNECT";
                    } else {
                        response = this.doCall(exc, con);
                        if (trackNodeStatus) {
                            exc.setNodeStatusCode(counter, response.getStatusCode());
                        }
                        newProtocol = this.upgradeProtocol(exc, response, newProtocol);
                    }
                    if (newProtocol != null) {
                        HttpClient.setupConnectionForwarding(exc, con, newProtocol, this.streamPumpStats);
                        exc.getDestinations().clear();
                        exc.getDestinations().add(dest);
                        con.setExchange(exc);
                        exc.setResponse(response);
                        Exchange exchange = exc;
                        return exchange;
                    }
                }
                responseStatusCode = response.getStatusCode();
                if (httpClientStatusEventBus != null) {
                    httpClientStatusEventBus.reportResponse(dest, responseStatusCode);
                }
                if (!failOverOn5XX || !this.is5xx(responseStatusCode) || counter == this.maxRetries - 1) {
                    this.applyKeepAliveHeader(response, con);
                    exc.setDestinations(List.of(dest));
                    con.setExchange(exc);
                    if (!usingHttp2) {
                        response.addObserver(con);
                    }
                    exc.setResponse(response);
                    Exchange exchange = exc;
                    return exchange;
                }
            }
            catch (MalformedURLException e) {
                throw e;
            }
            catch (ConnectException e) {
                exception = e;
                log.info("Connection to {} refused.", target == null ? dest : target);
            }
            catch (SocketException e) {
                exception = e;
                if (e.getMessage().contains("Software caused connection abort")) {
                    log.info("Connection to {} was aborted externally. Maybe by the server or the OS Membrane is running on.", (Object)dest);
                } else if (e.getMessage().contains("Connection reset")) {
                    log.info("Connection to {} was reset externally. Maybe by the server or the OS Membrane is running on.", (Object)dest);
                } else {
                    this.logException(exc, counter, e);
                }
            }
            catch (SocketTimeoutException e) {
                log.info("Connection to {} timed out.", (Object)target);
                throw e;
            }
            catch (UnknownHostException e) {
                exception = e;
                log.warn("Unknown host: {}", target == null ? dest : target);
            }
            catch (EOFWhileReadingFirstLineException e) {
                exception = e;
                log.debug("Server connection to {} terminated before line was read. Line so far: {}", (Object)dest, (Object)e.getLineSoFar());
            }
            catch (NoResponseException e) {
                exception = e;
            }
            catch (Exception e) {
                exception = e;
                this.logException(exc, counter, e);
            }
            finally {
                if (trackNodeStatus && exception != null) {
                    exc.setNodeException(counter, exception);
                }
            }
            if (httpClientStatusEventBus != null) {
                if (exception != null) {
                    httpClientStatusEventBus.reportException(dest, exception);
                } else {
                    assert (responseStatusCode != null && this.is5xx(responseStatusCode));
                    httpClientStatusEventBus.reportResponse(dest, responseStatusCode);
                }
            }
            if (exception instanceof UnknownHostException ? exc.getDestinations().size() < 2 : exception instanceof NoResponseException) break;
            if (exc.getDestinations().size() != 1) continue;
            Thread.sleep(250L);
        }
        throw exception;
    }

    @Nullable
    private static Connection getConnection(Exchange exc, int counter, HostColonPort target) throws IOException {
        Connection con = null;
        if (counter == 0 && (con = exc.getTargetConnection()) != null) {
            if (!con.isSame(target.host(), target.port())) {
                con.close();
                con = null;
            } else {
                con.setKeepAttachedToExchange(true);
            }
        }
        return con;
    }

    private Response doHttp2Call(Exchange exc, Connection con, HostColonPort target, Http2Client h2c, SSLProvider sslProvider, String sniServerName) throws IOException, InterruptedException {
        if (h2c == null) {
            h2c = new Http2Client(con, sslProvider.showSSLExceptions());
            this.http2ClientPool.share(target.host(), target.port(), sslProvider, sniServerName, this.proxy, this.proxySSLContext, h2c);
        }
        Response response = h2c.doCall(exc, con);
        exc.setProperty(HTTP2, true);
        return response;
    }

    private static boolean trackNodeStatus(Exchange exc) {
        Object object = exc.getProperty("membrane.track.node.status");
        if (object instanceof Boolean) {
            Boolean status = (Boolean)object;
            return status;
        }
        return false;
    }

    private String[] getApplicationProtocols() {
        if (this.useHttp2) {
            return HTTP2_PROTOCOLS;
        }
        return HTTP1_PROTOCOLS;
    }

    private String upgradeProtocol(Exchange exc, Response response, String newProtocol) {
        if (exc.getProperty("membrane.use.websocket") == Boolean.TRUE && this.isUpgradeToResponse(response, "websocket")) {
            log.debug("Upgrading to WebSocket protocol.");
            return "WebSocket";
        }
        if (exc.getProperty("membrane.use.tcp") == Boolean.TRUE && this.isUpgradeToResponse(response, "tcp")) {
            log.debug("Upgrading to TCP protocol.");
            return "TCP";
        }
        return newProtocol;
    }

    private String getSNIServerName(Exchange exc) {
        Object sniObject = exc.getProperty("membrane.sni.server.name");
        if (sniObject == null) {
            return null;
        }
        return (String)sniObject;
    }

    private boolean is5xx(Integer responseStatusCode) {
        return 500 <= responseStatusCode && responseStatusCode < 600;
    }

    private void applyKeepAliveHeader(Response response, Connection con) {
        long max;
        String value = response.getHeader().getFirstValue("Keep-Alive");
        if (value == null) {
            return;
        }
        long timeoutSeconds = Header.parseKeepAliveHeader(value, "timeout");
        if (timeoutSeconds != -1L) {
            con.setTimeout(timeoutSeconds * 1000L);
        }
        if ((max = Header.parseKeepAliveHeader(value, "max")) != -1L && max < (long)con.getMaxExchanges()) {
            con.setMaxExchanges((int)max);
        }
    }

    private String getDestination(Exchange exc, int counter) {
        return exc.getDestinations().get(counter % exc.getDestinations().size());
    }

    private void logException(Exchange exc, int counter, Exception e) throws IOException {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("try # ");
            msg.append(counter);
            msg.append(" failed\n");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exc.getRequest().writeStartLine(baos);
            exc.getRequest().getHeader().write(baos);
            msg.append(StandardCharsets.ISO_8859_1.decode(ByteBuffer.wrap(baos.toByteArray())));
            if (e != null) {
                log.debug("{}", (Object)msg, (Object)e);
            } else {
                log.debug("{}", (Object)msg);
            }
        }
    }

    private Response doCall(Exchange exc, Connection con) throws IOException, EndOfStreamException {
        con.socket.setSoTimeout(this.soTimeout);
        exc.getRequest().write(con.out, this.maxRetries > 1);
        exc.setTimeReqSent(System.currentTimeMillis());
        if (exc.getRequest().isHTTP10()) {
            this.shutDownRequestInputOutput(exc, con);
        }
        Response res = new Response();
        res.read(con.in, !exc.getRequest().isHEADRequest());
        if (res.getStatusCode() == 100) {
            this.do100ExpectedHandling(exc, res, con);
        }
        exc.setReceived();
        exc.setTimeResReceived(System.currentTimeMillis());
        return res;
    }

    public static void setupConnectionForwarding(Exchange exc, final Connection con, final String protocol, StreamPump.StreamPumpStats streamPumpStats) throws SocketException {
        StreamPump b;
        StreamPump a;
        HttpServerHandler hsr = (HttpServerHandler)exc.getHandler();
        String source = hsr.getSourceSocket().getRemoteSocketAddress().toString();
        String dest = con.toString();
        if ("WebSocket".equals(protocol)) {
            WebSocketStreamPump aTemp = new WebSocketStreamPump(hsr.getSrcIn(), con.out, streamPumpStats, protocol + " " + source + " -> " + dest, exc.getProxy(), true, exc);
            WebSocketStreamPump bTemp = new WebSocketStreamPump(con.in, hsr.getSrcOut(), streamPumpStats, protocol + " " + source + " <- " + dest, exc.getProxy(), false, null);
            aTemp.init(bTemp);
            bTemp.init(aTemp);
            a = aTemp;
            b = bTemp;
        } else {
            a = new StreamPump(hsr.getSrcIn(), con.out, streamPumpStats, protocol + " " + source + " -> " + dest, exc.getProxy());
            b = new StreamPump(con.in, hsr.getSrcOut(), streamPumpStats, protocol + " " + source + " <- " + dest, exc.getProxy());
        }
        hsr.getSourceSocket().setSoTimeout(0);
        exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

            @Override
            public void setExchangeFinished() {
                HttpClient.runClient(log, b, protocol, a, con);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runClient(Logger log, StreamPump b, String protocol, StreamPump a, Connection con) {
        String threadName = Thread.currentThread().getName();
        new Thread((Runnable)b, threadName + " " + protocol + " Backward Thread").start();
        try {
            Thread.currentThread().setName(threadName + " " + protocol + " Onward Thread");
            a.run();
        }
        finally {
            try {
                con.close();
            }
            catch (IOException e) {
                log.debug("", (Throwable)e);
            }
        }
    }

    private boolean isUpgradeToResponse(Response res, String protocol) {
        return res.getStatusCode() == 101 && "upgrade".equalsIgnoreCase(res.getHeader().getFirstValue("Connection")) && protocol.equalsIgnoreCase(res.getHeader().getFirstValue("Upgrade"));
    }

    private void handleConnectRequest(Exchange exc, Connection con) throws IOException, EndOfStreamException {
        if (this.proxy != null) {
            exc.getRequest().write(con.out, this.maxRetries > 1);
            Response response = new Response();
            response.read(con.in, false);
            log.debug("Status code response on CONNECT request: {}", (Object)response.getStatusCode());
        }
        exc.getRequest().setUri("N/A");
    }

    private void do100ExpectedHandling(Exchange exc, Response response, Connection con) throws IOException, EndOfStreamException {
        exc.getRequest().getBody().write(exc.getRequest().getHeader().isChunked() ? new ChunkedBodyTransferrer(con.out) : new PlainBodyTransferrer(con.out), this.maxRetries > 1);
        con.out.flush();
        response.read(con.in, !exc.getRequest().isHEADRequest());
    }

    private void shutDownRequestInputOutput(Exchange exc, Connection con) throws IOException {
        exc.getHandler().shutdownInput();
        Util.shutdownOutput(con.socket);
    }

    ConnectionManager getConnectionManager() {
        return this.conMgr;
    }

    @Override
    public void close() {
        this.conMgr.shutdownWhenDone();
        if (this.http2ClientPool != null) {
            this.http2ClientPool.shutdownWhenDone();
        }
    }

    static {
        HTTP2_PROTOCOLS = new String[]{HTTP2};
        HTTP1_PROTOCOLS = new String[0];
    }
}

