/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.TimerManager;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

public class HttpClientFactory {
    @Nullable
    private final TimerManager timerManager;
    private WeakHashMap<Config, HttpClient> clients;

    public HttpClientFactory(@Nullable TimerManager timerManager) {
        this.timerManager = timerManager;
    }

    public synchronized HttpClient createClient(@Nullable HttpClientConfiguration httpClientConfiguration) {
        Config config;
        HttpClient hc;
        if (this.clients == null) {
            this.clients = new WeakHashMap();
        }
        if ((hc = this.clients.get(config = new Config(httpClientConfiguration, this.timerManager))) == null) {
            hc = new HttpClient(httpClientConfiguration, this.timerManager);
            this.clients.put(config, hc);
        }
        return hc;
    }

    private static class Config {
        final HttpClientConfiguration httpClientConfiguration;
        final TimerManager timerManager;

        public Config(@Nullable HttpClientConfiguration httpClientConfiguration, @Nullable TimerManager timerManager) {
            this.httpClientConfiguration = httpClientConfiguration;
            this.timerManager = timerManager;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            return Objects.equals(this.httpClientConfiguration, config.httpClientConfiguration) && Objects.equals(this.timerManager, config.timerManager);
        }

        public int hashCode() {
            return Objects.hash(this.httpClientConfiguration, this.timerManager);
        }
    }
}

