/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.transport.http.HttpClientStatusEventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientStatusEventBus {
    static final Logger log = LoggerFactory.getLogger((String)HttpClientStatusEventBus.class.getName());
    public static final String EXCHANGE_PROPERTY_NAME = "HttpClientStatusEventBus";
    private final List<HttpClientStatusEventListener> listeners = new CopyOnWriteArrayList<HttpClientStatusEventListener>();

    public void registerListener(HttpClientStatusEventListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Already registered: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
    }

    public void reportResponse(String destination, int responseCode) {
        long timestamp = System.currentTimeMillis();
        for (HttpClientStatusEventListener listener : this.listeners) {
            try {
                listener.onResponse(timestamp, destination, responseCode);
            }
            catch (Exception e) {
                log.warn("Listener " + String.valueOf(listener) + " threw exception (it is logged and ignored)", (Throwable)e);
            }
        }
    }

    public void reportException(String destination, Exception exception) {
        long timestamp = System.currentTimeMillis();
        for (HttpClientStatusEventListener listener : this.listeners) {
            try {
                listener.onException(timestamp, destination, exception);
            }
            catch (Exception e) {
                log.warn("Listener " + String.valueOf(listener) + " threw exception (it is logged and ignored)", (Throwable)e);
            }
        }
    }
}

