/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.transport.PortOccupiedException;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http.HttpTransport;
import com.predic8.membrane.core.transport.http.IpPort;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.util.NetworkUtil;
import com.predic8.membrane.core.util.Pair;
import com.predic8.membrane.core.util.TimerManager;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpEndpointListener
extends Thread {
    private static final Logger log = LoggerFactory.getLogger((String)HttpEndpointListener.class.getName());
    private static final byte[] TLS_ALERT_INTERNAL_ERROR = new byte[]{21, 3, 1, 0, 2, 2, 80};
    private final ServerSocket serverSocket;
    private final HttpTransport transport;
    private final SSLProvider sslProvider;
    private final ConcurrentHashMap<Socket, Boolean> idleSockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<Socket, Boolean> openSockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<InetAddress, ClientInfo> ipConnectionCount = new ConcurrentHashMap();
    private TimerManager timerManager;
    private volatile boolean closed;

    public HttpEndpointListener(IpPort p, HttpTransport transport, SSLProvider sslProvider, @Nullable TimerManager timerManager) throws IOException {
        this.transport = transport;
        this.sslProvider = sslProvider;
        try {
            this.serverSocket = this.getServerSocket(p);
            if (timerManager == null) {
                timerManager = this.timerManager = new TimerManager();
            }
            timerManager.schedulePeriodicTask(new TimerTask(){

                @Override
                public void run() {
                    Collection<ClientInfo> values = HttpEndpointListener.this.ipConnectionCount.values();
                    for (ClientInfo v : values) {
                        if (v.count.get() > 0 || System.currentTimeMillis() - v.lastUse < 600000L) continue;
                        values.remove(v);
                    }
                }
            }, 60000L, "HttpEndpointListener removing old IPs");
            String s = p.toShortString();
            this.setName("Connection Acceptor " + s);
            log.info("listening at {}", (Object)s);
        }
        catch (BindException e) {
            throw new PortOccupiedException(p);
        }
    }

    private ServerSocket getServerSocket(IpPort p) throws IOException {
        if (this.sslProvider != null) {
            return this.sslProvider.createServerSocket(p.port(), this.transport.getBacklog(), p.ip());
        }
        return new ServerSocket(p.port(), this.transport.getBacklog(), p.ip());
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                ClientInfo connectionCount;
                InetAddress remoteIp;
                Socket socket = this.serverSocket.accept();
                if (!this.isConnectionWithinLimit(socket, remoteIp = this.getRemoteIp(socket), connectionCount = this.getClientInfo(remoteIp))) continue;
                this.openSockets.put(socket, Boolean.TRUE);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Accepted connection from {}", (Object)socket.getRemoteSocketAddress());
                    }
                    this.transport.getExecutorService().execute(new HttpServerHandler(socket, this));
                }
                catch (RejectedExecutionException e) {
                    connectionCount.decrementAndGet();
                    this.openSockets.remove(socket);
                    log.error("HttpServerHandler execution rejected. Might be due to a proxies.xml hot deployment in progress or a low value for <transport maxThreadPoolSize=\"...\">.");
                    socket.close();
                }
            }
            catch (SocketException e) {
                String message = e.getMessage();
                if (message != null && (message.endsWith("socket closed") || message.endsWith("Socket closed"))) {
                    log.debug("socket closed.");
                    break;
                }
                log.error("", (Throwable)e);
            }
            catch (NullPointerException e) {
                log.error("", (Throwable)e);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            catch (Error e) {
                try {
                    log.error("", (Throwable)e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    System.err.println(e.getMessage());
                    System.err.println("Terminating because of Error in HttpEndpointListener.");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.exit(1);
            }
        }
    }

    private ClientInfo getClientInfo(InetAddress remoteIp) {
        ClientInfo connectionCount = this.ipConnectionCount.get(remoteIp);
        if (connectionCount != null) {
            return connectionCount;
        }
        ClientInfo oldconnectionCount = connectionCount = new ClientInfo();
        if ((connectionCount = this.ipConnectionCount.putIfAbsent(remoteIp, connectionCount)) == null) {
            return oldconnectionCount;
        }
        return connectionCount;
    }

    private boolean isConnectionWithinLimit(Socket socket, InetAddress remoteIp, ClientInfo connectionCount) throws IOException {
        int currentConnections;
        int concurrentConnectionLimitPerIp = this.transport.getConcurrentConnectionLimitPerIp();
        if (concurrentConnectionLimitPerIp == -1) {
            return true;
        }
        boolean connectionWithinLimit = true;
        do {
            if ((currentConnections = connectionCount.get()) < concurrentConnectionLimitPerIp) continue;
            log.warn(this.constructLogMessage(new StringBuilder(), remoteIp, NetworkUtil.readUpTo1KbOfDataFrom(socket, new byte[1023])));
            this.writeRateLimitReachedToSource(socket);
            socket.close();
            connectionWithinLimit = false;
            break;
        } while (!connectionCount.compareAndSet(currentConnections, currentConnections + 1));
        return connectionWithinLimit;
    }

    public void closePort() throws IOException {
        this.closed = true;
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            this.serverSocket.close();
        }
        if (this.sslProvider != null) {
            this.sslProvider.stop();
        }
    }

    public boolean closeConnections(boolean onlyIdle) {
        if (!this.closed) {
            throw new IllegalStateException("please call closePort() fist.");
        }
        for (Socket s : (onlyIdle ? this.idleSockets : this.openSockets).keySet()) {
            if (s.isClosed()) continue;
            try {
                s.close();
            }
            catch (IOException e) {
                log.error("Error closing connection to {}", (Object)s.getRemoteSocketAddress());
            }
        }
        if (this.timerManager != null) {
            this.timerManager.shutdown();
        }
        return this.openSockets.isEmpty();
    }

    void setIdleStatus(Socket socket, boolean isIdle) throws IOException {
        if (isIdle) {
            if (this.closed) {
                socket.close();
                throw new SocketException();
            }
            this.idleSockets.put(socket, Boolean.TRUE);
        } else {
            this.idleSockets.remove(socket);
        }
    }

    void setOpenStatus(Socket socket) {
        this.openSockets.remove(socket);
        ClientInfo clientInfo = this.ipConnectionCount.get(this.getRemoteIp(socket));
        if (clientInfo != null) {
            clientInfo.count.decrementAndGet();
        }
    }

    public int getNumberOfOpenConnections() {
        return this.openSockets.size();
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public SSLProvider getSslProvider() {
        return this.sslProvider;
    }

    private void writeRateLimitReachedToSource(Socket sourceSocket) throws IOException {
        if (this.sslProvider != null) {
            sourceSocket.getOutputStream().write(TLS_ALERT_INTERNAL_ERROR, 0, TLS_ALERT_INTERNAL_ERROR.length);
        } else {
            log.warn("Limit of {} concurrent connections per client is reached.", (Object)this.transport.getConcurrentConnectionLimitPerIp());
            ProblemDetails.user(false, "http-endpoint-listener").statusCode(429).addSubType("rate-limit").title("Limit of concurrent connections per client is reached.").detail("There is a limit of concurrent connections per client to avoid denial of service attacks.").build().write(sourceSocket.getOutputStream(), false);
        }
        sourceSocket.getOutputStream().flush();
    }

    private String constructLogMessage(StringBuilder sb, InetAddress ip, Pair<byte[], Integer> receivedContent) {
        return sb.append("Concurrent connection limit reached for IP: ").append(ip.toString()).append(System.lineSeparator()).append("Received the following content").append(System.lineSeparator()).append("===START===").append(System.lineSeparator()).append(new String(receivedContent.first(), 0, (int)receivedContent.second())).append(System.lineSeparator()).append("===END===").toString();
    }

    private InetAddress getRemoteIp(Socket socket) {
        return ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress();
    }

    private static class ClientInfo {
        public final AtomicInteger count = new AtomicInteger();
        public volatile long lastUse = System.currentTimeMillis();

        public int get() {
            return this.count.get();
        }

        public void decrementAndGet() {
            this.count.decrementAndGet();
            this.lastUse = System.currentTimeMillis();
        }

        public boolean compareAndSet(int expected, int update) {
            boolean b = this.count.compareAndSet(expected, update);
            this.lastUse = System.currentTimeMillis();
            return b;
        }
    }
}

