/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.proxies.Proxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPump
implements Runnable {
    protected static Logger log = LoggerFactory.getLogger((String)StreamPump.class.getName());
    protected final InputStream in;
    protected final OutputStream out;
    protected StreamPumpStats stats;
    protected AtomicLong bytesTransferred;
    private final String pumpName;
    private final long creationTime;
    private final Proxy proxy;

    public StreamPump(InputStream in, OutputStream out, StreamPumpStats stats, String name, Proxy proxy) {
        this.in = in;
        this.out = out;
        this.stats = stats;
        this.bytesTransferred = new AtomicLong();
        this.pumpName = name;
        this.creationTime = System.currentTimeMillis();
        this.proxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buffer = new byte[8192];
        if (this.stats != null) {
            this.stats.registerPump(this);
        }
        try {
            int length;
            while ((length = this.in.read(buffer)) > 0) {
                this.out.write(buffer, 0, length);
                this.out.flush();
                if (this.stats == null) continue;
                this.bytesTransferred.addAndGet(length);
            }
        }
        catch (SocketException | SocketTimeoutException | SSLException iOException) {
        }
        catch (IOException e) {
            log.error("Reading from or writing to stream failed: {}", (Object)e.getMessage());
        }
        finally {
            try {
                this.out.close();
            }
            catch (Exception exception) {}
            if (this.stats != null) {
                this.stats.unregisterPump(this);
            }
        }
    }

    public String getName() {
        return this.pumpName;
    }

    public String getServiceProxyName() {
        return this.proxy.getName();
    }

    public synchronized long getTransferredBytes() {
        return this.bytesTransferred.get();
    }

    public synchronized long getCreationTime() {
        return this.creationTime;
    }

    public synchronized void close() {
        try {
            log.debug("Closing Stream Pump {}", (Object)this.pumpName);
            this.in.close();
            this.out.close();
        }
        catch (IOException e) {
            log.error("While closing stream pump.", (Throwable)e);
        }
    }

    public static class StreamPumpStats {
        private static final ArrayList<StreamPump> pumps = new ArrayList();

        public synchronized int getRunning() {
            return pumps.size();
        }

        public synchronized void registerPump(StreamPump pump) {
            pumps.add(pump);
        }

        public synchronized void unregisterPump(StreamPump pump) {
            pumps.remove(pump);
        }

        public synchronized List<StreamPump> getStreamPumps() {
            return new ArrayList<StreamPump>(pumps);
        }

        public synchronized void closeAllStreamPumps() {
            for (StreamPump p : new ArrayList<StreamPump>(pumps)) {
                p.close();
            }
        }
    }
}

