/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.tunnel.WebSocketInterceptor;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.transport.http.StreamPump;
import com.predic8.membrane.core.transport.ws.WebSocketFrame;
import com.predic8.membrane.core.transport.ws.WebSocketFrameAssembler;
import com.predic8.membrane.core.transport.ws.WebSocketInterceptorInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketStreamPump
extends StreamPump {
    protected static Logger log = LoggerFactory.getLogger((String)WebSocketStreamPump.class.getName());
    List<WebSocketInterceptorInterface> chain = new ArrayList<WebSocketInterceptorInterface>();
    WebSocketStreamPump otherStreamPump;
    private final boolean pumpsToRight;
    boolean connectionIsOpen = true;
    WebSocketFrameAssembler frameAssembler;

    public WebSocketStreamPump(InputStream in, OutputStream out, StreamPump.StreamPumpStats stats, String name, Proxy proxy, boolean pumpsToRight, Exchange originalExchange) {
        super(in, out, stats, name, proxy);
        this.pumpsToRight = pumpsToRight;
        this.frameAssembler = new WebSocketFrameAssembler(in, originalExchange);
        for (Interceptor i : proxy.getInterceptors()) {
            if (!(i instanceof WebSocketInterceptor)) continue;
            this.chain = ((WebSocketInterceptor)i).getInterceptors();
            for (WebSocketInterceptorInterface i2 : this.chain) {
                try {
                    i2.init(i.getRouter());
                }
                catch (Exception e) {
                    log.error("Could not init WebSocketInterceptors.", (Throwable)e);
                }
            }
        }
    }

    public void init(WebSocketStreamPump otherStreamPump) {
        this.otherStreamPump = otherStreamPump;
    }

    @Override
    public void run() {
        if (this.otherStreamPump == null) {
            throw new RuntimeException("Call init with other WebSocketStreamPump (backward direction)");
        }
        try {
            this.frameAssembler.readFrames(frame -> {
                try {
                    if (this.pumpsToRight) {
                        this.passFrameToChainElement(0, true, (WebSocketFrame)frame);
                    } else {
                        this.passFrameToChainElement(this.chain.size() - 1, false, (WebSocketFrame)frame);
                    }
                }
                catch (Exception e) {
                    log.error("Error while reading frames.", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            this.connectionIsOpen = false;
            String entity = this.pumpsToRight ? "client to server" : "server to client";
            log.debug("", (Throwable)e);
            log.info("Connection from {}: {}", (Object)entity, (Object)e.fillInStackTrace().toString());
        }
        finally {
            try {
                this.out.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passFrameToChainElement(int i, boolean frameTravelsToRight, WebSocketFrame frame) throws Exception {
        if (this.chain.isEmpty()) {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                frame.write(this.out);
            }
            return;
        }
        if (i == -1) {
            OutputStream target;
            OutputStream outputStream = target = this.pumpsToRight ? this.otherStreamPump.out : this.out;
            synchronized (outputStream) {
                frame.write(target);
            }
        } else if (this.chain.size() == i) {
            OutputStream target;
            OutputStream outputStream = target = this.pumpsToRight ? this.out : this.otherStreamPump.out;
            synchronized (outputStream) {
                frame.write(target);
            }
        } else {
            this.chain.get(i).handleFrame(frame, frameTravelsToRight, frame1 -> this.passFrameToChainElement(i + (frameTravelsToRight ? 1 : -1), frameTravelsToRight, frame1));
        }
    }
}

