/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.transport.http2.FrameSender;
import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.frame.WindowUpdateFrame;
import java.io.IOException;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControl {
    private static final Logger log = LoggerFactory.getLogger(FlowControl.class);
    private final int streamId;
    private final FrameSender sender;
    @GuardedBy(value="this")
    public long ourWindowSize;
    @GuardedBy(value="this")
    public long ourWindowPositionReceived;
    @GuardedBy(value="this")
    public long ourWindowPositionProcessed;
    @GuardedBy(value="this")
    public int ourWindowSizeStep;

    public FlowControl(int streamId, FrameSender sender, Settings ourSettings) {
        this.streamId = streamId;
        this.sender = sender;
        this.ourWindowSize = ourSettings.getInitialWindowSize();
        this.ourWindowSizeStep = ourSettings.getInitialWindowSize();
    }

    public synchronized void received(int length) {
        this.ourWindowPositionReceived += (long)length;
        if (log.isDebugEnabled()) {
            log.debug("stream=" + this.streamId + " size=" + this.ourWindowSize + " pos=" + this.ourWindowPositionReceived + " diff=" + (this.ourWindowSize - this.ourWindowPositionReceived));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processed(int length) throws IOException {
        int windowIncrease = 0;
        FlowControl flowControl = this;
        synchronized (flowControl) {
            this.ourWindowPositionProcessed += (long)length;
            if (this.ourWindowSize - this.ourWindowPositionProcessed < (long)(this.ourWindowSizeStep >> 1)) {
                windowIncrease = this.increaseWindow();
            }
            if (log.isDebugEnabled()) {
                log.debug("stream=" + this.streamId + " size=" + this.ourWindowSize + " pos=" + this.ourWindowPositionReceived + " diff=" + (this.ourWindowSize - this.ourWindowPositionReceived));
            }
        }
        if (windowIncrease != 0) {
            this.sender.send(WindowUpdateFrame.inc(this.streamId, windowIncrease));
        }
    }

    private int increaseWindow() throws IOException {
        this.ourWindowSize += (long)this.ourWindowSizeStep;
        return this.ourWindowSizeStep;
    }
}

