/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http2.Http2ExchangeHandler;
import com.predic8.membrane.core.transport.http2.Http2Logic;
import com.predic8.membrane.core.transport.http2.Http2MessageHandler;
import com.predic8.membrane.core.transport.http2.Http2ServerHandler;
import com.predic8.membrane.core.transport.http2.StreamInfo;
import com.predic8.membrane.core.transport.http2.StreamState;
import com.predic8.membrane.core.transport.http2.frame.GoawayFrame;
import com.predic8.membrane.core.util.Util;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2Client
implements Runnable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Http2Client.class);
    private static final ExecutorService executor = Util.createNewThreadPool();
    private final ConcurrentHashMap<Integer, ResponseInfo> responses = new ConcurrentHashMap();
    private final Connection con;
    private final Http2Logic logic;
    @GuardedBy(value="this")
    private int reserved;

    public Http2Client(Connection con, boolean showSSLExceptions) {
        this.con = con;
        this.logic = new Http2Logic(executor, con.socket, con.in, con.out, showSSLExceptions, new Http2MessageHandler(){

            @Override
            public Message createMessage() {
                Response response = new Response();
                response.getHeader().setValue("Transfer-Encoding", "chunked");
                return response;
            }

            @Override
            public void handleExchange(StreamInfo streamInfo, Message message, boolean showSSLExceptions, String remoteAddr) {
                ResponseInfo ri = Http2Client.this.responses.get(streamInfo.getStreamId());
                if (ri != null) {
                    ri.response = (Response)message;
                    ri.cdl.countDown();
                }
            }
        });
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doCall(Exchange exc, Connection con) throws IOException, InterruptedException {
        int streamId;
        Http2Client http2Client = this;
        synchronized (http2Client) {
            if (this.reserved > 0) {
                --this.reserved;
            }
            streamId = this.logic.nextClientStreamId.getAndAccumulate(2, Integer::sum);
        }
        ResponseInfo ri = new ResponseInfo();
        this.responses.put(streamId, ri);
        try {
            StreamInfo streamInfo = new StreamInfo(streamId, this.logic.sender, this.logic.peerSettings, this.logic.ourSettings);
            this.logic.streams.put(streamId, streamInfo);
            this.logic.sender.send(streamId, (encoder, peerSettings) -> Http2ExchangeHandler.createHeadersFrames(exc.getRequest(), exc.getRequest().getHeader(), streamId, encoder, peerSettings, false));
            Http2ExchangeHandler.writeMessageBody(streamId, streamInfo, this.logic.sender, this.logic.peerSettings, this.logic.peerFlowControl, exc.getRequest());
            ri.cdl.await();
            Response response = ri.response;
            return response;
        }
        finally {
            this.responses.remove(streamId);
        }
    }

    @Override
    public void run() {
        try {
            this.updateThreadName(true);
            LOG.debug("sending PREFACE.");
            this.con.out.write(Http2ServerHandler.PREFACE);
            this.logic.init();
            this.logic.handle();
        }
        catch (Exception e) {
            if (this.logic.receiving) {
                e.printStackTrace();
            }
        }
        finally {
            this.updateThreadName(false);
        }
    }

    private void updateThreadName(boolean fromConnection) {
        if (fromConnection) {
            Thread.currentThread().setName("HTTP2 Client " + Http2Logic.getRemoteAddr(this.con.socket));
        } else {
            Thread.currentThread().setName("router");
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserveStream() {
        int max = this.getMax();
        Http2Client http2Client = this;
        synchronized (http2Client) {
            int current = this.logic.streams.size() + this.reserved;
            if (current < 0 || current >= max) {
                return false;
            }
            ++this.reserved;
            return true;
        }
    }

    private int getMax() {
        int max = this.logic.peerSettings.getMaxConcurrentStreams();
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    @Override
    public void close() {
        try {
            LOG.debug("stop receiving frames.");
            this.logic.receiving = false;
            this.logic.sender.send(GoawayFrame.construct(0, this.logic.nextClientStreamId.get(), 0));
            LOG.debug("terminating frame sender.");
            this.logic.sender.stop();
            try {
                this.logic.senderFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            this.con.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isIdle() {
        for (StreamInfo value : this.logic.streams.values()) {
            if (value.getState() == StreamState.CLOSED) continue;
            return false;
        }
        return true;
    }

    private static class ResponseInfo {
        private final CountDownLatch cdl = new CountDownLatch(1);
        private Response response;

        private ResponseInfo() {
        }
    }
}

