/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.transport.http.ConnectionKey;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import com.predic8.membrane.core.transport.http2.Http2Client;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ClientPool {
    private static Logger log = LoggerFactory.getLogger((String)Http2ClientPool.class.getName());
    private final long keepAliveTimeout;
    @GuardedBy(value="availableConnections")
    private final HashMap<ConnectionKey, ArrayList<Http2Client>> availableConnections = new HashMap();
    private final Timer timer;
    private volatile boolean shutdownWhenDone = false;

    public Http2ClientPool(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
        long autoCloseInterval = keepAliveTimeout * 2L;
        this.timer = new Timer("Connection Closer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (Http2ClientPool.this.closeOldConnections() == 0 && Http2ClientPool.this.shutdownWhenDone) {
                    Http2ClientPool.this.timer.cancel();
                }
            }
        }, autoCloseInterval, autoCloseInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Http2Client reserveStream(String host, int port, SSLProvider sslProvider, String sniServerName, ProxyConfiguration proxy, SSLContext proxySSLContext) {
        ConnectionKey key = new ConnectionKey(host, port, sslProvider, sniServerName, proxy, proxySSLContext);
        HashMap<ConnectionKey, ArrayList<Http2Client>> hashMap = this.availableConnections;
        synchronized (hashMap) {
            ArrayList<Http2Client> http2Clients = this.availableConnections.get(key);
            if (http2Clients == null) {
                return null;
            }
            for (Http2Client h2c : http2Clients) {
                if (!h2c.reserveStream()) continue;
                return h2c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void share(String host, int port, SSLProvider sslProvider, String sniServerName, ProxyConfiguration proxy, SSLContext proxySSLContext, Http2Client h2c) {
        ConnectionKey key = new ConnectionKey(host, port, sslProvider, sniServerName, proxy, proxySSLContext);
        HashMap<ConnectionKey, ArrayList<Http2Client>> hashMap = this.availableConnections;
        synchronized (hashMap) {
            ArrayList http2Clients = this.availableConnections.computeIfAbsent(key, k -> new ArrayList());
            http2Clients.add(h2c);
        }
    }

    public void shutdownWhenDone() {
        this.shutdownWhenDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int closeOldConnections() {
        int remaining;
        ArrayList<ConnectionKey> toRemove = new ArrayList<ConnectionKey>();
        ArrayList<Http2Client> toClose = new ArrayList<Http2Client>();
        log.trace("closing old connections");
        int closed = 0;
        HashMap<ConnectionKey, ArrayList<Http2Client>> hashMap = this.availableConnections;
        synchronized (hashMap) {
            for (Map.Entry<ConnectionKey, ArrayList<Http2Client>> e : this.availableConnections.entrySet()) {
                ArrayList<Http2Client> l = e.getValue();
                for (int i = 0; i < l.size(); ++i) {
                    Http2Client o = l.get(i);
                    if (!o.isIdle()) continue;
                    if (i == l.size() - 1) {
                        l.remove(i);
                    } else {
                        l.set(i, l.remove(l.size() - 1));
                    }
                    --i;
                    ++closed;
                    toClose.add(o);
                }
                if (!l.isEmpty()) continue;
                toRemove.add(e.getKey());
            }
            for (ConnectionKey remove : toRemove) {
                this.availableConnections.remove(remove);
            }
            remaining = this.availableConnections.size();
        }
        for (Http2Client c : toClose) {
            try {
                c.close();
            }
            catch (Exception exception) {}
        }
        if (closed != 0) {
            log.debug("closed " + closed + " connections");
        }
        return remaining;
    }
}

