/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.google.common.collect.ImmutableList;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.ExchangeState;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.FlowController;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.AbortException;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.NoMoreRequestsException;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.transport.http2.FrameSender;
import com.predic8.membrane.core.transport.http2.PeerFlowControl;
import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.StreamInfo;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import com.predic8.membrane.core.transport.http2.frame.RstStreamFrame;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.twitter.hpack.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ExchangeHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((String)Http2ExchangeHandler.class.getName());
    private final StreamInfo streamInfo;
    private final Transport transport;
    private final FrameSender sender;
    private final Settings peerSettings;
    private final PeerFlowControl peerFlowControl;
    private final Exchange exchange;
    private final boolean showSSLExceptions;
    private final String remoteAddr;
    private final int streamId;

    public Http2ExchangeHandler(StreamInfo streamInfo, Transport transport, FrameSender sender, Settings peerSettings, PeerFlowControl peerFlowControl, Exchange exchange, boolean showSSLExceptions, String remoteAddr) {
        this.streamInfo = streamInfo;
        this.transport = transport;
        this.sender = sender;
        this.peerSettings = peerSettings;
        this.peerFlowControl = peerFlowControl;
        this.exchange = exchange;
        this.showSSLExceptions = showSSLExceptions;
        this.remoteAddr = remoteAddr;
        this.streamId = streamInfo.getStreamId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.updateThreadName(true);
            this.process();
            this.exchange.detach();
        }
        catch (SocketTimeoutException e) {
            log.debug("Socket timed out");
        }
        catch (SocketException se) {
            log.debug("client socket closed");
        }
        catch (SSLException s) {
            if (this.showSSLExceptions) {
                Throwable throwable = s.getCause();
                if (throwable instanceof SSLException) {
                    SSLException cause = (SSLException)throwable;
                    Http2ExchangeHandler.logSSLException(cause);
                    return;
                }
                Http2ExchangeHandler.logSSLException(s);
            }
        }
        catch (EndOfStreamException e) {
            log.debug("stream closed");
        }
        catch (AbortException e) {
            log.debug("exchange aborted.");
        }
        catch (NoMoreRequestsException e) {
        }
        catch (NoResponseException e) {
            log.debug("No response received. Maybe increase the keep-alive timeout on the server.");
        }
        catch (EOFWhileReadingFirstLineException e) {
            log.debug("Client connection terminated before line was read. Line so far: ({})", (Object)e.getLineSoFar());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.closeConnections();
            this.exchange.detach();
            this.updateThreadName(false);
        }
    }

    private static void logSSLException(SSLException s) {
        if (s.getCause() instanceof SocketException) {
            log.debug("ssl socket closed");
        } else {
            log.error("", (Throwable)s);
        }
    }

    private void process() throws Exception {
        try {
            this.invokeHandlers();
            this.exchange.blockResponseIfNeeded();
        }
        catch (AbortException e) {
            log.debug("Aborted");
            this.exchange.finishExchange(true, e.getMessage());
            this.removeBodyFromBuffer();
            this.writeResponse(this.exchange.getResponse());
            log.debug("exchange set aborted");
            return;
        }
        try {
            this.removeBodyFromBuffer();
            this.writeResponse(this.exchange.getResponse());
            this.exchange.setCompleted();
            log.debug("exchange set completed");
        }
        catch (Exception e) {
            this.exchange.finishExchange(true, e.getMessage());
            throw e;
        }
    }

    private void invokeHandlers() throws AbortException {
        try {
            this.getFlowController().invokeRequestHandlers(this.exchange, this.transport.getInterceptors());
            if (this.exchange.getResponse() == null) {
                throw new AbortException("No response was generated by the interceptor chain.");
            }
        }
        catch (Exception e) {
            if (this.exchange.getResponse() == null) {
                this.exchange.setResponse(this.generateErrorResponse(e));
            }
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbortException.class, NoMoreRequestsException.class, NoResponseException.class, EOFWhileReadingFirstLineException.class}, (Object)exception2, n)) {
                case 0: {
                    AbortException abortException = (AbortException)exception2;
                    throw abortException;
                }
                case 1: {
                    NoMoreRequestsException noMoreRequestsException = (NoMoreRequestsException)exception2;
                    throw noMoreRequestsException;
                }
                case 2: {
                    NoResponseException noResponseException = (NoResponseException)exception2;
                    throw noResponseException;
                }
                case 3: {
                    EOFWhileReadingFirstLineException eofWhileReadingFirstLineException = (EOFWhileReadingFirstLineException)exception2;
                    throw eofWhileReadingFirstLineException;
                }
            }
            log.warn("An exception occurred while handling a request: ", (Throwable)e);
        }
    }

    private FlowController getFlowController() {
        return this.transport.getRouter().getFlowController();
    }

    private Response generateErrorResponse(Exception e) {
        return ProblemDetails.internal(this.transport.getRouter().isProduction(), "http2-exchange-handler").exception(e).build();
    }

    private void updateThreadName(boolean fromConnection) {
        if (fromConnection) {
            String sb = "router " + this.remoteAddr + " stream " + this.streamId;
            Thread.currentThread().setName(sb);
        } else {
            Thread.currentThread().setName("router");
        }
    }

    protected void writeResponse(Response res) throws Exception {
        this.sender.send(this.streamId, (encoder, peerSettings) -> Http2ExchangeHandler.createHeadersFrames(res, res.getHeader(), this.streamId, encoder, peerSettings, false));
        Http2ExchangeHandler.writeMessageBody(this.streamId, this.streamInfo, this.sender, this.peerSettings, this.peerFlowControl, res);
        this.exchange.setTimeResSent(System.currentTimeMillis());
        this.exchange.collectStatistics();
    }

    public static void writeMessageBody(final int streamId, final StreamInfo streamInfo, final FrameSender sender, final Settings peerSettings, final PeerFlowControl peerFlowControl, Message res) throws IOException {
        res.getBody().write(new AbstractBodyTransferrer(){

            @Override
            public void write(byte[] content, int i, int length) {
                this.sendData(content, i, length);
            }

            private void sendData(byte[] content, int offset, int length) {
                int mLength;
                for (int mOffset = offset; mOffset < offset + length; mOffset += mLength) {
                    mLength = Math.min(peerSettings.getMaxFrameSize(), length - (mOffset - offset));
                    streamInfo.getPeerFlowControl().reserve(mLength, streamId);
                    peerFlowControl.reserve(mLength, streamId);
                    Frame frame = new Frame();
                    frame.fill(0, 0, streamId, content, mOffset, mLength);
                    sender.send(frame);
                }
            }

            @Override
            public void write(Chunk chunk) {
                this.sendData(chunk.getContent(), 0, chunk.getLength());
            }

            @Override
            public void finish(Header header) throws IOException {
                if (header != null) {
                    while (!streamInfo.getDataFramesToBeSent().isEmpty()) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    sender.send(streamId, (encoder, peerSettings) -> Http2ExchangeHandler.createHeadersFrames(null, header, streamId, encoder, peerSettings, true));
                } else {
                    Frame frame = new Frame();
                    frame.fill(0, 1, streamId, null, 0, 0);
                    sender.send(frame);
                }
            }
        }, false);
    }

    public static List<Frame> createHeadersFrames(Message res, Header header, int streamId, Encoder encoder, Settings peerSettings, boolean isAtEof) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        encoder.setMaxHeaderTableSize((OutputStream)baos, peerSettings.getHeaderTableSize());
        StringBuilder sb = null;
        if (log.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("Headers on stream ");
            sb.append(streamId);
            sb.append(":\n");
        }
        if (res instanceof Request) {
            Request req = (Request)res;
            Http2ExchangeHandler.encodeHeader(encoder, baos, sb, ":method", req.getMethod());
            Http2ExchangeHandler.encodeHeader(encoder, baos, sb, ":scheme", "https");
            Http2ExchangeHandler.encodeHeader(encoder, baos, sb, ":path", req.getUri());
            Http2ExchangeHandler.encodeHeader(encoder, baos, sb, ":authority", req.getHeader().getHost());
        }
        if (res instanceof Response) {
            Response response = (Response)res;
            Http2ExchangeHandler.encodeHeader(encoder, baos, sb, ":status", "" + response.getStatusCode());
        }
        for (HeaderField hf : header.getAllHeaderFields()) {
            String key = hf.getHeaderName().toString().toLowerCase();
            if ("keep-alive".equals(key) || "proxy-connection".equals(key) || "transfer-encoding".equals(key) || "upgrade".equals(key) || "connection".equals(key) || "host".equals(key)) continue;
            Http2ExchangeHandler.encodeHeader(encoder, baos, sb, key, hf.getValue());
        }
        if (sb != null) {
            log.debug(sb.toString());
        }
        return Http2ExchangeHandler.constructFrames(streamId, peerSettings, isAtEof, baos.toByteArray());
    }

    private static void encodeHeader(Encoder encoder, ByteArrayOutputStream baos, StringBuilder sb, String key, String val) throws IOException {
        boolean sensitive = "set-cookie".equals(key);
        encoder.encodeHeader((OutputStream)baos, key.getBytes(StandardCharsets.US_ASCII), val.getBytes(StandardCharsets.US_ASCII), sensitive);
        Http2ExchangeHandler.logHeader(sb, key, val, sensitive);
    }

    private static void logHeader(StringBuilder sb, String key, String val, boolean sensitive) {
        if (sb != null) {
            sb.append(key);
            sb.append(": ");
            sb.append(val);
            if (sensitive) {
                sb.append("    (sensitive)");
            }
            sb.append("\n");
        }
    }

    private static List<Frame> constructFrames(int streamId, Settings peerSettings, boolean isAtEof, byte[] buffer) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        int maxFrameSize = peerSettings.getMaxFrameSize();
        for (int offset = 0; offset < buffer.length; offset += maxFrameSize) {
            frames.add(Http2ExchangeHandler.constructFrame(streamId, isAtEof, buffer, maxFrameSize, offset));
        }
        return frames;
    }

    private static Frame constructFrame(int streamId, boolean isAtEof, byte[] buffer, int maxFrameSize, int offset) {
        Frame frame = new Frame();
        frame.fill(offset == 0 ? 1 : 9, (Http2ExchangeHandler.isLast(buffer, maxFrameSize, offset) ? 4 : 0) + (isAtEof ? 1 : 0), streamId, buffer, offset, Math.min(maxFrameSize, buffer.length - offset));
        return frame;
    }

    private static boolean isLast(byte[] buffer, int maxFrameSize, int offset) {
        return offset + maxFrameSize >= buffer.length;
    }

    private void removeBodyFromBuffer() {
    }

    private void closeConnections() {
        if (this.exchange.getStatus() != ExchangeState.COMPLETED) {
            try {
                this.sender.send(this.streamId, (encoder, peerSettings) -> ImmutableList.of((Object)RstStreamFrame.construct(this.streamId, 2)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

