/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http2.FlowControl;
import com.predic8.membrane.core.transport.http2.FrameSender;
import com.predic8.membrane.core.transport.http2.Http2MessageHandler;
import com.predic8.membrane.core.transport.http2.PeerFlowControl;
import com.predic8.membrane.core.transport.http2.PriorityTree;
import com.predic8.membrane.core.transport.http2.Settings;
import com.predic8.membrane.core.transport.http2.StreamInfo;
import com.predic8.membrane.core.transport.http2.frame.ContinuationFrame;
import com.predic8.membrane.core.transport.http2.frame.DataFrame;
import com.predic8.membrane.core.transport.http2.frame.FatalConnectionException;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import com.predic8.membrane.core.transport.http2.frame.GoawayFrame;
import com.predic8.membrane.core.transport.http2.frame.HeaderBlockFragment;
import com.predic8.membrane.core.transport.http2.frame.HeadersFrame;
import com.predic8.membrane.core.transport.http2.frame.PingFrame;
import com.predic8.membrane.core.transport.http2.frame.PriorityFrame;
import com.predic8.membrane.core.transport.http2.frame.RstStreamFrame;
import com.predic8.membrane.core.transport.http2.frame.SettingsFrame;
import com.predic8.membrane.core.transport.http2.frame.WindowUpdateFrame;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.twitter.hpack.Decoder;
import com.twitter.hpack.Encoder;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2Logic {
    private static final Logger log = LoggerFactory.getLogger((String)Http2Logic.class.getName());
    private static final int MAX_LINE_LENGTH;
    final InputStream srcIn;
    final FrameSender sender;
    private final boolean showSSLExceptions;
    private final Decoder decoder;
    private final String remoteAddr;
    private final FlowControl flowControl;
    final PeerFlowControl peerFlowControl;
    final Settings ourSettings = new Settings();
    final Settings peerSettings = new Settings();
    private final List<Settings> wantedSettings = new ArrayList<Settings>();
    final Map<Integer, StreamInfo> streams = new ConcurrentHashMap<Integer, StreamInfo>();
    private final PriorityTree priorityTree = new PriorityTree();
    private final ExecutorService executor;
    private final Http2MessageHandler messageHandler;
    final AtomicInteger nextClientStreamId = new AtomicInteger(1);
    volatile boolean receiving = true;
    Future<?> senderFuture;

    public Http2Logic(ExecutorService executor, Socket sourceSocket, InputStream srcIn, OutputStream srcOut, boolean showSSLExceptions, Http2MessageHandler messageHandler) {
        this.executor = executor;
        this.srcIn = srcIn;
        this.showSSLExceptions = showSSLExceptions;
        this.messageHandler = messageHandler;
        this.remoteAddr = Http2Logic.getRemoteAddr(sourceSocket);
        log.debug("started HTTP2 connection " + this.remoteAddr);
        int maxHeaderTableSize = 4096;
        this.decoder = new Decoder(MAX_LINE_LENGTH, maxHeaderTableSize);
        this.sender = new FrameSender(srcOut, new Encoder(maxHeaderTableSize), this.peerSettings, this.streams, this.remoteAddr);
        this.flowControl = new FlowControl(0, this.sender, this.ourSettings);
        this.peerFlowControl = new PeerFlowControl(0, this.sender, this.peerSettings);
        Settings newSettings = new Settings();
        newSettings.copyFrom(this.ourSettings);
        newSettings.setMaxConcurrentStreams(50);
        newSettings.setInitialWindowSize(131070);
        this.updateSettings(newSettings);
    }

    public void init() throws IOException {
        this.senderFuture = this.executor.submit(this.sender);
    }

    public static String getRemoteAddr(Socket sourceSocket) {
        StringBuilder sb = new StringBuilder();
        InetAddress ia = sourceSocket.getInetAddress();
        if (ia != null) {
            sb.append(ia);
        }
        sb.append(":");
        sb.append(sourceSocket.getPort());
        return sb.toString();
    }

    public void handle() throws IOException, EndOfStreamException {
        try {
            while (this.receiving) {
                Frame frame = new Frame(this.ourSettings);
                frame.read(this.srcIn);
                this.handleFrame(frame);
            }
        }
        catch (EOFException eof) {
            throw new EndOfStreamException("");
        }
        finally {
            this.sender.stop();
        }
    }

    private void updateSettings(Settings newSettings) {
        this.wantedSettings.add(newSettings);
        this.sender.send(SettingsFrame.diff(this.ourSettings, newSettings));
    }

    private void handleFrame(Frame frame) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("received: " + String.valueOf(frame));
        } else if (log.isDebugEnabled()) {
            log.debug("received: " + frame.getTypeString() + " length=" + frame.getLength());
        }
        switch (frame.getType()) {
            case 4: {
                this.handleFrame(frame.asSettings());
                break;
            }
            case 1: {
                this.handleFrame(frame.asHeaders());
                break;
            }
            case 8: {
                this.handleFrame(frame.asWindowUpdate());
                break;
            }
            case 9: {
                this.handleFrame(frame.asContinuation());
                break;
            }
            case 2: {
                this.handleFrame(frame.asPriority());
                break;
            }
            case 6: {
                this.handleFrame(frame.asPing());
                break;
            }
            case 0: {
                this.handleFrame(frame.asData());
                break;
            }
            case 3: {
                this.handleFrame(frame.asRstStream());
                break;
            }
            case 7: {
                this.handleFrame(frame.asGoaway());
                break;
            }
            default: {
                throw new NotImplementedException("frame type " + frame.getType());
            }
        }
    }

    private void handleFrame(GoawayFrame goawayFrame) throws IOException {
        if (goawayFrame.getFrame().getStreamId() != 0) {
            throw new FatalConnectionException(1);
        }
    }

    private void handleFrame(RstStreamFrame rstStream) throws IOException {
        rstStream.validateSize();
        int streamId = rstStream.getFrame().getStreamId();
        if (streamId == 0) {
            throw new FatalConnectionException(1);
        }
        StreamInfo streamInfo = this.streams.get(streamId);
        if (streamInfo == null) {
            throw new FatalConnectionException(1);
        }
        streamInfo.receivedRstStream();
    }

    private void handleFrame(DataFrame dataFrame) throws IOException {
        if (dataFrame.getFrame().getStreamId() == 0) {
            throw new FatalConnectionException(1);
        }
        StreamInfo streamInfo = this.streams.get(dataFrame.getFrame().getStreamId());
        if (streamInfo == null) {
            throw new FatalConnectionException(5);
        }
        streamInfo.receivedDataFrame(dataFrame);
        this.flowControl.received(dataFrame.getFrame().getLength());
        this.flowControl.processed(dataFrame.getFrame().getLength());
    }

    private void handleFrame(PingFrame ping) throws IOException {
        if (ping.isAck()) {
            return;
        }
        if (ping.getFrame().getStreamId() != 0) {
            throw new FatalConnectionException(1);
        }
        if (ping.getFrame().getLength() != 8) {
            throw new FatalConnectionException(6);
        }
        this.sender.send(PingFrame.pong(ping));
    }

    private void handleFrame(PriorityFrame priority) throws IOException {
        priority.validateSize();
        if (priority.getFrame().getStreamId() == 0) {
            throw new FatalConnectionException(1);
        }
        int streamId1 = priority.getFrame().getStreamId();
        StreamInfo streamInfo = this.streams.get(streamId1);
        if (streamInfo == null) {
            streamInfo = new StreamInfo(streamId1, this.sender, this.peerSettings, this.ourSettings);
            this.streams.put(streamId1, streamInfo);
        }
        streamInfo.receivedPriority();
        this.priorityTree.reprioritize(streamInfo, priority.getWeight(), this.streams.get(priority.getStreamDependency()), priority.isExclusive());
    }

    private void handleFrame(WindowUpdateFrame windowUpdate) throws IOException {
        if (windowUpdate.getFrame().getStreamId() == 0) {
            if (windowUpdate.getWindowSizeIncrement() == 0) {
                throw new FatalConnectionException(1);
            }
            this.peerFlowControl.increment(windowUpdate.getWindowSizeIncrement());
        } else {
            if (windowUpdate.getWindowSizeIncrement() == 0) {
                throw new FatalConnectionException(1);
            }
            StreamInfo streamInfo = this.streams.get(windowUpdate.getFrame().getStreamId());
            if (streamInfo == null) {
                throw new FatalConnectionException(1);
            }
            streamInfo.getPeerFlowControl().increment(windowUpdate.getWindowSizeIncrement());
        }
    }

    private void handleFrame(HeadersFrame headers) throws IOException {
        StringBuilder sb;
        Header header;
        Message request;
        int streamId1 = headers.getFrame().getStreamId();
        if (streamId1 == 0) {
            throw new FatalConnectionException(1);
        }
        StreamInfo streamInfo = this.streams.get(streamId1);
        if (streamInfo == null) {
            streamInfo = new StreamInfo(streamId1, this.sender, this.peerSettings, this.ourSettings);
            this.streams.put(streamId1, streamInfo);
        }
        boolean isTrailer = streamInfo.isTrailer();
        streamInfo.receivedHeaders();
        if (headers.isPriority()) {
            this.priorityTree.reprioritize(streamInfo, headers.getWeight(), this.streams.get(headers.getStreamDependency()), headers.isExclusive());
        } else {
            this.priorityTree.reprioritize(streamInfo, 16, null, false);
        }
        ArrayList<HeaderBlockFragment> headerFrames = new ArrayList<HeaderBlockFragment>();
        headerFrames.add(headers);
        HeaderBlockFragment last = headers;
        while (!last.isEndHeaders()) {
            Frame frame = new Frame(this.ourSettings);
            frame.read(this.srcIn);
            if (frame.getType() != 9) {
                throw new FatalConnectionException(1);
            }
            last = frame.asContinuation();
            int streamId = frame.getStreamId();
            if (streamId != streamId1) {
                throw new FatalConnectionException(1);
            }
            headerFrames.add(last);
        }
        log.debug("header isTrailer=" + isTrailer);
        if (isTrailer) {
            request = streamInfo.getMessage();
            header = new Header();
        } else {
            request = this.messageHandler.createMessage();
            streamInfo.setMessage(request);
            header = request.getHeader();
        }
        StringBuilder stringBuilder = sb = log.isDebugEnabled() ? new StringBuilder() : null;
        if (sb != null) {
            sb.append("Headers on stream ");
            sb.append(streamId1);
            sb.append(":\n");
        }
        this.decoder.decode(this.getPackedHeaderStream(headerFrames), (name, value, sensitive) -> {
            String key = new String(name);
            String val = new String(value);
            if (sb != null) {
                sb.append(key);
                sb.append(": ");
                sb.append(val);
                sb.append("\n");
            }
            if (":method".equals(key) && request instanceof Request) {
                ((Request)request).setMethod(val);
            } else if (!":scheme".equals(key)) {
                if (":authority".equals(key)) {
                    request.getHeader().setHost(val);
                } else if (":path".equals(key) && request instanceof Request) {
                    ((Request)request).setUri(val);
                    log.debug("streamId=" + streamId1 + " uri=" + val);
                } else if (":status".equals(key) && request instanceof Response) {
                    ((Response)request).setStatusCode(Integer.parseInt(val));
                    log.debug("streamId=" + streamId1 + " status=" + val);
                } else {
                    header.add(key, val);
                }
            }
        });
        if (this.decoder.endHeaderBlock()) {
            log.warn("dropped header exceeding configured maximum size of " + MAX_LINE_LENGTH + ".");
        }
        if (sb != null) {
            log.debug(sb.toString());
        }
        if (isTrailer) {
            request.getBody().setTrailer(header);
        } else {
            if (!headers.isEndStream()) {
                request.setBody(streamInfo.createBody());
            }
            this.messageHandler.handleExchange(streamInfo, request, this.showSSLExceptions, this.remoteAddr);
        }
        if (headers.isEndStream()) {
            streamInfo.receivedEndStream(false);
        }
    }

    public InputStream getPackedHeaderStream(List<HeaderBlockFragment> headerFrames) {
        if (headerFrames.size() == 1) {
            HeaderBlockFragment one = headerFrames.get(0);
            return new ByteArrayInputStream(one.getContent(), one.getHeaderBlockStartIndex(), one.getHeaderBlockLength());
        }
        int sum = 0;
        for (HeaderBlockFragment hbf : headerFrames) {
            sum += hbf.getHeaderBlockLength();
        }
        byte[] buf = new byte[sum];
        int offset = 0;
        for (HeaderBlockFragment hbf : headerFrames) {
            System.arraycopy(hbf.getContent(), hbf.getHeaderBlockStartIndex(), buf, offset, hbf.getHeaderBlockLength());
            offset += hbf.getHeaderBlockLength();
        }
        return new ByteArrayInputStream(buf);
    }

    private void handleFrame(ContinuationFrame continuation) throws IOException {
        throw new FatalConnectionException(1);
    }

    private void handleFrame(SettingsFrame settings) throws IOException {
        if (settings.getFrame().getLength() % 6 != 0) {
            throw new FatalConnectionException(6);
        }
        if (settings.getFrame().getStreamId() != 0) {
            throw new FatalConnectionException(1);
        }
        if (settings.isAck()) {
            this.ourSettings.copyFrom(this.wantedSettings.remove(0));
            return;
        }
        block8: for (int i = 0; i < settings.getSettingsCount(); ++i) {
            long settingsValue = settings.getSettingsValue(i);
            switch (settings.getSettingsId(i)) {
                case 5: {
                    if (settingsValue < 16384L || settingsValue > 0xFFFFFFL) {
                        throw new FatalConnectionException(1);
                    }
                    this.peerSettings.setMaxFrameSize((int)settingsValue);
                    continue block8;
                }
                case 2: {
                    if (settingsValue != 0L && settingsValue != 1L) {
                        throw new FatalConnectionException(1);
                    }
                    this.peerSettings.setEnablePush((int)settingsValue);
                    continue block8;
                }
                case 1: {
                    if (settingsValue > Integer.MAX_VALUE) {
                        System.err.println("HEADER_TABLE_SIZE > Integer.MAX_VALUE received: " + settingsValue);
                        throw new FatalConnectionException(1);
                    }
                    this.peerSettings.setHeaderTableSize((int)settingsValue);
                    continue block8;
                }
                case 3: {
                    if (settingsValue > Integer.MAX_VALUE) {
                        this.peerSettings.setMaxConcurrentStreams(Integer.MAX_VALUE);
                        continue block8;
                    }
                    this.peerSettings.setMaxConcurrentStreams((int)settingsValue);
                    continue block8;
                }
                case 4: {
                    if (settingsValue > 0x40000000L) {
                        throw new FatalConnectionException(3);
                    }
                    int delta = (int)settingsValue - this.peerSettings.getInitialWindowSize();
                    for (StreamInfo si : this.streams.values()) {
                        si.getPeerFlowControl().increment(delta);
                    }
                    this.peerSettings.setInitialWindowSize((int)settingsValue);
                    continue block8;
                }
                case 6: {
                    if (settingsValue > Integer.MAX_VALUE) {
                        this.peerSettings.setMaxHeaderListSize(Integer.MAX_VALUE);
                        continue block8;
                    }
                    this.peerSettings.setMaxHeaderListSize((int)settingsValue);
                    continue block8;
                }
                default: {
                    System.err.println("not implemented: setting " + settings.getSettingsId(i));
                }
            }
        }
        this.sender.send(SettingsFrame.ack());
    }

    static {
        String maxLineLength = System.getProperty("membrane.core.http.body.maxlinelength");
        MAX_LINE_LENGTH = maxLineLength == null ? 8092 : Integer.parseInt(maxLineLength);
    }
}

