/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2;

import com.google.common.collect.Lists;
import com.predic8.membrane.core.transport.http2.StreamInfo;
import com.predic8.membrane.core.transport.http2.frame.FatalConnectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityTree {
    private static final Logger log = LoggerFactory.getLogger(PriorityTree.class);
    private final StreamInfo root = new StreamInfo(0, null, null, null);

    public void reprioritize(@NotNull StreamInfo stream, int weight, @Null StreamInfo parent, boolean exclusive) throws IOException {
        if (parent == stream) {
            throw new FatalConnectionException(1);
        }
        if (parent == null) {
            parent = this.root;
        }
        if (log.isDebugEnabled()) {
            log.debug("reprioritize(streamId=" + stream.getStreamId() + ", weight=" + weight + ", parentStreamId=" + parent.getStreamId() + ", exclusive=" + exclusive + ")");
        }
        if (this.isChildOf(parent, stream)) {
            parent.getPriorityParent().getPriorityChildren().remove(parent);
            parent.setPriorityParent(null);
            StreamInfo otherNewParent = stream.getPriorityParent();
            otherNewParent.getPriorityChildren().add(parent);
            parent.setPriorityParent(otherNewParent);
        }
        if (exclusive) {
            for (StreamInfo streamInfo : parent.getPriorityChildren()) {
                streamInfo.setPriorityParent(stream);
            }
            stream.getPriorityChildren().addAll(parent.getPriorityChildren());
            parent.getPriorityChildren().clear();
        }
        if (stream.getPriorityParent() != null) {
            stream.getPriorityParent().getPriorityChildren().remove(stream);
        }
        parent.getPriorityChildren().add(stream);
        stream.setWeight(weight);
        stream.setPriorityParent(parent);
        if (log.isTraceEnabled()) {
            log.trace("\n" + this.toString());
        }
    }

    private boolean isChildOf(StreamInfo a, StreamInfo b) {
        StreamInfo p = a;
        do {
            if ((p = p.getPriorityParent()) != null) continue;
            return false;
        } while (p != b);
        return true;
    }

    private static List<StringBuilder> toStringBuilderList(StreamInfo node) {
        if (node.getPriorityChildren().size() == 0) {
            return Lists.newArrayList((Object[])new StringBuilder[]{PriorityTree.toStringBuilder(node)});
        }
        List<StreamInfo> priorityChildren = node.getPriorityChildren();
        ArrayList<List<StringBuilder>> cols = new ArrayList<List<StringBuilder>>(priorityChildren.size());
        for (StreamInfo streamInfo : priorityChildren) {
            cols.add(PriorityTree.toStringBuilderList(streamInfo));
        }
        List<StringBuilder> res = PriorityTree.merge(cols);
        res.add(0, PriorityTree.fill(PriorityTree.toStringBuilder(node), res.get(0).length()));
        return res;
    }

    private static StringBuilder toStringBuilder(StreamInfo node) {
        return new StringBuilder(node.getStreamId() + " w" + node.getWeight() + " " + String.valueOf((Object)node.getState()));
    }

    private static StringBuilder fill(StringBuilder sb, int length) {
        while (sb.length() < length) {
            sb.append(' ');
        }
        return sb;
    }

    private static List<StringBuilder> merge(List<List<StringBuilder>> matrix) {
        int row = 0;
        int orig = matrix.get(0).get(0).length();
        while (true) {
            StringBuilder rowSb = null;
            int spacesToInsert = 0;
            for (int col = 0; col < matrix.size(); ++col) {
                if (rowSb == null && row < matrix.get(col).size()) {
                    rowSb = matrix.get(col).get(row);
                    rowSb.insert(0, StringUtils.repeat((char)' ', (int)spacesToInsert));
                    rowSb.append("  ");
                    continue;
                }
                int spaces = (col == 0 ? orig : matrix.get(col).get(0).length()) + 2;
                if (rowSb != null) {
                    if (row < matrix.get(col).size()) {
                        rowSb.append((CharSequence)matrix.get(col).get(row));
                        rowSb.append("  ");
                    } else {
                        rowSb.append(StringUtils.repeat((char)' ', (int)spaces));
                    }
                }
                spacesToInsert += spaces;
            }
            if (rowSb == null) break;
            if (row >= matrix.get(0).size()) {
                matrix.get(0).add(rowSb);
            }
            ++row;
        }
        return matrix.get(0);
    }

    public String toString() {
        return String.join((CharSequence)"\n", PriorityTree.toStringBuilderList(this.root));
    }
}

