/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.Frame;
import com.predic8.membrane.core.transport.http2.frame.StreamEnd;

public class DataFrame
implements StreamEnd {
    public static final int FLAG_END_STREAM = 1;
    public static final int FLAG_PADDED = 8;
    private final Frame frame;
    private final int padLength;

    public DataFrame(Frame frame) {
        this.frame = frame;
        int p = 0;
        this.padLength = this.isPadded() ? frame.content[p++] : 0;
    }

    @Override
    public boolean isEndStream() {
        return (this.frame.flags & 1) != 0;
    }

    public boolean isPadded() {
        return (this.frame.flags & 8) != 0;
    }

    public int getDataStartIndex() {
        return 0;
    }

    public int getDataLength() {
        return this.frame.length - this.padLength;
    }

    public byte[] getContent() {
        return this.frame.getContent();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data {\n");
        sb.append("  streamId = ");
        sb.append(this.frame.streamId);
        sb.append("\n  flags = ");
        if (this.isPadded()) {
            sb.append("PADDED ");
        }
        if (this.isEndStream()) {
            sb.append("END_STREAM");
        }
        sb.append("\n");
        sb.append("  data: \n");
        this.frame.appendHex(sb, this.frame.content, this.getDataStartIndex(), this.getDataLength(), 2);
        sb.append("}");
        return sb.toString();
    }

    public Frame getFrame() {
        return this.frame;
    }
}

