/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.Frame;

public class PingFrame {
    public static final int FLAG_ACK = 1;
    private final Frame frame;

    public PingFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ping {\n");
        if (this.isAck()) {
            sb.append("  Flags: ACK\n");
        }
        sb.append("  data: \n");
        this.frame.appendHex(sb, this.frame.content, 0, this.frame.length, 2);
        sb.append("}");
        return sb.toString();
    }

    public boolean isAck() {
        return (this.frame.flags & 1) != 0;
    }

    public static Frame pong(PingFrame ping) {
        Frame frame = new Frame();
        frame.fill(6, 1, 0, ping.getFrame().getContent(), 0, ping.getFrame().getLength());
        return frame;
    }
}

