/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.FatalConnectionException;
import com.predic8.membrane.core.transport.http2.frame.Frame;
import java.io.IOException;

public class PriorityFrame {
    private final Frame frame;
    private final boolean exclusive;
    private final int streamDependency;
    private final int weight;

    public PriorityFrame(Frame frame) {
        this.frame = frame;
        this.exclusive = (frame.content[0] & 0x80) != 0;
        this.streamDependency = (frame.content[0] & 0x7F) << 24 | (frame.content[1] & 0xFF) << 16 | (frame.content[2] & 0xFF) << 8 | frame.content[3] & 0xFF;
        this.weight = (frame.content[4] & 0xFF) + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Priority {\n");
        if (this.exclusive) {
            sb.append("  exclusive,\n");
        }
        sb.append("  weight = ");
        sb.append(this.weight);
        sb.append(",\n  streamDependency = ");
        sb.append(this.streamDependency);
        sb.append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void validateSize() throws IOException {
        if (this.frame.length != 5) {
            throw new FatalConnectionException(6);
        }
    }
}

