/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.Frame;
import com.predic8.membrane.core.transport.http2.frame.HeaderBlockFragment;

public class PushPromiseFrame
implements HeaderBlockFragment {
    public static final int FLAG_END_HEADERS = 4;
    public static final int FLAG_PADDED = 8;
    private final Frame frame;
    private final int padLength;
    private final int promisedStreamId;
    private final int headerBlockStartIndex;

    public PushPromiseFrame(Frame frame) {
        this.frame = frame;
        int p = 0;
        this.padLength = this.isPadded() ? frame.content[p++] : 0;
        this.promisedStreamId = (frame.content[p++] & 0x7F) << 24 | (frame.content[p++] & 0xFF) << 16 | (frame.content[p++] & 0xFF) << 8 | frame.content[p++] & 0xFF;
        this.headerBlockStartIndex = p;
    }

    @Override
    public boolean isEndHeaders() {
        return (this.frame.flags & 4) != 0;
    }

    public boolean isPadded() {
        return (this.frame.flags & 8) != 0;
    }

    @Override
    public int getHeaderBlockStartIndex() {
        return this.headerBlockStartIndex;
    }

    @Override
    public int getHeaderBlockLength() {
        return this.frame.length - this.padLength - this.headerBlockStartIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PushPromise {\n");
        sb.append("  streamId = ");
        sb.append(this.frame.streamId);
        sb.append("\n  flags = ");
        if (this.isEndHeaders()) {
            sb.append("END_HEADERS ");
        }
        sb.append("\n");
        sb.append("  promisedStreamId = ");
        sb.append(this.promisedStreamId);
        sb.append("\n");
        sb.append("  header block data: \n");
        this.frame.appendHex(sb, this.frame.content, this.getHeaderBlockStartIndex(), this.getHeaderBlockLength(), 2);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public byte[] getContent() {
        return this.frame.getContent();
    }

    public Frame getFrame() {
        return this.frame;
    }
}

