/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http2.frame;

import com.predic8.membrane.core.transport.http2.frame.Frame;

public class WindowUpdateFrame {
    private final Frame frame;

    public WindowUpdateFrame(Frame frame) {
        this.frame = frame;
    }

    public int getWindowSizeIncrement() {
        return (this.frame.content[0] & 0x7F) << 24 | (this.frame.content[1] & 0xFF) << 16 | (this.frame.content[2] & 0xFF) << 8 | this.frame.content[3] & 0xFF;
    }

    public String toString() {
        String sb = "WindowUpdate {\n  streamId = " + this.frame.streamId + "\n  windowUpdate = " + this.getWindowSizeIncrement() + "\n}";
        return sb;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public static Frame inc(int streamId, int value) {
        Frame frame = new Frame();
        byte[] buf = new byte[]{(byte)(value >> 24 & 0x7F), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        frame.fill(8, 0, streamId, buf, 0, 4);
        return frame;
    }
}

