/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientFactory;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.ssl.PEMSupport;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.acme.AcmeClient;
import com.predic8.membrane.core.transport.ssl.acme.AcmeKeyCert;
import com.predic8.membrane.core.transport.ssl.acme.AcmeRenewal;
import com.predic8.membrane.core.util.TimerManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcmeSSLContext
extends SSLContext {
    private static final Logger log = LoggerFactory.getLogger(AcmeSSLContext.class);
    public static final int TLS_CERTIFICATE_UNKNOWN = 46;
    private final SSLParser parser;
    private final AcmeClient client;
    private final String[] hosts;
    private final boolean selfCreatedTimerManager;
    private final TimerManager timerManager;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private volatile AcmeKeyCert keyCert;

    public AcmeSSLContext(SSLParser parser, String[] hosts, @Nullable HttpClientFactory httpClientFactory, @Nullable TimerManager timerManager) {
        this.parser = parser;
        this.hosts = AcmeSSLContext.computeHostList(hosts, parser.getAcme().getHosts());
        this.client = new AcmeClient(parser.getAcme(), httpClientFactory);
        this.selfCreatedTimerManager = timerManager == null;
        this.timerManager = timerManager != null ? timerManager : new TimerManager();
    }

    public void init(@Nullable KubernetesClientFactory kubernetesClientFactory, @Nullable HttpClientFactory httpClientFactory) {
        this.client.init(kubernetesClientFactory, httpClientFactory);
        this.initAndSchedule();
    }

    public static String[] computeHostList(String[] hostsWantedByRule, String hostsRequestedForCertificate) {
        if (hostsRequestedForCertificate == null) {
            return hostsWantedByRule;
        }
        String[] cs = hostsRequestedForCertificate.split(" +");
        for (String h : hostsWantedByRule) {
            boolean fulfilled = false;
            for (String c : cs) {
                if (!AcmeSSLContext.hostMatches(h, c)) continue;
                fulfilled = true;
            }
            if (fulfilled) continue;
            throw new RuntimeException("Hostname " + h + " seems not to be fulfillable by a certificate issued for " + hostsRequestedForCertificate);
        }
        return cs;
    }

    private static boolean hostMatches(String host, String certificateHost) {
        if (host.equals(certificateHost)) {
            return true;
        }
        return certificateHost.startsWith("*.") && host.endsWith(certificateHost.substring(2)) && host.length() >= certificateHost.length() && host.codePointAt(host.length() - certificateHost.length() + 1) == 46 && AcmeSSLContext.isHostname(host.substring(0, host.length() - certificateHost.length() + 1));
    }

    private static boolean isHostname(String expr) {
        for (int i = 0; i < expr.length(); ++i) {
            if (Character.isDigit(expr.codePointAt(i)) || Character.isLetter(expr.codePointAt(i)) || expr.codePointAt(i) == 45 || expr.codePointAt(i) == 42) continue;
            return false;
        }
        return true;
    }

    @Override
    String getLocation() {
        return "ACME certificate from " + this.constructHostsString();
    }

    @Override
    List<String> getDnsNames() {
        return Arrays.asList(this.hosts);
    }

    @Override
    SSLSocketFactory getSocketFactory() {
        AcmeKeyCert context = this.keyCert;
        if (context == null) {
            throw new RuntimeException("ACME has not yet acquired a certificate.");
        }
        return context.getSslContext().getSocketFactory();
    }

    public AcmeClient getClient() {
        return this.client;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(port, backlog, bindAddress);
    }

    @Override
    public Socket createSocket() throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, int connectTimeout, @Nullable String sniServerName, @Nullable String[] applicationProtocols) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket createSocket(String host, int port, int connectTimeout, @Nullable String sniServerName, @Nullable String[] applicationProtocols) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress addr, int localPort, int connectTimeout, @Nullable String sniServerName, @Nullable String[] applicationProtocols) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket wrapAcceptedSocket(Socket socket) throws IOException {
        byte[] buffer = new byte[]{};
        int position = 0;
        return this.wrap(socket, buffer, position);
    }

    @Override
    public Socket wrap(Socket socket, byte[] buffer, int position) throws IOException {
        this.check(socket);
        return super.wrap(socket, buffer, position);
    }

    private void check(Socket socket) throws IOException {
        if (this.getSocketFactory() == null) {
            byte[] certificate_unknown = new byte[]{21, 3, 1, 0, 2, 2, 46};
            try (Socket socket2 = socket;){
                socket.getOutputStream().write(certificate_unknown);
            }
            throw new RuntimeException("no ACME certificate available for " + this.constructHostsString());
        }
    }

    private String constructHostsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.hosts.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.hosts[i]);
        }
        return sb.toString();
    }

    private void initAndSchedule() {
        try {
            this.tryLoad();
        }
        catch (Exception e) {
            log.info("ACME: do not yet have a certificate for " + this.constructHostsString(), (Throwable)e);
        }
        this.schedule();
    }

    private void tryLoad() {
        javax.net.ssl.SSLContext sslc;
        long validUntil;
        long validFrom;
        String keyS = this.client.getKey(this.hosts);
        String certsS = this.client.getCertificates(this.hosts);
        if (keyS == null) {
            log.debug("ACME: do not yet have a key for " + this.constructHostsString());
            return;
        }
        if (certsS == null) {
            log.debug("ACME: do not yet have a certificate for " + this.constructHostsString());
            return;
        }
        AcmeKeyCert existing = this.keyCert;
        if (existing != null && keyS.equals(existing.getKey()) && certsS.equals(existing.getCerts())) {
            return;
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, "".toCharArray());
            List<Certificate> certs = AcmeSSLContext.getCertificates(certsS);
            this.checkChainValidity(certs);
            validFrom = AcmeSSLContext.getValidFrom(certs);
            validUntil = AcmeSSLContext.getMinimumValidity(certs);
            Key k = AcmeSSLContext.getKey(keyS);
            this.checkKeyMatchesCert(k, certs);
            ks.setKeyEntry("inlinePemKeyAndCertificate", k, "".toCharArray(), certs.toArray(new Certificate[0]));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, "".toCharArray());
            sslc = javax.net.ssl.SSLContext.getInstance("TLS");
            sslc.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(this.parser, sslc);
        this.keyCert = new AcmeKeyCert(keyS, certsS, validFrom, validUntil, sslc);
        log.info("ACME: installed key and certificate for " + this.constructHostsString());
    }

    private static Key getKey(String keyS) throws IOException {
        Object key = PEMSupport.getInstance().parseKey(keyS);
        return key instanceof Key ? (Key)key : ((KeyPair)key).getPrivate();
    }

    @NotNull
    private static List<Certificate> getCertificates(String certsS) throws IOException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>(PEMSupport.getInstance().parseCertificates(certsS));
        if (certs.isEmpty()) {
            throw new RuntimeException("At least one certificate is required.");
        }
        return certs;
    }

    public void schedule() {
        long nextRun = this.parser.getAcme().getRetry();
        AcmeKeyCert keyCert = this.keyCert;
        if (keyCert != null) {
            nextRun = Math.max(AcmeSSLContext.renewAt(keyCert.getValidFrom(), keyCert.getValidUntil()) - System.currentTimeMillis(), (long)this.parser.getAcme().getRetry());
        }
        if (this.shutdown.get()) {
            return;
        }
        this.timerManager.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!"never".equals(AcmeSSLContext.this.parser.getAcme().getRenewal())) {
                    new AcmeRenewal(AcmeSSLContext.this.client, AcmeSSLContext.this.hosts).doWork();
                }
                AcmeSSLContext.this.initAndSchedule();
            }
        }, nextRun, "ACME timer " + this.constructHostsString());
    }

    public static long renewAt(long validFrom, long validUntil) {
        return validUntil - (validUntil - validFrom) / 3L;
    }

    @Override
    public void stop() {
        this.shutdown.set(true);
        if (this.selfCreatedTimerManager) {
            this.timerManager.shutdown();
        }
    }

    public boolean isReady() {
        return this.keyCert != null;
    }

    @Override
    public boolean hasKeyAndCertificate() {
        return this.keyCert != null;
    }

    @Override
    public long getValidFrom() {
        return this.keyCert.getValidFrom();
    }

    @Override
    public long getValidUntil() {
        return this.keyCert.getValidUntil();
    }

    @Override
    public String getPrometheusContextTypeName() {
        return "acme";
    }
}

