/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.oracle.util.ssl.SSLCapabilities;
import com.oracle.util.ssl.SSLExplorer;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.ssl.PEMSupport;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratingSSLContext
extends SSLContext {
    private static final Logger log = LoggerFactory.getLogger((String)GeneratingSSLContext.class.getName());
    private final PrivateKey caPrivate;
    private final SSLParser sslParser;
    private final X509Certificate caPublic;
    LoadingCache<String, SSLContext> cache;
    private long validFrom;
    private long validUntil;

    public GeneratingSSLContext(SSLParser sslParser, ResolverMap resourceResolver, String baseLocation) {
        this.sslParser = sslParser;
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, "".toCharArray());
            ArrayList<java.security.cert.Certificate> certs = new ArrayList<java.security.cert.Certificate>();
            for (com.predic8.membrane.core.config.security.Certificate cert : sslParser.getKeyGenerator().getKey().getCertificates()) {
                certs.add(PEMSupport.getInstance().parseCertificate(cert.get(resourceResolver, baseLocation)));
            }
            if (certs.size() == 0) {
                throw new RuntimeException("At least one //ssl/keyGenerator/certificate is required.");
            }
            this.checkChainValidity(certs);
            Object key = PEMSupport.getInstance().parseKey(sslParser.getKeyGenerator().getKey().getPrivate().get(resourceResolver, baseLocation));
            Key k = key instanceof Key ? (Key)key : ((KeyPair)key).getPrivate();
            this.checkKeyMatchesCert(k, certs);
            if (!(k instanceof RSAPrivateCrtKey) || !(((java.security.cert.Certificate)certs.get(0)).getPublicKey() instanceof RSAPublicKey)) {
                throw new RuntimeException("Key is a " + k.getClass().getName() + ", which is not yet supported.");
            }
            this.caPrivate = (RSAPrivateCrtKey)k;
            this.caPublic = (X509Certificate)certs.get(0);
            ks.setKeyEntry("inlinePemKeyAndCertificate", k, "".toCharArray(), certs.toArray(new java.security.cert.Certificate[certs.size()]));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyPassword = "";
            if (sslParser.getKeyGenerator().getKey().getPassword() != null) {
                keyPassword = sslParser.getKeyGenerator().getKey().getPassword();
            }
            kmf.init(ks, keyPassword.toCharArray());
            this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, SSLContext>(){

                public SSLContext load(String s) throws Exception {
                    log.info("Generating certificate for " + s);
                    return GeneratingSSLContext.this.getSSLContextForHostname(s);
                }
            });
            this.validUntil = GeneratingSSLContext.getMinimumValidity(certs);
            this.validFrom = GeneratingSSLContext.getValidFrom(certs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(port, backlog, bindAddress);
    }

    @Override
    public Socket wrapAcceptedSocket(Socket socket) throws IOException {
        Iterator<SNIServerName> iterator;
        List<SNIServerName> serverNames;
        int position;
        int n;
        InputStream ins = socket.getInputStream();
        byte[] buffer = new byte[255];
        SSLCapabilities capabilities = null;
        socket.setSoTimeout(30000);
        for (position = 0; position < 5; position += n) {
            int count = 5 - position;
            n = ins.read(buffer, position, count);
            if (n >= 0) continue;
            throw new IOException("unexpected end of stream!");
        }
        int recordLength = SSLExplorer.getRequiredSize(buffer, 0, position);
        if (buffer.length < recordLength) {
            buffer = Arrays.copyOf(buffer, recordLength);
        }
        while (position < recordLength) {
            int count = recordLength - position;
            int n2 = ins.read(buffer, position, count);
            if (n2 < 0) {
                throw new IOException("unexpected end of stream!");
            }
            position += n2;
        }
        capabilities = SSLExplorer.explore(buffer, 0, recordLength);
        if (capabilities != null && (serverNames = capabilities.getServerNames()) != null && serverNames.size() > 0 && (iterator = serverNames.iterator()).hasNext()) {
            SNIServerName snisn = iterator.next();
            String hostname = new String(snisn.getEncoded(), "UTF-8");
            try {
                return ((SSLContext)this.cache.get((Object)hostname)).wrap(socket, buffer, position);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        byte[] alert_unrecognized_name = new byte[]{21, 3, 1, 0, 2, 2, 112};
        try (Socket socket2 = socket;){
            socket.getOutputStream().write(alert_unrecognized_name);
        }
        throw new RuntimeException("non-SNI connection not supported.");
    }

    public SSLContext getSSLContextForHostname(String hostname) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair kp = kpg.generateKeyPair();
            X500Name xn = new X500Name("CN=" + hostname);
            java.security.cert.Certificate[] chain = new X509Certificate[]{GeneratingSSLContext.sign(xn.toString(), this.caPublic, this.caPrivate, kp.getPublic())};
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, null);
            ks.setKeyEntry("alias", kp.getPrivate(), new char[0], chain);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, new char[0]);
            javax.net.ssl.SSLContext sslc = javax.net.ssl.SSLContext.getInstance("TLS");
            sslc.init(kmf.getKeyManagers(), null, null);
            return new StaticSSLContext(this.sslParser, sslc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate sign(String subjectName, X509Certificate caPublic, PrivateKey caPrivate, PublicKey keyPublic) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, IOException, OperatorCreationException, CertificateException {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        AsymmetricKeyParameter foo = PrivateKeyFactory.createKey((byte[])caPrivate.getEncoded());
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPublic.getEncoded());
        X500Name caName = new JcaX509CertificateHolder(caPublic).getSubject();
        X509v3CertificateBuilder myCertificateGenerator = new X509v3CertificateBuilder(caName, new BigInteger("1"), new Date(System.currentTimeMillis() - 2078457856L), new Date(System.currentTimeMillis() + 1187194880L), new X500Name(subjectName), keyInfo);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(foo);
        X509CertificateHolder holder = myCertificateGenerator.build(sigGen);
        Certificate eeX509CertificateStructure = holder.toASN1Structure();
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream is1 = new ByteArrayInputStream(eeX509CertificateStructure.getEncoded());
        X509Certificate theCert = (X509Certificate)cf.generateCertificate(is1);
        ((InputStream)is1).close();
        return theCert;
    }

    @Override
    public Socket createSocket() throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, int connectTimeout, @Nullable String sniServerName, @Nullable String[] applicationProtocols) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket createSocket(String host, int port, int connectTimeout, @Nullable String sniServerName, @Nullable String[] applicationProtocols) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress addr, int localPort, int connectTimeout, @Nullable String sniServerName, @Nullable String[] applicationProtocols) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    String getLocation() {
        return null;
    }

    @Override
    List<String> getDnsNames() {
        return Lists.newArrayList((Object[])new String[]{"*"});
    }

    @Override
    public Socket wrap(Socket socket, byte[] buffer, int position) throws IOException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    SSLSocketFactory getSocketFactory() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public String getPrometheusContextTypeName() {
        return "generating";
    }

    @Override
    public boolean hasKeyAndCertificate() {
        return this.validUntil != 0L && this.validFrom != 0L;
    }

    @Override
    public long getValidFrom() {
        return this.validFrom;
    }

    @Override
    public long getValidUntil() {
        return this.validUntil;
    }
}

