/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.predic8.membrane.core.util.TextUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jose4j.base64url.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PEMSupport {
    private static final Logger log = LoggerFactory.getLogger((String)PEMSupport.class.getName());
    private static PEMSupport instance;

    public abstract X509Certificate parseCertificate(String var1) throws IOException;

    public abstract List<? extends Certificate> parseCertificates(String var1) throws IOException;

    public abstract Key getPrivateKey(String var1) throws IOException;

    public abstract Object parseKey(String var1) throws IOException;

    public static synchronized PEMSupport getInstance() {
        if (instance == null) {
            try {
                instance = new PEMSupportImpl();
            }
            catch (NoClassDefFoundError e) {
                throw new RuntimeException("Bouncycastle support classes not found. Please download http://central.maven.org/maven2/org/bouncycastle/bcpkix-jdk18on/1.71/bcpkix-jdk18on-1.71.jar and http://central.maven.org/maven2/org/bouncycastle/bcprov-jdk18on/1.71/bcprov-jdk18on-1.71.jar and put them into the 'lib' directory.");
            }
        }
        return instance;
    }

    private static class PEMSupportImpl
    extends PEMSupport {
        public PEMSupportImpl() {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }

        @Override
        public X509Certificate parseCertificate(String pemBlock) throws IOException {
            PEMParser p2 = new PEMParser((Reader)new StringReader(TextUtil.unifyIndent(pemBlock)));
            Object o2 = p2.readObject();
            if (o2 == null) {
                throw new InvalidParameterException("Could not read certificate. Expected the certificate to begin with '-----BEGIN CERTIFICATE-----'.");
            }
            if (!(o2 instanceof X509CertificateHolder)) {
                throw new InvalidParameterException("Expected X509CertificateHolder, got " + o2.getClass().getName());
            }
            JcaX509CertificateConverter certconv = new JcaX509CertificateConverter().setProvider("BC");
            try {
                return certconv.getCertificate((X509CertificateHolder)o2);
            }
            catch (CertificateException e) {
                throw new IOException(e);
            }
        }

        public List<X509Certificate> parseCertificates(String pemBlock) throws IOException {
            Object o2;
            ArrayList<X509Certificate> res = new ArrayList<X509Certificate>();
            PEMParser p2 = new PEMParser((Reader)new StringReader(TextUtil.unifyIndent(pemBlock)));
            JcaX509CertificateConverter certconv = new JcaX509CertificateConverter().setProvider("BC");
            while ((o2 = p2.readObject()) != null) {
                if (!(o2 instanceof X509CertificateHolder)) {
                    throw new InvalidParameterException("Expected X509CertificateHolder, got " + o2.getClass().getName());
                }
                try {
                    res.add(certconv.getCertificate((X509CertificateHolder)o2));
                }
                catch (CertificateException e) {
                    throw new IOException(e);
                }
            }
            if (res.isEmpty()) {
                throw new InvalidParameterException("Could not read certificate. Expected the certificate to begin with '-----BEGIN CERTIFICATE-----'.");
            }
            return res;
        }

        @Override
        public Key getPrivateKey(String pemBlock) throws IOException {
            PEMParser p = new PEMParser((Reader)new StringReader(TextUtil.unifyIndent(pemBlock)));
            Object o = p.readObject();
            if (o == null) {
                throw new InvalidParameterException("Could not read certificate. Expected the certificate to begin with '-----BEGIN CERTIFICATE-----'.");
            }
            if (o instanceof PEMKeyPair) {
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                return converter.getPrivateKey(((PEMKeyPair)o).getPrivateKeyInfo());
            }
            if (o instanceof Key) {
                return (Key)o;
            }
            if (o instanceof KeyPair) {
                return ((KeyPair)o).getPrivate();
            }
            throw new InvalidParameterException("Expected KeyPair or Key.");
        }

        @Override
        public Object parseKey(String pemBlock) throws IOException {
            PEMParser p = new PEMParser((Reader)new StringReader(TextUtil.unifyIndent(pemBlock)));
            Object o = p.readObject();
            if (o == null) {
                log.error("Could not read PEM file. Check the contents of PEM file or configuration. Content is {}", (Object)pemBlock);
                throw new InvalidParameterException("Could not read PEM file. Check the contents of PEM file or configuration.");
            }
            if (o instanceof X9ECParameters) {
                o = p.readObject();
            }
            if (o instanceof PEMKeyPair) {
                PEMKeyPair keyPair = (PEMKeyPair)o;
                if (keyPair.getPublicKeyInfo() == null) {
                    try {
                        Pattern p1 = Pattern.compile("^.*-----BEGIN EC PRIVATE KEY-----\r?\n", 32);
                        Pattern p2 = Pattern.compile("-----END EC PRIVATE KEY-----\r?\n?.*", 32);
                        String s = p2.matcher(p1.matcher(pemBlock).replaceAll("")).replaceAll("");
                        return KeyFactory.getInstance("EC", "SunEC").generatePrivate(new PKCS8EncodedKeySpec(Base64.decode((String)s)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                return converter.getKeyPair((PEMKeyPair)o);
            }
            if (o instanceof Key) {
                return o;
            }
            if (o instanceof KeyPair) {
                return o;
            }
            if (o instanceof PrivateKeyInfo) {
                return new JcaPEMKeyConverter().setProvider("BC").getPrivateKey((PrivateKeyInfo)o);
            }
            throw new InvalidParameterException("Expected KeyPair or Key, got " + o.getClass().getName());
        }
    }
}

