/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.transport.http2.Http2TlsSupport;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECFieldFp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLContext
implements SSLProvider {
    private static final Logger log = LoggerFactory.getLogger((String)SSLContext.class.getName());
    protected String[] ciphers;
    protected String[] protocols;
    protected boolean wantClientAuth;
    protected boolean needClientAuth;
    protected String endpointIdentificationAlgorithm;
    private boolean showSSLExceptions = true;
    private boolean useAsDefault;
    private boolean useHttp2;

    public void init(SSLParser sslParser, javax.net.ssl.SSLContext sslc) {
        this.showSSLExceptions = sslParser.isShowSSLExceptions();
        this.useAsDefault = sslParser.isUseAsDefault();
        if (sslParser.getCiphers() != null) {
            this.ciphers = sslParser.getCiphers().split(",");
            HashSet supportedCiphers = Sets.newHashSet((Object[])sslc.getSocketFactory().getSupportedCipherSuites());
            for (String cipher : this.ciphers) {
                if (!supportedCiphers.contains(cipher)) {
                    throw new InvalidParameterException("Unknown cipher " + cipher);
                }
                if (cipher.contains("_RC4_")) {
                    log.warn("Cipher " + cipher + " uses RC4, which is deprecated.");
                }
                if (!cipher.contains("_3DES_")) continue;
                log.warn("Cipher " + cipher + " uses 3DES, which is deprecated.");
            }
        } else {
            String[] supportedCiphers = sslc.getSocketFactory().getDefaultCipherSuites();
            ArrayList<String> ciphers = new ArrayList<String>(supportedCiphers.length);
            for (String cipher : supportedCiphers) {
                if (cipher.contains("_RC4_") || cipher.contains("_3DES_")) continue;
                ciphers.add(cipher);
            }
            this.sortCiphers(ciphers);
            this.ciphers = ciphers.toArray(new String[ciphers.size()]);
        }
        this.protocols = sslParser.getProtocols() != null ? sslParser.getProtocols().split(",") : null;
        if (sslParser.getClientAuth() == null) {
            this.needClientAuth = false;
            this.wantClientAuth = false;
        } else if (sslParser.getClientAuth().equals("need")) {
            this.needClientAuth = true;
            this.wantClientAuth = true;
        } else if (sslParser.getClientAuth().equals("want")) {
            this.needClientAuth = false;
            this.wantClientAuth = true;
        } else {
            throw new RuntimeException("Invalid value '" + sslParser.getClientAuth() + "' in clientAuth: expected 'want', 'need' or not set.");
        }
        this.endpointIdentificationAlgorithm = sslParser.getEndpointIdentificationAlgorithm();
        this.useHttp2 = sslParser.isUseExperimentalHttp2();
    }

    abstract String getLocation();

    abstract List<String> getDnsNames();

    public Socket wrap(Socket socket, byte[] buffer, int position) throws IOException {
        SSLSocketFactory serviceSocketFac = this.getSocketFactory();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer, 0, position);
        SSLSocket serviceSocket = (SSLSocket)serviceSocketFac.createSocket(socket, bais, true);
        this.applyCiphers(serviceSocket);
        if (this.getProtocols() != null) {
            serviceSocket.setEnabledProtocols(this.getProtocols());
        } else {
            String[] protocols = serviceSocket.getEnabledProtocols();
            HashSet<String> set = new HashSet<String>();
            for (String protocol : protocols) {
                if (protocol.equals("SSLv3") || protocol.equals("SSLv2Hello")) continue;
                set.add(protocol);
            }
            serviceSocket.setEnabledProtocols(set.toArray(new String[0]));
        }
        serviceSocket.setWantClientAuth(this.isWantClientAuth());
        serviceSocket.setNeedClientAuth(this.isNeedClientAuth());
        if (this.useHttp2) {
            Http2TlsSupport.offerHttp2(serviceSocket);
        }
        return serviceSocket;
    }

    public void applyCiphers(SSLSocket sslSocket) {
        if (this.ciphers != null) {
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            this.applyCipherOrdering(sslParameters);
            sslParameters.setCipherSuites(this.ciphers);
            sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
            sslSocket.setSSLParameters(sslParameters);
        }
    }

    protected void applyCipherOrdering(SSLParameters sslParameters) {
        sslParameters.setUseCipherSuitesOrder(true);
    }

    String[] getCiphers() {
        return this.ciphers;
    }

    String[] getProtocols() {
        return this.protocols;
    }

    boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    private void sortCiphers(ArrayList<String> ciphers) {
        ArrayList<CipherInfo> cipherInfos = new ArrayList<CipherInfo>(ciphers.size());
        for (String cipher : ciphers) {
            cipherInfos.add(new CipherInfo(cipher));
        }
        cipherInfos.sort((cipher1, cipher2) -> cipher2.points - cipher1.points);
        for (int i = 0; i < ciphers.size(); ++i) {
            ciphers.set(i, ((CipherInfo)cipherInfos.get((int)i)).cipher);
        }
    }

    public String constructHostNamePattern() {
        StringBuilder sb = null;
        List<String> dnsNames = this.getDnsNames();
        if (dnsNames == null) {
            throw new RuntimeException("Could not extract DNS names from the first key's certificate in " + this.getLocation());
        }
        for (String dnsName : dnsNames) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(" ");
            }
            sb.append(dnsName);
        }
        if (sb == null) {
            log.warn("Could not retrieve DNS hostname for certificate, using '*': " + this.getLocation());
            return "*";
        }
        return sb.toString();
    }

    abstract SSLSocketFactory getSocketFactory();

    protected void checkChainValidity(List<Certificate> certs) {
        boolean valid = true;
        for (int i = 0; i < certs.size() - 1; ++i) {
            String currentIssuer = ((X509Certificate)certs.get(i)).getIssuerX500Principal().toString();
            String nextSubject = ((X509Certificate)certs.get(i + 1)).getSubjectX500Principal().toString();
            valid = valid && Objects.equal((Object)currentIssuer, (Object)nextSubject);
        }
        if (!valid) {
            StringBuilder sb = new StringBuilder();
            sb.append("Certificate chain is not valid:\n");
            for (int i = 0; i < certs.size(); ++i) {
                sb.append("Cert " + String.format("%2d", i) + ": Subject: " + ((X509Certificate)certs.get(i)).getSubjectX500Principal().toString() + "\n");
                sb.append("         Issuer: " + ((X509Certificate)certs.get(i)).getIssuerX500Principal().toString() + "\n");
            }
            log.warn(sb.toString());
        }
    }

    @Override
    public boolean showSSLExceptions() {
        return this.showSSLExceptions;
    }

    public boolean isUseAsDefault() {
        return this.useAsDefault;
    }

    @Override
    public String[] getApplicationProtocols(Socket socket) {
        if (!(socket instanceof SSLSocket)) {
            return null;
        }
        return ((SSLSocket)socket).getSSLParameters().getApplicationProtocols();
    }

    protected void checkKeyMatchesCert(Key key, List<Certificate> certs) {
        PublicKey pubkey;
        PrivateKey privkey;
        if (key instanceof RSAPrivateCrtKey && certs.get(0).getPublicKey() instanceof RSAPublicKey) {
            privkey = (RSAPrivateCrtKey)key;
            pubkey = (RSAPublicKey)certs.get(0).getPublicKey();
            if (!privkey.getModulus().equals(pubkey.getModulus()) || !privkey.getPublicExponent().equals(pubkey.getPublicExponent())) {
                throw new RuntimeException("Certificate does not fit to key: " + this.getLocation());
            }
        }
        if (key instanceof ECPrivateKey && certs.get(0).getPublicKey() instanceof ECPublicKey) {
            privkey = (ECPrivateKey)key;
            pubkey = (ECPublicKey)certs.get(0).getPublicKey();
            if (pubkey.getParams().getCurve().getField() instanceof ECFieldFp) {
                ECFieldFp pubfield = (ECFieldFp)pubkey.getParams().getCurve().getField();
                if (!(privkey.getParams().getCurve().getField() instanceof ECFieldFp)) {
                    throw new RuntimeException("Elliptic curve differs between private key and public key (ECFieldFp vs ECFieldF2m).");
                }
                ECFieldFp privfield = (ECFieldFp)privkey.getParams().getCurve().getField();
                if (!pubfield.getP().equals(privfield.getP())) {
                    throw new RuntimeException("Elliptic curve differs between private key and public key (p).");
                }
            }
            if (!pubkey.getParams().getCurve().getA().equals(privkey.getParams().getCurve().getA())) {
                throw new RuntimeException("Elliptic curve differs between private key and public key (a).");
            }
            if (!pubkey.getParams().getCurve().getB().equals(privkey.getParams().getCurve().getB())) {
                throw new RuntimeException("Elliptic curve differs between private key and public key (b).");
            }
            if (!pubkey.getParams().getGenerator().equals(privkey.getParams().getGenerator())) {
                throw new RuntimeException("Elliptic curve differs between private key and public key (generator).");
            }
            if (!pubkey.getParams().getOrder().equals(privkey.getParams().getOrder())) {
                throw new RuntimeException("Elliptic curve differs between private key and public key (order).");
            }
            if (pubkey.getParams().getCofactor() != privkey.getParams().getCofactor()) {
                throw new RuntimeException("Elliptic curve differs between private key and public key (cofactor).");
            }
            FixedPointCombMultiplier ecMultiplier = new FixedPointCombMultiplier();
            ECPoint correspondingPubKey = ecMultiplier.multiply(((BCECPublicKey)pubkey).getParameters().getG(), privkey.getS()).normalize();
            if (!correspondingPubKey.getAffineXCoord().toBigInteger().equals(pubkey.getW().getAffineX()) || !correspondingPubKey.getAffineYCoord().toBigInteger().equals(pubkey.getW().getAffineY())) {
                throw new RuntimeException("Elliptic curve private key does not match public key.");
            }
        }
    }

    public static long getValidFrom(List<Certificate> certs) {
        return certs.stream().map(cert -> ((X509Certificate)cert).getNotBefore().getTime()).max(Long::compare).get();
    }

    public static long getMinimumValidity(List<Certificate> certs) {
        return certs.stream().map(cert -> ((X509Certificate)cert).getNotAfter().getTime()).min(Long::compare).get();
    }

    @Override
    public void stop() {
    }

    public abstract boolean hasKeyAndCertificate();

    public abstract long getValidFrom();

    public abstract long getValidUntil();

    public abstract String getPrometheusContextTypeName();

    private static class CipherInfo {
        public final String cipher;
        public final int points;

        public CipherInfo(String cipher) {
            this.cipher = cipher;
            int points = 0;
            if (this.supportsPFS(cipher)) {
                points = 100;
            }
            points += this.getAESStrength(cipher) * 5;
            points += this.getSHAStrength(cipher) * 2;
            points += this.getChaChaPoly1305Strength(cipher) * 25;
            if (this.supportsAESGCM(cipher)) {
                points += 15;
            }
            if (!this.supportsAESCBC(cipher)) {
                points += 150;
            }
            this.points = points;
        }

        private boolean supportsAESGCM(String cipher) {
            return cipher.contains("_GCM_");
        }

        private boolean supportsAESCBC(String cipher) {
            return cipher.contains("_CBC_");
        }

        private int getChaChaPoly1305Strength(String cipher) {
            if (cipher.contains("_CHACHA20_POLY1305_")) {
                return 1;
            }
            return 0;
        }

        private int getAESStrength(String cipher) {
            if (cipher.contains("_AES_512_")) {
                return 2;
            }
            if (cipher.contains("_AES_256_")) {
                return 1;
            }
            if (cipher.contains("_AES_128_")) {
                return 0;
            }
            return 0;
        }

        private int getSHAStrength(String cipher) {
            if (cipher.endsWith("_SHA384")) {
                return 2;
            }
            if (cipher.endsWith("_SHA256")) {
                return 1;
            }
            return 0;
        }

        private boolean supportsPFS(String cipher2) {
            return this.cipher.contains("_DHE_RSA_") || this.cipher.contains("_DHE_DSS_") || this.cipher.contains("_ECDHE_RSA_") || this.cipher.contains("_ECDHE_ECDSA_");
        }
    }
}

