/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.oracle.util.ssl.SSLCapabilities;
import com.oracle.util.ssl.SSLExplorer;
import com.predic8.membrane.core.proxies.ServiceProxyKey;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.transport.ssl.TLSUnrecognizedNameException;
import com.predic8.membrane.core.util.EndOfStreamException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.SNIServerName;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextCollection
implements SSLProvider {
    public static final byte[] ALERT_UNRECOGNIZED_NAME = new byte[]{21, 3, 1, 0, 2, 2, 112};
    private static final Logger log = LoggerFactory.getLogger((String)SSLContextCollection.class.getName());
    private final List<SSLContext> sslContexts;
    private final List<Pattern> dnsNames = new ArrayList<Pattern>();

    private SSLContextCollection(List<SSLContext> sslContexts, List<String> dnsNames) {
        for (String dnsName : dnsNames) {
            this.dnsNames.add(Pattern.compile(ServiceProxyKey.createHostPattern(dnsName), 2));
        }
        this.sslContexts = sslContexts;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(port, backlog, bindAddress);
    }

    @Override
    public Socket wrapAcceptedSocket(Socket socket) throws IOException, EndOfStreamException {
        List<SNIServerName> serverNames;
        InputStream ins = socket.getInputStream();
        byte[] buffer = new byte[255];
        int position = 0;
        socket.setSoTimeout(30000);
        position = SSLContextCollection.readTLSRecordHeader(position, 5, ins, buffer);
        int recordLength = SSLExplorer.getRequiredSize(buffer, 0, position);
        if (buffer.length < recordLength) {
            buffer = Arrays.copyOf(buffer, recordLength);
        }
        position = SSLContextCollection.readTLSRecordHeader(position, recordLength, ins, buffer);
        SSLCapabilities capabilities = SSLExplorer.explore(buffer, 0, recordLength);
        SSLContext sslContext = null;
        if (capabilities != null && (serverNames = capabilities.getServerNames()) != null && !serverNames.isEmpty()) {
            block5: for (SNIServerName snisn : serverNames) {
                String hostname = new String(snisn.getEncoded(), StandardCharsets.UTF_8);
                for (int i = 0; i < this.dnsNames.size(); ++i) {
                    if (!this.dnsNames.get(i).matcher(hostname).matches()) continue;
                    sslContext = this.sslContexts.get(i);
                    break block5;
                }
            }
            if (sslContext == null) {
                try (Socket socket2 = socket;){
                    socket.getOutputStream().write(ALERT_UNRECOGNIZED_NAME);
                }
                throw new TLSUnrecognizedNameException(SSLContextCollection.getHostname(serverNames));
            }
        }
        if (sslContext == null) {
            for (SSLContext sc : this.sslContexts) {
                if (!sc.isUseAsDefault()) continue;
                sslContext = sc;
                break;
            }
        }
        if (sslContext == null) {
            sslContext = this.sslContexts.getFirst();
        }
        return sslContext.wrap(socket, buffer, position);
    }

    private static int readTLSRecordHeader(int position, int recordHeaderSize, InputStream ins, byte[] buffer) throws IOException, EndOfStreamException {
        while (position < recordHeaderSize) {
            int count = recordHeaderSize - position;
            int n = ins.read(buffer, position, count);
            if (n < 0) {
                throw new EndOfStreamException("unexpected end of stream!");
            }
            position += n;
        }
        return position;
    }

    @Nullable
    private static String getHostname(List<SNIServerName> serverNames) {
        StringBuilder hostname = null;
        for (SNIServerName snisn : serverNames) {
            if (hostname == null) {
                hostname = new StringBuilder();
            } else {
                hostname.append(", ");
            }
            hostname.append(new String(snisn.getEncoded(), StandardCharsets.UTF_8));
        }
        return hostname.toString();
    }

    private SSLContext getSSLContextForHostname(String hostname) {
        SSLContext sslContext = null;
        for (int i = 0; i < this.dnsNames.size(); ++i) {
            if (!this.dnsNames.get(i).matcher(hostname).matches()) continue;
            sslContext = this.sslContexts.get(i);
            break;
        }
        if (sslContext == null) {
            sslContext = this.sslContexts.getFirst();
        }
        return sslContext;
    }

    @Override
    public Socket createSocket() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress addr, int localPort, int connectTimeout, @javax.annotation.Nullable String sniServerName, @javax.annotation.Nullable String[] applicationProtocols) throws IOException {
        return this.getSSLContextForHostname(host).createSocket(host, port, addr, localPort, connectTimeout, sniServerName, applicationProtocols);
    }

    @Override
    public boolean showSSLExceptions() {
        for (SSLContext ctx : this.sslContexts) {
            if (ctx.showSSLExceptions()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Socket createSocket(String host, int port, int connectTimeout, @javax.annotation.Nullable String sniServerName, @javax.annotation.Nullable String[] applicationProtocols) throws IOException {
        return this.getSSLContextForHostname(host).createSocket(host, port, connectTimeout, sniServerName, applicationProtocols);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, int connectTimeout, @javax.annotation.Nullable String sniServerName, @javax.annotation.Nullable String[] applicationProtocols) throws IOException {
        return this.getSSLContextForHostname(host).createSocket(s, host, port, connectTimeout, sniServerName, applicationProtocols);
    }

    @Override
    public String[] getApplicationProtocols(Socket socket) {
        return this.sslContexts.getFirst().getApplicationProtocols(socket);
    }

    @Override
    public void stop() {
        for (SSLContext sslContext : this.sslContexts) {
            sslContext.stop();
        }
    }

    public static class Builder {
        private final List<String> dnsNames = new ArrayList<String>();
        private final List<SSLContext> sslContexts = new ArrayList<SSLContext>();

        public SSLProvider build() {
            if (this.sslContexts.isEmpty()) {
                throw new IllegalStateException("No SSLContext's were added to this Builder before invoking build().");
            }
            if (this.sslContexts.size() > 1) {
                return new SSLContextCollection(this.sslContexts, this.dnsNames);
            }
            return this.sslContexts.getFirst();
        }

        public void add(SSLContext sslContext) {
            if (!this.sslContexts.contains(sslContext)) {
                this.sslContexts.add(sslContext);
                this.dnsNames.add(sslContext.constructHostNamePattern());
            }
        }
    }
}

