/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.config.security.Store;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.security.KeyStoreUtil;
import com.predic8.membrane.core.transport.TrustManagerWrapper;
import com.predic8.membrane.core.transport.http2.Http2TlsSupport;
import com.predic8.membrane.core.transport.ssl.PEMSupport;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.validation.constraints.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticSSLContext
extends SSLContext {
    private static final String DEFAULT_CERTIFICATE_SHA256 = "c7:e3:fd:97:2f:d3:b9:4f:38:87:9c:45:32:70:b3:d8:c1:9f:d1:64:39:fc:48:5f:f4:a1:6a:95:b5:ca:08:f7";
    private static final Logger log = LoggerFactory.getLogger((String)StaticSSLContext.class.getName());
    public static final String PKCS_12 = "PKCS12";
    private static boolean defaultCertificateWarned = false;
    private final SSLParser sslParser;
    private List<String> dnsNames;
    private javax.net.ssl.SSLContext sslc;
    private Validity validity;

    public StaticSSLContext(SSLParser sslParser, ResolverMap resourceResolver, String baseLocation) {
        if (sslParser.getTrustStore() != null && sslParser.getTrust() != null) {
            throw new InvalidParameterException("<trust> may not be used together with <truststore>.");
        }
        if (sslParser.getKeyStore() != null && sslParser.getKey() != null) {
            throw new InvalidParameterException("<key> may not be used together with <keystore>.");
        }
        this.sslParser = sslParser;
        try {
            this.initializeJavaSSLContext(this.createTrustManagerFactory(resourceResolver, baseLocation), this.createKeyManagerFactoryWithSideEffects(resourceResolver, baseLocation));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(sslParser, this.sslc);
    }

    @Nullable
    private KeyManagerFactory createKeyManagerFactoryWithSideEffects(ResolverMap resourceResolver, String baseLocation) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException {
        if (this.sslParser.getKeyStore() != null) {
            char[] keyPass = StaticSSLContext.getKeyPass(this.sslParser);
            KeyStore ks = StaticSSLContext.openKeyStore(this.sslParser.getKeyStore(), keyPass, resourceResolver, baseLocation);
            String keyAlias = StaticSSLContext.getKeyAlias(this.sslParser, ks);
            this.dnsNames = this.extractDnsNames(ks.getCertificate(keyAlias));
            this.validity = this.getValidityPeriod(ks, keyAlias);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(StaticSSLContext.getAlgorithm(this.sslParser));
            kmf.init(KeyStoreUtil.filterKeyStoreByAlias(ks, keyPass, keyAlias), keyPass);
            return kmf;
        }
        if (this.sslParser.getKey() != null) {
            return this.getKeyManagerFactoryWithSideEffects(this.sslParser, resourceResolver, baseLocation);
        }
        return null;
    }

    @Nullable
    private TrustManagerFactory createTrustManagerFactory(ResolverMap resourceResolver, String baseLocation) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.sslParser.getTrustStore() == null && this.sslParser.getTrust() == null) {
            return null;
        }
        KeyStore trustStore = null;
        String checkRevocation = null;
        if (this.sslParser.getTrustStore() != null) {
            trustStore = StaticSSLContext.openKeyStore(this.sslParser.getTrustStore(), null, resourceResolver, baseLocation);
            checkRevocation = this.sslParser.getTrustStore().getCheckRevocation();
        } else if (this.sslParser.getTrust() != null) {
            trustStore = this.getStore(resourceResolver, baseLocation);
            checkRevocation = this.sslParser.getTrust().getCheckRevocation();
        }
        return this.createTrustManagerFactory2(trustStore, checkRevocation);
    }

    @org.jetbrains.annotations.NotNull
    private KeyStore getStore(ResolverMap resourceResolver, String baseLocation) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance(PKCS_12);
        trustStore.load(null, "".toCharArray());
        for (int j = 0; j < this.sslParser.getTrust().getCertificateList().size(); ++j) {
            trustStore.setCertificateEntry("inlinePemCertificate" + j, PEMSupport.getInstance().parseCertificate(this.sslParser.getTrust().getCertificateList().get(j).get(resourceResolver, baseLocation)));
        }
        return trustStore;
    }

    private String getTrustAlgorithm() {
        if (this.sslParser.getTrust() != null && this.sslParser.getTrust().getAlgorithm() != null) {
            return this.sslParser.getTrust().getAlgorithm();
        }
        if (this.sslParser.getTrustStore() != null && this.sslParser.getTrustStore().getAlgorithm() != null) {
            return this.sslParser.getTrustStore().getAlgorithm();
        }
        return TrustManagerFactory.getDefaultAlgorithm();
    }

    @Nullable
    private TrustManagerFactory createTrustManagerFactory2(KeyStore trustStore, String checkRevocation) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyStoreException {
        TrustManagerFactory tmf = null;
        if (trustStore != null) {
            tmf = TrustManagerFactory.getInstance(this.getTrustAlgorithm());
            if (checkRevocation != null) {
                tmf.init(new CertPathTrustManagerParameters(StaticSSLContext.getPkixBuilderParameters(trustStore, this.getTrustAlgorithm(), checkRevocation)));
            } else {
                tmf.init(trustStore);
            }
        }
        return tmf;
    }

    @org.jetbrains.annotations.NotNull
    private static PKIXBuilderParameters getPkixBuilderParameters(KeyStore trustStore, String trustAlgorithm, String checkRevocation) throws KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        pkixParams.addCertPathChecker(StaticSSLContext.getRevocationChecker(trustAlgorithm, checkRevocation));
        return pkixParams;
    }

    @org.jetbrains.annotations.NotNull
    private static PKIXRevocationChecker getRevocationChecker(String trustAlgorithm, String checkRevocation) throws NoSuchAlgorithmException {
        PKIXRevocationChecker rc = (PKIXRevocationChecker)CertPathBuilder.getInstance(trustAlgorithm).getRevocationChecker();
        rc.setOptions(StaticSSLContext.createOptions(checkRevocation));
        return rc;
    }

    @org.jetbrains.annotations.NotNull
    private static EnumSet<PKIXRevocationChecker.Option> createOptions(String checkRevocation) {
        EnumSet<PKIXRevocationChecker.Option> options = EnumSet.noneOf(PKIXRevocationChecker.Option.class);
        for (String option : checkRevocation.split(",")) {
            options.add(PKIXRevocationChecker.Option.valueOf(option));
        }
        return options;
    }

    private void initializeJavaSSLContext(TrustManagerFactory tmf, KeyManagerFactory kmf) throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] tms;
        TrustManager[] trustManagerArray = tms = tmf != null ? tmf.getTrustManagers() : null;
        if (this.sslParser.isIgnoreTimestampCheckFailure()) {
            tms = new TrustManager[]{new TrustManagerWrapper(tms, true)};
        }
        this.sslc = this.sslParser.getProtocol() != null ? javax.net.ssl.SSLContext.getInstance(this.sslParser.getProtocol()) : javax.net.ssl.SSLContext.getInstance("TLS");
        this.sslc.init(kmf != null ? kmf.getKeyManagers() : null, tms, null);
    }

    private static String getKeyAlias(SSLParser sslParser, KeyStore ks) throws KeyStoreException {
        String paramAlias = sslParser.getKeyStore().getKeyAlias();
        return paramAlias != null ? KeyStoreUtil.aliasOrThrow(ks, paramAlias) : KeyStoreUtil.firstAliasOrThrow(ks);
    }

    private Validity getValidityPeriod(KeyStore ks, String keyAlias) throws KeyStoreException {
        List<Certificate> certs = Arrays.asList(ks.getCertificateChain(keyAlias));
        return new Validity(StaticSSLContext.getValidFrom(certs), StaticSSLContext.getMinimumValidity(certs));
    }

    @org.jetbrains.annotations.NotNull
    private KeyManagerFactory getKeyManagerFactoryWithSideEffects(SSLParser sslParser, ResolverMap resourceResolver, String baseLocation) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        List<Certificate> certs = StaticSSLContext.getCertificates(sslParser, resourceResolver, baseLocation);
        this.dnsNames = this.extractDnsNames(certs.get(0));
        this.checkChainValidity(certs);
        this.validity = new Validity(StaticSSLContext.getValidFrom(certs), StaticSSLContext.getMinimumValidity(certs));
        return this.getKeyManagerFactory(sslParser, this.getKey(sslParser, resourceResolver, baseLocation, certs), certs);
    }

    private Key getKey(SSLParser sslParser, ResolverMap resourceResolver, String baseLocation, List<Certificate> certs) throws IOException {
        Key k = StaticSSLContext.getKey(sslParser, resourceResolver, baseLocation);
        this.checkKeyMatchesCert(k, certs);
        return k;
    }

    @org.jetbrains.annotations.NotNull
    private KeyManagerFactory getKeyManagerFactory(SSLParser sslParser, Key k, List<Certificate> certs) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException, CertificateException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(StaticSSLContext.getKeyStore(k, certs), StaticSSLContext.getKeyPassword(sslParser));
        return kmf;
    }

    @org.jetbrains.annotations.NotNull
    private static List<Certificate> getCertificates(SSLParser sslParser, ResolverMap resourceResolver, String baseLocation) throws IOException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        for (com.predic8.membrane.core.config.security.Certificate cert : sslParser.getKey().getCertificates()) {
            certs.add(PEMSupport.getInstance().parseCertificate(cert.get(resourceResolver, baseLocation)));
        }
        if (certs.isEmpty()) {
            throw new RuntimeException("At least one //ssl/key/certificate is required.");
        }
        return certs;
    }

    @org.jetbrains.annotations.NotNull
    private static KeyStore getKeyStore(Key k, List<Certificate> certs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(PKCS_12);
        ks.load(null, "".toCharArray());
        ks.setKeyEntry("inlinePemKeyAndCertificate", k, "".toCharArray(), certs.toArray(new Certificate[0]));
        return ks;
    }

    private static Key getKey(SSLParser sslParser, ResolverMap resourceResolver, String baseLocation) throws IOException {
        Object key = PEMSupport.getInstance().parseKey(sslParser.getKey().getPrivate().get(resourceResolver, baseLocation));
        return key instanceof Key ? (Key)key : ((KeyPair)key).getPrivate();
    }

    private static char[] getKeyPassword(SSLParser sslParser) {
        if (sslParser.getKey().getPassword() != null) {
            return sslParser.getKey().getPassword().toCharArray();
        }
        return "".toCharArray();
    }

    private static char @org.jetbrains.annotations.NotNull [] getKeyPass(SSLParser sslParser) {
        char[] keyPass = "changeit".toCharArray();
        if (sslParser.getKeyStore().getKeyPassword() != null) {
            keyPass = sslParser.getKeyStore().getKeyPassword().toCharArray();
        }
        return keyPass;
    }

    private static String getAlgorithm(SSLParser sslParser) {
        if (sslParser.getAlgorithm() != null) {
            return sslParser.getAlgorithm();
        }
        return KeyManagerFactory.getDefaultAlgorithm();
    }

    public StaticSSLContext(SSLParser sslParser, javax.net.ssl.SSLContext sslc) {
        this.sslParser = sslParser;
        this.sslc = sslc;
        this.init(sslParser, sslc);
    }

    private List<String> extractDnsNames(Certificate certificate) throws CertificateParsingException {
        X509Certificate cert;
        Collection<List<?>> subjectAlternativeNames;
        ArrayList<String> names = new ArrayList<String>();
        if (certificate instanceof X509Certificate && (subjectAlternativeNames = (cert = (X509Certificate)certificate).getSubjectAlternativeNames()) != null) {
            for (List<?> l : subjectAlternativeNames) {
                if (!(l.get(0) instanceof Integer) || (Integer)l.get(0) != 2) continue;
                names.add(l.get(1).toString());
            }
        }
        return names;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StaticSSLContext)) {
            return false;
        }
        StaticSSLContext other = (StaticSSLContext)obj;
        return this.sslParser.hashCode() == other.sslParser.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.sslParser, this.dnsNames, this.sslc, this.validity);
    }

    public static KeyStore openKeyStore(Store store, char[] keyPass, ResolverMap resourceResolver, String baseLocation) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException {
        KeyStore ks = KeyStoreUtil.getAndLoadKeyStore(store, resourceResolver, baseLocation, StaticSSLContext.getStoreTypeOrDefault(store), StaticSSLContext.getPassword(store, keyPass));
        if (!defaultCertificateWarned && ks.getCertificate("membrane") != null && KeyStoreUtil.getDigest(ks, "membrane").equals(DEFAULT_CERTIFICATE_SHA256)) {
            log.warn("Using Membrane with the default certificate. This is highly discouraged! Please run the generate-ssl-keys script in the conf directory.");
            defaultCertificateWarned = true;
        }
        return ks;
    }

    private static char @org.jetbrains.annotations.NotNull [] getPassword(Store store, char[] keyPass) {
        char[] password = keyPass;
        if (store.getPassword() != null) {
            password = store.getPassword().toCharArray();
        }
        if (password == null) {
            throw new InvalidParameterException("Password for key store is not set.");
        }
        return password;
    }

    @org.jetbrains.annotations.NotNull
    private static String getStoreTypeOrDefault(Store store) {
        String type = store.getType();
        if (type == null) {
            return PKCS_12;
        }
        return type;
    }

    public void applyCiphers(SSLServerSocket sslServerSocket) {
        if (this.ciphers != null) {
            SSLParameters sslParameters = sslServerSocket.getSSLParameters();
            this.applyCipherOrdering(sslParameters);
            sslParameters.setCipherSuites(this.ciphers);
            sslServerSocket.setSSLParameters(sslParameters);
        }
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        SSLServerSocketFactory sslssf = this.sslc.getServerSocketFactory();
        SSLServerSocket sslss = (SSLServerSocket)sslssf.createServerSocket(port, backlog, bindAddress);
        this.applyCiphers(sslss);
        if (this.protocols != null) {
            sslss.setEnabledProtocols(this.protocols);
        } else {
            String[] protocols = sslss.getEnabledProtocols();
            HashSet<String> set = new HashSet<String>();
            for (String protocol : protocols) {
                if (protocol.equals("SSLv3") || protocol.equals("SSLv2Hello")) continue;
                set.add(protocol);
            }
            sslss.setEnabledProtocols(set.toArray(new String[0]));
        }
        sslss.setWantClientAuth(this.wantClientAuth);
        sslss.setNeedClientAuth(this.needClientAuth);
        if (this.sslParser.isUseExperimentalHttp2()) {
            Http2TlsSupport.offerHttp2(sslss);
        }
        return sslss;
    }

    @Override
    public Socket wrapAcceptedSocket(Socket socket) {
        return socket;
    }

    private void prepare(SSLSocket ssls) {
        if (this.protocols != null) {
            ssls.setEnabledProtocols(this.protocols);
        } else {
            String[] protocols = ssls.getEnabledProtocols();
            HashSet<String> set = new HashSet<String>();
            for (String protocol : protocols) {
                if (protocol.equals("SSLv3") || protocol.equals("SSLv2Hello")) continue;
                set.add(protocol);
            }
            ssls.setEnabledProtocols(set.toArray(new String[0]));
        }
        this.applyCiphers(ssls);
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket ssls = (SSLSocket)this.sslc.getSocketFactory().createSocket();
        this.prepare(ssls);
        return ssls;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, int connectTimeout, @javax.annotation.Nullable String sniServerName, @javax.annotation.Nullable String[] applicationProtocols) throws IOException {
        SSLSocketFactory sslsf = this.sslc.getSocketFactory();
        SSLSocket ssls = (SSLSocket)sslsf.createSocket(socket, host, port, true);
        this.applySNI(ssls, sniServerName, host);
        if (applicationProtocols != null) {
            this.setApplicationProtocols(ssls, applicationProtocols);
        }
        this.prepare(ssls);
        if (applicationProtocols != null) {
            ssls.startHandshake();
        }
        return ssls;
    }

    @Override
    public Socket createSocket(String host, int port, int connectTimeout, @javax.annotation.Nullable String sniServerName, @javax.annotation.Nullable String[] applicationProtocols) throws IOException {
        Socket s = new Socket();
        s.connect(new InetSocketAddress(host, port), connectTimeout);
        return this.createSocket(s, host, port, connectTimeout, sniServerName, applicationProtocols);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress addr, int localPort, int connectTimeout, @javax.annotation.Nullable String sniServerName, @javax.annotation.Nullable String[] applicationProtocols) throws IOException {
        Socket s = new Socket();
        s.bind(new InetSocketAddress(addr, localPort));
        s.connect(new InetSocketAddress(host, port), connectTimeout);
        return this.createSocket(s, host, port, connectTimeout, sniServerName, applicationProtocols);
    }

    private void applySNI(@NotNull SSLSocket ssls, @javax.annotation.Nullable String sniServerName, @NotNull String defaultHost) {
        if (sniServerName != null && sniServerName.isEmpty()) {
            return;
        }
        if (sniServerName == null) {
            sniServerName = defaultHost;
        }
        SNIHostName name = new SNIHostName(sniServerName.getBytes());
        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
        serverNames.add(name);
        SSLParameters params = ssls.getSSLParameters();
        params.setServerNames(serverNames);
        ssls.setSSLParameters(params);
    }

    private void setApplicationProtocols(@NotNull SSLSocket ssls, @NotNull String[] applicationProtocols) {
        SSLParameters sslp = ssls.getSSLParameters();
        sslp.setApplicationProtocols(applicationProtocols);
        ssls.setSSLParameters(sslp);
    }

    @Override
    SSLSocketFactory getSocketFactory() {
        return this.sslc.getSocketFactory();
    }

    @Override
    List<String> getDnsNames() {
        return this.dnsNames;
    }

    @Override
    String getLocation() {
        return this.sslParser.getKeyStore() != null ? this.sslParser.getKeyStore().getLocation() : "null";
    }

    @Override
    public String getPrometheusContextTypeName() {
        return "static";
    }

    @Override
    public boolean hasKeyAndCertificate() {
        return this.validity.until != 0L && this.validity.from != 0L;
    }

    @Override
    public long getValidFrom() {
        return this.validity.from;
    }

    @Override
    public long getValidUntil() {
        return this.validity.until;
    }

    static {
        String dhKeySize = System.getProperty("jdk.tls.ephemeralDHKeySize");
        if (dhKeySize == null || "legacy".equals(dhKeySize)) {
            System.setProperty("jdk.tls.ephemeralDHKeySize", "matched");
        }
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") <= 128) {
                log.warn("Your Java Virtual Machine does not have unlimited strength cryptography. If it is legal in your country, we strongly advise installing the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files.");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        String enableStatusRequestExtension = System.getProperty("jdk.tls.server.enableStatusRequestExtension");
        if (enableStatusRequestExtension == null) {
            System.setProperty("jdk.tls.server.enableStatusRequestExtension", "true");
        }
    }

    record Validity(long from, long until) {
    }
}

