/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl.acme;

import com.fasterxml.jackson.databind.JsonNode;
import com.predic8.membrane.core.azure.AzureDns;
import com.predic8.membrane.core.azure.AzureTableStorage;
import com.predic8.membrane.core.azure.api.AzureApiClient;
import com.predic8.membrane.core.azure.api.dns.DnsProvisionable;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.ssl.acme.AcmeKeyPair;
import com.predic8.membrane.core.transport.ssl.acme.AcmeSynchronizedStorageEngine;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcmeAzureTableApiStorageEngine
implements AcmeSynchronizedStorageEngine,
DnsProvisionable {
    private static final Logger log = LoggerFactory.getLogger(AcmeAzureTableApiStorageEngine.class);
    private static final String CURRENT = "current";
    private static final String CURRENT_ERROR = "current-error";
    private static final String CURRENT_KEY = "current-key";
    private final AzureApiClient apiClient;
    private final AzureDns azureDns;

    public AcmeAzureTableApiStorageEngine(AzureTableStorage tableStorage, @Nullable AzureDns azureDns, @Nullable HttpClientFactory httpClientFactory) {
        this.azureDns = azureDns;
        this.apiClient = new AzureApiClient(azureDns == null ? null : azureDns.getIdentity(), tableStorage, httpClientFactory);
        try {
            this.apiClient.tableStorage().table().create();
        }
        catch (Exception e) {
            log.debug("Ignore table already exists exception");
        }
        log.debug("Loaded {}", (Object)this.getClass().getSimpleName());
    }

    private JsonNode getEntity(String rowKey) {
        try {
            log.debug("Get entity for {}", (Object)rowKey);
            return this.apiClient.tableStorage().entity(rowKey).get();
        }
        catch (Exception e) {
            log.debug("Entity {} does not exist, returning null", (Object)rowKey);
            return null;
        }
    }

    private String getDataPropertyOfEntity(String rowKey) {
        JsonNode entity = this.getEntity(rowKey);
        return entity != null ? entity.get("data").asText() : null;
    }

    private void upsertDataEntity(String rowKey, String data) {
        try {
            log.debug("Upserting key {}", (Object)rowKey);
            this.apiClient.tableStorage().entity(rowKey).insertOrReplace(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String id(String[] hosts) {
        int i = Arrays.hashCode(hosts);
        if (i < 0) {
            i = Integer.MAX_VALUE + i + 1;
        }
        return hosts[0] + "-" + i;
    }

    private String getPublicKeyRowKey(String[] hosts) {
        return String.format("key-%s-pub.pem", this.id(hosts));
    }

    private String getPrivateKeyRowKey(String[] hosts) {
        return String.format("key-%s.pem", this.id(hosts));
    }

    private String getCertChainRowKey(String[] hosts) {
        return String.format("cert-%s.pem", this.id(hosts));
    }

    private String getTokenRowKey(String host) {
        return String.format("token-%s", host);
    }

    private String getOALRowKey(String[] hosts, String postfix) {
        return String.format("oal-%s-%s.json", this.id(hosts), postfix);
    }

    @Override
    public String getAccountKey() {
        return this.getDataPropertyOfEntity("account");
    }

    @Override
    public void setAccountKey(String key) {
        this.upsertDataEntity("account", key);
    }

    @Override
    public void setKeyPair(String[] hosts, AcmeKeyPair key) {
        this.upsertDataEntity(this.getPublicKeyRowKey(hosts), key.getPublicKey());
        this.upsertDataEntity(this.getPrivateKeyRowKey(hosts), key.getPrivateKey());
    }

    @Override
    public String getPublicKey(String[] hosts) {
        return this.getDataPropertyOfEntity(this.getPublicKeyRowKey(hosts));
    }

    @Override
    public String getPrivateKey(String[] hosts) {
        return this.getDataPropertyOfEntity(this.getPrivateKeyRowKey(hosts));
    }

    @Override
    public void setCertChain(String[] hosts, String caChain) {
        this.upsertDataEntity(this.getCertChainRowKey(hosts), caChain);
    }

    @Override
    public String getCertChain(String[] hosts) {
        return this.getDataPropertyOfEntity(this.getCertChainRowKey(hosts));
    }

    @Override
    public void setToken(String host, String token) {
        this.upsertDataEntity(this.getTokenRowKey(host), token);
    }

    @Override
    public String getToken(String host) {
        return this.getDataPropertyOfEntity(this.getTokenRowKey(host));
    }

    @Override
    public String getOAL(String[] hosts) {
        return this.getDataPropertyOfEntity(this.getOALRowKey(hosts, CURRENT));
    }

    @Override
    public void setOAL(String[] hosts, String oal) {
        this.upsertDataEntity(this.getOALRowKey(hosts, CURRENT), oal);
    }

    @Override
    public String getAccountURL() {
        return this.getDataPropertyOfEntity("account-url");
    }

    @Override
    public void setAccountURL(String url) {
        this.upsertDataEntity("account-url", url);
    }

    @Override
    public String getAccountContacts() {
        return this.getDataPropertyOfEntity("account-contacts");
    }

    @Override
    public void setAccountContacts(String contacts) {
        this.upsertDataEntity("account-contacts", contacts);
    }

    @Override
    public String getOALError(String[] hosts) {
        return this.getDataPropertyOfEntity(this.getOALRowKey(hosts, CURRENT_ERROR));
    }

    @Override
    public void setOALError(String[] hosts, String oalError) {
        this.upsertDataEntity(this.getOALRowKey(hosts, CURRENT_ERROR), oalError);
    }

    @Override
    public String getOALKey(String[] hosts) {
        return this.getDataPropertyOfEntity(this.getOALRowKey(hosts, CURRENT_KEY));
    }

    @Override
    public void setOALKey(String[] hosts, String oalKey) {
        this.upsertDataEntity(this.getOALRowKey(hosts, CURRENT_KEY), oalKey);
    }

    @Override
    public void archiveOAL(String[] hosts) {
        long now = System.currentTimeMillis();
        this.attemptRename(this.getOALRowKey(hosts, CURRENT), this.getOALRowKey(hosts, String.valueOf(now)));
        this.attemptRename(this.getOALRowKey(hosts, CURRENT_ERROR), this.getOALRowKey(hosts, now + "-error"));
        this.attemptRename(this.getOALRowKey(hosts, CURRENT_KEY), this.getOALRowKey(hosts, now + "-key"));
    }

    private void attemptRename(String f1, String f2) {
        log.debug("Attempt rename {} to {}", (Object)f1, (Object)f2);
        String first = this.getDataPropertyOfEntity(f1);
        if (first != null) {
            try {
                log.debug("creating {}", (Object)f2);
                this.apiClient.tableStorage().entity(f2).insertOrReplace(first);
                log.debug("removing {}", (Object)f1);
                this.apiClient.tableStorage().entity(f1).delete();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        log.debug("Attempt rename, but there was nothing to rename");
    }

    @Override
    public void provisionDns(String domain, String record) {
        try {
            this.apiClient.dnsRecords(this.azureDns).txt("_acme-challenge").ttl(300).addRecord().withValue(record).create();
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean acquireLease(long durationMillis) {
        return true;
    }

    @Override
    public boolean prolongLease(long durationMillis) {
        return true;
    }

    @Override
    public void releaseLease() {
    }
}

