/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl.acme;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.azure.AzureDns;
import com.predic8.membrane.core.azure.AzureTableStorage;
import com.predic8.membrane.core.azure.api.dns.DnsProvisionable;
import com.predic8.membrane.core.config.security.acme.Acme;
import com.predic8.membrane.core.config.security.acme.AcmeSynchronizedStorage;
import com.predic8.membrane.core.config.security.acme.AcmeValidation;
import com.predic8.membrane.core.config.security.acme.FileStorage;
import com.predic8.membrane.core.config.security.acme.KubernetesStorage;
import com.predic8.membrane.core.config.security.acme.MemoryStorage;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientFactory;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.ssl.acme.AcmeAzureTableApiStorageEngine;
import com.predic8.membrane.core.transport.ssl.acme.AcmeErrorLog;
import com.predic8.membrane.core.transport.ssl.acme.AcmeException;
import com.predic8.membrane.core.transport.ssl.acme.AcmeFileStorageEngine;
import com.predic8.membrane.core.transport.ssl.acme.AcmeKeyPair;
import com.predic8.membrane.core.transport.ssl.acme.AcmeKubernetesStorageEngine;
import com.predic8.membrane.core.transport.ssl.acme.AcmeMemoryStorageEngine;
import com.predic8.membrane.core.transport.ssl.acme.AcmeSynchronizedStorageEngine;
import com.predic8.membrane.core.transport.ssl.acme.Authorization;
import com.predic8.membrane.core.transport.ssl.acme.Challenge;
import com.predic8.membrane.core.transport.ssl.acme.Order;
import com.predic8.membrane.core.transport.ssl.acme.OrderAndLocation;
import com.predic8.membrane.core.util.Pair;
import com.predic8.membrane.core.util.URIFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.EcJwkGenerator;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.keys.EllipticCurves;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcmeClient {
    public static final String BEGIN_CERTIFICATE_REQUEST = "-----BEGIN CERTIFICATE REQUEST-----";
    public static final String END_CERTIFICATE_REQUEST = "-----END CERTIFICATE REQUEST-----";
    private static final Logger LOG;
    private static final SecureRandom random;
    private static final SimpleDateFormat sdf;
    private final String directoryUrl;
    private final HttpClient hc;
    private final ObjectMapper om = new ObjectMapper();
    private final List<String> nonces = new ArrayList<String>();
    private final String challengeType;
    private final AcmeSynchronizedStorage ass;
    private String keyChangeUrl;
    private String newAccountUrl;
    private String newNonceUrl;
    private String newOrderUrl;
    private String revokeCertUrl;
    private final List<String> contacts;
    private final boolean termsOfServiceAgreed;
    private PrivateKey privateKey;
    private PublicJsonWebKey publicJsonWebKey;
    private final String algorithm = "ES256";
    private final Duration validity;
    private AcmeSynchronizedStorageEngine asse;
    private final AcmeValidation acmeValidation;

    public AcmeClient(Acme acme, @Nullable HttpClientFactory httpClientFactory) {
        this.directoryUrl = acme.getDirectoryUrl();
        this.termsOfServiceAgreed = acme.isTermsOfServiceAgreed();
        this.ass = acme.getAcmeSynchronizedStorage();
        this.contacts = Arrays.asList(acme.getContacts().split(" +"));
        if (httpClientFactory == null) {
            httpClientFactory = new HttpClientFactory(null);
        }
        this.hc = httpClientFactory.createClient(acme.getHttpClientConfiguration());
        this.validity = acme.getValidityDuration();
        this.acmeValidation = acme.getValidationMethod();
        this.challengeType = acme.getValidationMethod() != null && acme.getValidationMethod().useDnsValidation() ? "dns-01" : "http-01";
        this.om.registerModule((Module)new JodaModule());
        if (!acme.isExperimental()) {
            throw new RuntimeException("The ACME client is still experimental, please set <acme experimental=\"true\" ... /> to acknowledge.");
        }
    }

    public void init(@Nullable KubernetesClientFactory kubernetesClientFactory, @Nullable HttpClientFactory httpClientFactory) {
        if (this.ass == null) {
            throw new RuntimeException("<acme> is used, but to storage is configured.");
        }
        if (this.ass instanceof FileStorage) {
            this.asse = new AcmeFileStorageEngine((FileStorage)this.ass);
        } else if (this.ass instanceof KubernetesStorage) {
            this.asse = new AcmeKubernetesStorageEngine((KubernetesStorage)this.ass, kubernetesClientFactory);
        } else if (this.ass instanceof MemoryStorage) {
            this.asse = new AcmeMemoryStorageEngine();
        } else if (this.ass instanceof AzureTableStorage) {
            this.asse = new AcmeAzureTableApiStorageEngine((AzureTableStorage)this.ass, (AzureDns)this.acmeValidation, httpClientFactory);
        } else {
            throw new RuntimeException("Unsupported: Storage type " + this.ass.getClass().getName());
        }
        if (this.challengeType.equals("dns-01") && !(this.asse instanceof DnsProvisionable)) {
            throw new RuntimeException("A");
        }
    }

    public void loadDirectory() throws Exception {
        Exchange e = this.hc.call(new Request.Builder().get(this.directoryUrl).header("User-Agent", Constants.VERSION).buildExchange());
        this.handleError(e);
        Map dir = (Map)this.om.readValue(e.getResponse().getBodyAsStreamDecoded(), Map.class);
        this.keyChangeUrl = (String)dir.get("keyChange");
        this.newAccountUrl = (String)dir.get("newAccount");
        this.newNonceUrl = (String)dir.get("newNonce");
        this.newOrderUrl = (String)dir.get("newOrder");
        this.revokeCertUrl = (String)dir.get("revokeCert");
    }

    private void handleError(Exchange e) throws IOException, AcmeException {
        if (e.getResponse().getStatusCode() >= 300) {
            if (MimeType.isOfMediaType("application/problem+json", AcmeClient.getContentType(e))) {
                Map m = (Map)this.om.readValue(e.getResponse().getBodyAsStreamDecoded(), Map.class);
                String type = (String)m.get("type");
                String detail = (String)m.get("detail");
                List sub = (List)m.get("subproblems");
                throw new AcmeException(type, detail, this.parse(sub), AcmeClient.getReplayNonce(e));
            }
            throw new RuntimeException("ACME Server returned " + String.valueOf(e.getResponse()) + " " + e.getResponse().getBodyAsStringDecoded());
        }
    }

    private static String getContentType(Exchange e) {
        return e.getResponse().getHeader().getFirstValue("Content-Type");
    }

    private List<AcmeException.SubProblem> parse(List<Map> subproblems) {
        if (subproblems == null) {
            return null;
        }
        return subproblems.stream().map(m -> new AcmeException.SubProblem((String)m.get("type"), (String)m.get("detail"), (Map)m.get("identifier"))).collect(Collectors.toList());
    }

    public String retrieveNewNonce() throws Exception {
        Exchange e = this.hc.call(this.createHeadRequest());
        this.handleError(e);
        String replayNonce = AcmeClient.getReplayNonce(e);
        e.getResponse().getBodyAsStringDecoded();
        return replayNonce;
    }

    private Exchange createHeadRequest() throws URISyntaxException {
        return new Request.Builder().method("HEAD").url(new URIFactory(), this.newNonceUrl).header("User-Agent", Constants.VERSION).buildExchange();
    }

    public AcmeKeyPair generateCertificateKey() {
        try {
            return AcmeClient.getAcmeKeyPair(AcmeClient.getKeyPairGenerator().generateKeyPair());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static AcmeKeyPair getAcmeKeyPair(KeyPair kp) {
        return new AcmeKeyPair(AcmeClient.getPublicKeyBase64Encoded(kp), AcmeClient.getKeyBase64Encoded(kp));
    }

    @NotNull
    private static String getPublicKeyBase64Encoded(KeyPair kp) {
        return "-----BEGIN PUBLIC KEY-----\n" + org.jose4j.base64url.Base64.encode((byte[])kp.getPublic().getEncoded()) + "\n-----END PUBLIC KEY-----\n";
    }

    @NotNull
    private static String getKeyBase64Encoded(KeyPair kp) {
        return "-----BEGIN EC PRIVATE KEY-----\n" + org.jose4j.base64url.Base64.encode((byte[])kp.getPrivate().getEncoded()) + "\n-----END EC PRIVATE KEY-----\n";
    }

    @NotNull
    private static KeyPairGenerator getKeyPairGenerator() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("ECDSA", "BC");
        kpg.initialize(new ECGenParameterSpec("secp384r1"), random);
        return kpg;
    }

    public String generateCSR(String[] hosts, String privateKey) {
        try {
            PrivateKey pk = AcmeClient.getPrivateKeyFromString(privateKey);
            JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal("CN=" + hosts[0]), this.computePublicKeyFromPrivate(pk));
            p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)AcmeClient.getExtensions(GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable[])AcmeClient.getGeneralNames(hosts)))));
            return AcmeClient.formatCSR(AcmeClient.convertCSR2String(AcmeClient.getPkcs10CertificationRequest(pk, p10Builder)));
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String formatCSR(String sw) {
        return sw.replaceAll(BEGIN_CERTIFICATE_REQUEST + System.lineSeparator(), "").replaceAll(System.lineSeparator() + END_CERTIFICATE_REQUEST, "").replaceAll(System.lineSeparator(), "").replaceAll("/", "_").replaceAll("\\+", "-").replaceAll("=", "");
    }

    @NotNull
    private static String convertCSR2String(PKCS10CertificationRequest csr2) throws IOException {
        StringWriter sw = new StringWriter();
        JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)sw);
        jcaPEMWriter.writeObject((Object)csr2);
        jcaPEMWriter.close();
        return sw.toString();
    }

    private static PKCS10CertificationRequest getPkcs10CertificationRequest(PrivateKey pk, JcaPKCS10CertificationRequestBuilder p10Builder) throws OperatorCreationException {
        return p10Builder.build(new JcaContentSignerBuilder("SHA256withECDSA").build(pk));
    }

    private static Extensions getExtensions(GeneralNames subjectAltNames) throws IOException {
        ExtensionsGenerator generator = new ExtensionsGenerator();
        generator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        return generator.generate();
    }

    private static GeneralName @NotNull [] getGeneralNames(String[] hosts) {
        GeneralName[] altNames = new GeneralName[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            altNames[i] = new GeneralName(2, hosts[i]);
        }
        return altNames;
    }

    private static PrivateKey getPrivateKeyFromString(String privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, InvalidKeySpecException {
        PrivateKey pk;
        KeyFactory factory = KeyFactory.getInstance("ECDSA", "BC");
        try (PemReader pemReader = new PemReader((Reader)new StringReader(privateKey));){
            PemObject pemObject = pemReader.readPemObject();
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
            pk = factory.generatePrivate(privKeySpec);
        }
        return pk;
    }

    private PublicKey computePublicKeyFromPrivate(PrivateKey pk) {
        BCECPrivateKey pk1 = (BCECPrivateKey)pk;
        BigInteger d = pk1.getD();
        ECPoint q = pk1.getParameters().getG().multiply(d);
        return new BCECPublicKey("EC", new ECPublicKeySpec(q, pk1.getParameters()), BouncyCastleProvider.CONFIGURATION);
    }

    public String getToken(String host) {
        return this.asse.getToken(host);
    }

    public String provision(Authorization auth) throws Exception {
        Optional<Challenge> challenge = auth.getChallenges().stream().filter(c -> this.challengeType.equals(c.getType())).findAny();
        if (challenge.isEmpty()) {
            throw new RuntimeException("Could not find challenge of type " + this.challengeType + ": " + this.om.writeValueAsString((Object)auth));
        }
        if (!"dns".equals(auth.getIdentifier().getType())) {
            throw new RuntimeException("Identifier type is not DNS: " + this.om.writeValueAsString((Object)auth));
        }
        if ("http-01".equals(this.challengeType)) {
            this.provisionHttp(auth, challenge.get());
        } else if ("dns-01".equals(this.challengeType)) {
            this.provisionDns(auth, challenge.get());
        } else {
            throw new RuntimeException("Unimplemented challenge type handling " + this.challengeType);
        }
        return challenge.get().getUrl();
    }

    private void provisionDns(Authorization auth, Challenge challenge) throws JoseException, NoSuchAlgorithmException {
        String keyAuth = challenge.getToken() + "." + this.getThumbprint();
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String record = Base64.getUrlEncoder().withoutPadding().encodeToString(digest.digest(keyAuth.getBytes(StandardCharsets.UTF_8)));
        ((DnsProvisionable)((Object)this.asse)).provisionDns(auth.getIdentifier().getValue(), record);
    }

    private void provisionHttp(Authorization auth, Challenge challenge) {
        this.asse.setToken(auth.getIdentifier().getValue(), challenge.token);
    }

    public String getChallengeType() {
        return this.challengeType;
    }

    public Exchange doJWSRequest(String url, String nonce, JWSParametrizer c) throws Exception {
        Exchange f = this.createExchange(url, nonce, c);
        this.handleError(f);
        return f;
    }

    private Exchange createExchange(String url, String nonce, JWSParametrizer c) throws Exception {
        return this.hc.call(new Request.Builder().post(url).header("Content-Type", "application/jose+json").header("User-Agent", Constants.VERSION).body(AcmeClient.convert2String(this.getMyJsonWebSignature(url, nonce, c))).buildExchange());
    }

    private static String convert2String(MyJsonWebSignature jws) {
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put("protected", jws.getEncodedHeader());
        json.put("payload", jws.getEncodedPayload());
        json.put("signature", jws.getEncodedSignature());
        return JsonUtil.toJson(json);
    }

    @NotNull
    private MyJsonWebSignature getMyJsonWebSignature(String url, String nonce, JWSParametrizer c) throws Exception {
        MyJsonWebSignature jws = new MyJsonWebSignature();
        jws.setAlgorithmHeaderValue("ES256");
        jws.setKey(this.getPrivateKey());
        jws.setHeader("nonce", nonce);
        jws.setHeader("url", url);
        c.call(jws);
        jws.sign();
        return jws;
    }

    public Exchange withNonce(HttpCallerWithNonce f) throws Exception {
        try {
            this.rememberNonce(AcmeClient.getReplayNonce(f.call(this.getNonce())));
            return f.call(this.getNonce());
        }
        catch (AcmeException ex) {
            try {
                if ("urn:ietf:params:acme:error:badNonce".equals(ex.getType())) {
                    Exchange e = f.call(ex.getNonce());
                    this.rememberNonce(AcmeClient.getReplayNonce(e));
                    return e;
                }
                throw ex;
            }
            catch (AcmeException ex2) {
                this.rememberNonce(ex2.getNonce());
                throw ex2;
            }
        }
    }

    private static String getReplayNonce(Exchange e) {
        return e.getResponse().getHeader().getFirstValue("Replay-Nonce");
    }

    private String getNonce() throws Exception {
        String nonce = this.getRememberedNonce();
        if (nonce == null) {
            nonce = this.retrieveNewNonce();
        }
        return nonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRememberedNonce() {
        List<String> list = this.nonces;
        synchronized (list) {
            int size = this.nonces.size();
            if (size == 0) {
                return null;
            }
            return this.nonces.remove(size - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberNonce(@Nullable String nonce) {
        if (nonce != null) {
            List<String> list = this.nonces;
            synchronized (list) {
                this.nonces.add(nonce);
            }
        }
    }

    public String createAccount() throws Exception {
        Exchange e = this.withNonce(nonce -> this.doJWSRequest(this.newAccountUrl, nonce, jws -> {
            HashMap<String, Object> pl = new HashMap<String, Object>();
            pl.put("termsOfServiceAgreed", this.termsOfServiceAgreed);
            pl.put("contact", this.contacts);
            String payload = this.om.writeValueAsString(pl);
            jws.setPayload(payload);
            jws.setJwkHeader(this.getPublicJwk());
        }));
        e.getResponse().getBodyAsStringDecoded();
        return e.getResponse().getHeader().getFirstValue("Location");
    }

    private PublicJsonWebKey getPublicJwk() throws JoseException {
        this.getPrivateKey();
        return this.publicJsonWebKey;
    }

    public OrderAndLocation createOrder(String accountUrl, List<String> hostnames) throws Exception {
        return this.getOrderAndLocation(this.createExchange(accountUrl, hostnames, this.getNotBeforeNotAfter()));
    }

    @NotNull
    private OrderAndLocation getOrderAndLocation(Exchange e) throws IOException {
        return new OrderAndLocation(this.parseOrder(e.getResponse()), e.getResponse().getHeader().getFirstValue("Location"));
    }

    private Exchange createExchange(String accountUrl, List<String> hostnames, Pair<String, String> notBeforeNotAfter) throws Exception {
        return this.withNonce(nonce -> this.doJWSRequest(this.newOrderUrl, nonce, jws -> {
            HashMap<String, Object> pl = new HashMap<String, Object>();
            if (this.validity != null) {
                pl.put("notBefore", notBeforeNotAfter.first());
                pl.put("notAfter", notBeforeNotAfter.second());
            }
            pl.put("identifiers", AcmeClient.getIdentifiers(hostnames));
            String payload = this.om.writeValueAsString(pl);
            jws.setPayload(payload);
            jws.setKeyIdHeaderValue(accountUrl);
        }));
    }

    @NotNull
    private static List<ImmutableMap<String, String>> getIdentifiers(List<String> hostnames) {
        return hostnames.stream().map(host -> ImmutableMap.of((Object)"type", (Object)"dns", (Object)"value", (Object)host)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Pair<String, String> getNotBeforeNotAfter() {
        if (this.validity != null) {
            Date now = new Date();
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return new Pair<String, String>(sdf.format(now), sdf.format(new Date(now.getTime() + this.validity.getMillis())));
            }
        }
        return new Pair<Object, Object>(null, null);
    }

    public OrderAndLocation getOrder(String accountUrl, String orderUrl) throws Exception {
        Exchange e = this.withNonce(nonce -> this.doJWSRequest(orderUrl, nonce, jws -> {
            jws.setPayload("");
            jws.setKeyIdHeaderValue(accountUrl);
        }));
        return new OrderAndLocation(this.parseOrder(e.getResponse()), orderUrl);
    }

    private Order parseOrder(Response response) throws IOException {
        return (Order)this.om.readValue(response.getBodyAsStreamDecoded(), Order.class);
    }

    private Challenge parseChallenge(Response response) throws IOException {
        return (Challenge)this.om.readValue(response.getBodyAsStreamDecoded(), Challenge.class);
    }

    public Order finalizeOrder(String accountUrl, String finalizationUrl, String csr) throws Exception {
        Exchange e = this.withNonce(nonce -> this.doJWSRequest(finalizationUrl, nonce, jws -> {
            HashMap<String, String> pl = new HashMap<String, String>();
            pl.put("csr", csr);
            String payload = this.om.writeValueAsString(pl);
            jws.setPayload(payload);
            jws.setKeyIdHeaderValue(accountUrl);
        }));
        return this.parseOrder(e.getResponse());
    }

    public Authorization getAuth(String accountUrl, String authUrl) throws Exception {
        Exchange e = this.withNonce(nonce -> this.doJWSRequest(authUrl, nonce, jws -> {
            jws.setPayload("");
            jws.setKeyIdHeaderValue(accountUrl);
        }));
        return this.parseAuthorization(e.getResponse());
    }

    private Authorization parseAuthorization(Response response) throws IOException {
        return (Authorization)this.om.readValue(response.getBodyAsStreamDecoded(), Authorization.class);
    }

    public void readyForChallenge(String accountUrl, String challengeUrl) throws Exception {
        Exchange e = this.withNonce(nonce -> this.doJWSRequest(challengeUrl, nonce, jws -> {
            jws.setPayload("{}");
            jws.setKeyIdHeaderValue(accountUrl);
        }));
        this.parseChallenge(e.getResponse());
    }

    public String downloadCertificate(String accountUrl, String certificateUrl) throws Exception {
        Exchange e = this.withNonce(nonce -> this.doJWSRequest(certificateUrl, nonce, jws -> {
            jws.setPayload("");
            jws.setKeyIdHeaderValue(accountUrl);
        }));
        return e.getResponse().getBodyAsStringDecoded();
    }

    public String getThumbprint() throws JoseException {
        return this.getPublicJwk().calculateBase64urlEncodedThumbprint("SHA-256");
    }

    private Key getPrivateKey() throws JoseException {
        String accountKey = this.asse.getAccountKey();
        if (accountKey != null) {
            EllipticCurveJsonWebKey ek = new EllipticCurveJsonWebKey(JsonUtil.parseJson((String)accountKey));
            this.privateKey = ek.getPrivateKey();
            this.publicJsonWebKey = ek;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("acme: generating key");
            }
            EllipticCurveJsonWebKey jwk = this.generateKey();
            this.privateKey = jwk.getPrivateKey();
            this.asse.setAccountKey(jwk.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
            this.publicJsonWebKey = jwk;
        }
        return this.privateKey;
    }

    private EllipticCurveJsonWebKey generateKey() throws JoseException {
        String spec = "P-256";
        EllipticCurveJsonWebKey jwk = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.getSpec((String)spec), null, (SecureRandom)random);
        jwk.setKeyId(new BigInteger(130, random).toString(32));
        jwk.setUse("sig");
        jwk.setAlgorithm("ES256");
        return jwk;
    }

    public String getKey(String[] hosts) {
        return this.asse.getPrivateKey(hosts);
    }

    public String getCertificates(String[] hosts) {
        return this.asse.getCertChain(hosts);
    }

    AcmeSynchronizedStorageEngine getAsse() {
        return this.asse;
    }

    public void ensureAccountKeyExists() throws JoseException {
        this.getPrivateKey();
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setOALKey(String[] hosts, AcmeKeyPair key) throws JsonProcessingException {
        this.asse.setOALKey(hosts, this.om.writeValueAsString((Object)key));
    }

    public AcmeKeyPair getOALKey(String[] hosts) throws JsonProcessingException {
        String key = this.asse.getOALKey(hosts);
        if (key == null) {
            return null;
        }
        return (AcmeKeyPair)this.om.readValue(key, AcmeKeyPair.class);
    }

    public void setOALError(String[] hosts, AcmeErrorLog acmeErrorLog) throws JsonProcessingException {
        this.asse.setOALError(hosts, this.om.writeValueAsString((Object)acmeErrorLog));
    }

    public AcmeErrorLog getOALError(String[] hosts) throws JsonProcessingException {
        String error = this.asse.getOALError(hosts);
        if (error == null) {
            return null;
        }
        return (AcmeErrorLog)this.om.readValue(error, AcmeErrorLog.class);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOG = LoggerFactory.getLogger(AcmeClient.class);
        random = new SecureRandom();
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    }

    public static interface JWSParametrizer {
        public void call(JsonWebSignature var1) throws Exception;
    }

    private static class MyJsonWebSignature
    extends JsonWebSignature {
        private MyJsonWebSignature() {
        }

        public String getEncodedHeader() {
            return super.getEncodedHeader();
        }
    }

    public static interface HttpCallerWithNonce {
        public Exchange call(String var1) throws Exception;
    }
}

