/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl.acme;

import com.google.common.collect.ImmutableList;
import com.predic8.membrane.core.config.security.acme.FileStorage;
import com.predic8.membrane.core.transport.ssl.acme.AcmeKeyPair;
import com.predic8.membrane.core.transport.ssl.acme.AcmeSynchronizedStorageEngine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;

public class AcmeFileStorageEngine
implements AcmeSynchronizedStorageEngine {
    private static final Random random = new Random();
    private final String id = UUID.randomUUID().toString();
    private final File base;

    public AcmeFileStorageEngine(FileStorage fileStorage) {
        this.base = new File(fileStorage.getDir());
    }

    @Override
    public String getAccountKey() {
        try {
            File file = new File(this.base, "account.jwk.json");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAccountKey(String key) {
        File file = new File(this.base, "account.jwk.json");
        try {
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)key), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setKeyPair(String[] hosts, AcmeKeyPair key) {
        try {
            File file = new File(this.base, "key-" + this.id(hosts) + "-pub.pem");
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)key.getPublicKey()), new OpenOption[0]);
            file = new File(this.base, "key-" + this.id(hosts) + ".pem");
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)key.getPrivateKey()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPublicKey(String[] hosts) {
        try {
            File file = new File(this.base, "key-" + this.id(hosts) + "-pub.pem");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPrivateKey(String[] hosts) {
        try {
            File file = new File(this.base, "key-" + this.id(hosts) + ".pem");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setCertChain(String[] hosts, String caChain) {
        try {
            File file = new File(this.base, "cert-" + this.id(hosts) + ".pem");
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)caChain), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCertChain(String[] hosts) {
        try {
            File file = new File(this.base, "cert-" + this.id(hosts) + ".pem");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String id(String[] hosts) {
        int i = Arrays.hashCode(hosts);
        if (i < 0) {
            i = Integer.MAX_VALUE + i + 1;
        }
        return hosts[0] + "-" + i;
    }

    @Override
    public void setToken(String host, String token) {
        try {
            File file = new File(this.base, "token-" + host + ".txt");
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)token), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getToken(String host) {
        try {
            File file = new File(this.base, "token-" + host + ".txt");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAccountURL() {
        try {
            File file = new File(this.base, "account-url.txt");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAccountURL(String url) {
        File file = new File(this.base, "account-url.txt");
        try {
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)url), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAccountContacts() {
        try {
            File file = new File(this.base, "account-contacts.txt");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAccountContacts(String contacts) {
        File file = new File(this.base, "account-contacts.txt");
        try {
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)contacts), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOAL(String[] hosts) {
        try {
            File file = new File(this.base, "oal-" + this.id(hosts) + "-current.json");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setOAL(String[] hosts, String oal) {
        try {
            File file = new File(this.base, "oal-" + this.id(hosts) + "-current.json");
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)oal), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOALError(String[] hosts) {
        try {
            File file = new File(this.base, "oal-" + this.id(hosts) + "-current-error.json");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setOALError(String[] hosts, String oalError) {
        try {
            File file = new File(this.base, "oal-" + this.id(hosts) + "-current-error.json");
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)oalError), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOALKey(String[] hosts) {
        try {
            File file = new File(this.base, "oal-" + this.id(hosts) + "-current-key.json");
            if (!file.exists()) {
                return null;
            }
            return Files.readAllLines(file.toPath()).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setOALKey(String[] hosts, String oalKey) {
        try {
            File file = new File(this.base, "oal-" + this.id(hosts) + "-current-key.json");
            Files.write(file.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)oalKey), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void archiveOAL(String[] hosts) {
        long now = System.currentTimeMillis();
        String id = this.id(hosts);
        this.attemptRename("oal-" + id + "-current.json", "oal-" + id + "-" + now + ".json");
        this.attemptRename("oal-" + id + "-current-error.json", "oal-" + id + "-" + now + "-error.json");
        this.attemptRename("oal-" + id + "-current-key.json", "oal-" + id + "-" + now + "-key.json");
    }

    private void attemptRename(String f1, String f2) {
        File file1 = new File(this.base, f1);
        File file2 = new File(this.base, f2);
        if (file1.exists() && !file1.renameTo(file2)) {
            throw new RuntimeException("Could not rename file " + file1.getAbsolutePath() + " to " + file2.getAbsolutePath() + " .");
        }
    }

    @Override
    public boolean acquireLease(long durationMillis) {
        File f = new File(this.base, "lock.txt");
        if (f.exists()) {
            try {
                List<String> lines = Files.readAllLines(f.toPath());
                if (lines.size() != 2) {
                    try {
                        Thread.sleep(random.nextInt(1000));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    List<String> lines2 = Files.readAllLines(f.toPath());
                    if (lines.size() == lines2.size()) {
                        f.delete();
                    }
                    return false;
                }
                if (Long.parseLong(lines.get(1)) > System.currentTimeMillis()) {
                    return false;
                }
                Files.delete(f.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        try {
            Files.write(f.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)this.id, (Object)("" + (System.currentTimeMillis() + durationMillis))), StandardOpenOption.CREATE_NEW);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean prolongLease(long durationMillis) {
        File f = new File(this.base, "lock.txt");
        if (!f.exists()) {
            return false;
        }
        try {
            List<String> lines = Files.readAllLines(f.toPath());
            if (lines.size() != 2) {
                return false;
            }
            if (!lines.get(0).equals(this.id)) {
                return false;
            }
            if (Long.parseLong(lines.get(1)) > System.currentTimeMillis()) {
                return false;
            }
            Files.write(f.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)this.id, (Object)("" + (System.currentTimeMillis() + durationMillis))), StandardOpenOption.TRUNCATE_EXISTING);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void releaseLease() {
        File f = new File(this.base, "lock.txt");
        if (!f.exists()) {
            return;
        }
        try {
            List<String> lines = Files.readAllLines(f.toPath());
            if (lines.size() != 2) {
                return;
            }
            if (!lines.get(0).equals(this.id)) {
                return;
            }
            Files.delete(f.toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

