/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl.acme;

import com.predic8.membrane.core.transport.ssl.acme.AcmeKeyPair;
import com.predic8.membrane.core.transport.ssl.acme.AcmeSynchronizedStorageEngine;
import java.util.Arrays;
import java.util.HashMap;

public class AcmeMemoryStorageEngine
implements AcmeSynchronizedStorageEngine {
    private HashMap<String, String> files = new HashMap();
    private long lockedUntil = 0L;

    @Override
    public synchronized String getAccountKey() {
        return this.files.get("account.jwk.json");
    }

    @Override
    public synchronized void setAccountKey(String key) {
        this.files.put("account.jwk.json", key);
    }

    @Override
    public synchronized void setKeyPair(String[] hosts, AcmeKeyPair key) {
        this.files.put("key-" + this.id(hosts) + "-pub.pem", key.getPublicKey());
        this.files.put("key-" + this.id(hosts) + ".pem", key.getPrivateKey());
    }

    @Override
    public synchronized String getPublicKey(String[] hosts) {
        return this.files.get("key-" + this.id(hosts) + "-pub.pem");
    }

    @Override
    public synchronized String getPrivateKey(String[] hosts) {
        return this.files.get("key-" + this.id(hosts) + ".pem");
    }

    @Override
    public synchronized void setCertChain(String[] hosts, String caChain) {
        this.files.put("cert-" + this.id(hosts) + ".pem", caChain);
    }

    @Override
    public synchronized String getCertChain(String[] hosts) {
        return this.files.get("cert-" + this.id(hosts) + ".pem");
    }

    private synchronized String id(String[] hosts) {
        int i = Arrays.hashCode(hosts);
        if (i < 0) {
            i = Integer.MAX_VALUE + i + 1;
        }
        return hosts[0] + "-" + i;
    }

    @Override
    public synchronized void setToken(String host, String token) {
        this.files.put("token-" + host + ".txt", token);
    }

    @Override
    public synchronized String getToken(String host) {
        return this.files.get("token-" + host + ".txt");
    }

    @Override
    public synchronized String getAccountURL() {
        return this.files.get("account-url.txt");
    }

    @Override
    public synchronized void setAccountURL(String url) {
        this.files.put("account-url.txt", url);
    }

    @Override
    public synchronized String getAccountContacts() {
        return this.files.get("account-contacts.txt");
    }

    @Override
    public synchronized void setAccountContacts(String contacts) {
        this.files.put("account-contacts.txt", contacts);
    }

    @Override
    public synchronized String getOAL(String[] hosts) {
        return this.files.get("oal-" + this.id(hosts) + "-current.json");
    }

    @Override
    public synchronized void setOAL(String[] hosts, String oal) {
        this.files.put("oal-" + this.id(hosts) + "-current.json", oal);
    }

    @Override
    public synchronized String getOALError(String[] hosts) {
        return this.files.get("oal-" + this.id(hosts) + "-current-error.json");
    }

    @Override
    public synchronized void setOALError(String[] hosts, String oalError) {
        this.files.put("oal-" + this.id(hosts) + "-current-error.json", oalError);
    }

    @Override
    public synchronized String getOALKey(String[] hosts) {
        return this.files.get("oal-" + this.id(hosts) + "-current-key.json");
    }

    @Override
    public synchronized void setOALKey(String[] hosts, String oalKey) {
        this.files.put("oal-" + this.id(hosts) + "-current-key.json", oalKey);
    }

    @Override
    public synchronized void archiveOAL(String[] hosts) {
        long now = System.currentTimeMillis();
        String id = this.id(hosts);
        this.attemptRename("oal-" + id + "-current.json", "oal-" + id + "-" + now + ".json");
        this.attemptRename("oal-" + id + "-current-error.json", "oal-" + id + "-" + now + "-error.json");
        this.attemptRename("oal-" + id + "-current-key.json", "oal-" + id + "-" + now + "-key.json");
    }

    private void attemptRename(String key1, String key2) {
        String oldValue = this.files.remove(key1);
        if (oldValue != null) {
            this.files.put(key2, oldValue);
        }
    }

    @Override
    public synchronized boolean acquireLease(long durationMillis) {
        if (this.lockedUntil != 0L) {
            return false;
        }
        this.lockedUntil = System.currentTimeMillis() + durationMillis;
        return true;
    }

    @Override
    public synchronized boolean prolongLease(long durationMillis) {
        if (this.lockedUntil < System.currentTimeMillis()) {
            return false;
        }
        this.lockedUntil = System.currentTimeMillis() + durationMillis;
        return true;
    }

    @Override
    public synchronized void releaseLease() {
        this.lockedUntil = 0L;
    }
}

