/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.ExchangesUtil;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.interceptor.statistics.PropertyComparator;
import com.predic8.membrane.core.proxies.AbstractProxy;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import java.util.Comparator;

public class ComparatorFactory {
    public static Comparator<AbstractExchange> getAbstractExchangeComparator(String propName, String order) {
        if ("statusCode".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Integer>(order, exc -> exc.getResponse().getStatusCode());
        }
        if ("proxy".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, exc -> exc.getProxy().toString());
        }
        if ("method".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, exc -> exc.getRequest().getMethod());
        }
        if ("path".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, exc -> exc.getRequest().getUri());
        }
        if ("client".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, AbstractExchange::getRemoteAddr);
        }
        if ("server".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, AbstractExchange::getServer);
        }
        if ("reqContentType".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, AbstractExchange::getRequestContentType);
        }
        if ("reqContentLength".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Long>(order, AbstractExchange::getRequestContentLength);
        }
        if ("respContentType".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, AbstractExchange::getResponseContentType);
        }
        if ("respContentLength".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Long>(order, AbstractExchange::getResponseContentLength);
        }
        if ("duration".equals(propName)) {
            return new PropertyComparator<AbstractExchange, Long>(order, exc -> exc.getTimeResReceived() - exc.getTimeReqSent());
        }
        if ("msgFilePath".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, exc -> exc.getRequest().getMethod());
        }
        if ("time".equals(propName)) {
            return new PropertyComparator<AbstractExchange, String>(order, ExchangesUtil::getTime);
        }
        throw new IllegalArgumentException("AbstractExchange can't be compared using property [" + propName + "]");
    }

    public static Comparator<AbstractServiceProxy> getAbstractServiceProxyComparator(String propName, String order) {
        return switch (propName) {
            case "listenPort" -> new PropertyComparator<AbstractServiceProxy, Integer>(order, p -> p.getKey().getPort());
            case "virtualHost" -> new PropertyComparator<AbstractServiceProxy, String>(order, p -> p.getKey().getHost());
            case "method" -> new PropertyComparator<AbstractServiceProxy, String>(order, p -> p.getKey().getMethod());
            case "path" -> new PropertyComparator<AbstractServiceProxy, String>(order, p -> p.getKey().getPath());
            case "targetHost" -> new PropertyComparator<AbstractServiceProxy, String>(order, AbstractServiceProxy::getTargetHost);
            case "targetPort" -> new PropertyComparator<AbstractServiceProxy, Integer>(order, AbstractServiceProxy::getTargetPort);
            case "count" -> new PropertyComparator<AbstractServiceProxy, Integer>(order, p -> p.getStatisticCollector().getCount());
            case "name" -> new PropertyComparator<AbstractServiceProxy, String>(order, AbstractProxy::toString);
            default -> throw new IllegalArgumentException("AbstractServiceProxy can't be compared using property [" + propName + "]");
        };
    }

    public static Comparator<ClientStatistics> getClientStatisticsComparator(String propName, String order) {
        return switch (propName) {
            case "name" -> new PropertyComparator<ClientStatistics, String>(order, ClientStatistics::getClient);
            case "count" -> new PropertyComparator<ClientStatistics, Integer>(order, ClientStatistics::getCount);
            case "min" -> new PropertyComparator<ClientStatistics, Long>(order, ClientStatistics::getMinDuration);
            case "max" -> new PropertyComparator<ClientStatistics, Long>(order, ClientStatistics::getMaxDuration);
            case "avg" -> new PropertyComparator<ClientStatistics, Long>(order, ClientStatistics::getAvgDuration);
            default -> throw new IllegalArgumentException("ClientsStatistics can't be compared using property [" + propName + "]");
        };
    }
}

